<?php

$lzLuzukSliderSingleChoice = getLuzukPostsType('slider');

// CREATING A SECTION IN CUSTOMIZER
$wp_customize->add_section(
	'premium_slider_section',
	array(
		'title' => __( 'Slider Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel',
		'priority' =>18
	)
);

// show content in slider
$wp_customize->add_setting(
	'premium_slider_show_content',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'premium_slider_show_content',
		array(
			'settings'      => 'premium_slider_show_content',
			'section'       => 'premium_slider_section',
			'label'         => __( 'Hide Title and description on slider', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'No', 'luzuk-premium' ),
				'off' => __( 'Yes', 'luzuk-premium' )
			),
		)
	)
);

$wp_customize->add_setting('luzuk_premium_slider_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Info_Text( 
		$wp_customize,
		'luzuk_premium_slider_section_lbl',
		array(
			'settings'		=> 'luzuk_premium_slider_section_lbl',
			'section'		=> 'premium_slider_section',
			'label'			=> __( 'Note:', 'luzuk-premium' ),	
			'description'	=> __( 'The Page featured image works as a slider banner and the title & content work as a slider caption. And you can add this from the Slider menu. <br/> Recommended Image Size: 1400X588', 'luzuk-premium' ),
		)
	)
);

// Slider Title color
addColorPalatOption($wp_customize, 'slider_TitleColor', 'premium_slider_section', 'Slider Title Color', '#fff');

// Slider Title highlight color
addColorPalatOption($wp_customize, 'slider_TitlespanColor', 'premium_slider_section', 'Slider Title Highlight Color', '#e9bf08');

// Slider text color
addColorPalatOption($wp_customize, 'slider_textColor', 'premium_slider_section', 'Slider Text Color', '#fff');

// Slider Button Text color
addColorPalatOption($wp_customize, 'slider_buttontextColor', 'premium_slider_section', 'Slider Button Text Color', '#101930');

// Slider Button Text hover color
addColorPalatOption($wp_customize, 'slider_buttontexthoverColor', 'premium_slider_section', 'Slider Button Text Hover Color', '#e9bf08');

// Slider Button bg color
addColorPalatOption($wp_customize, 'slider_buttonbgColor', 'premium_slider_section', 'Slider Button Background Color', '#e9bf08');

// Slider Button bg hover color
addColorPalatOption($wp_customize, 'slider_buttonbghoverColor', 'premium_slider_section', 'Slider Button Background Hover Color', '#fff');

// Slider box color
addColorPalatOption($wp_customize, 'slider_boxColor', 'premium_slider_section', 'Slider Box Color', '#182849');

// Slider box color
addColorPalatOption($wp_customize, 'slider_boxborderColor', 'premium_slider_section', 'Slider Box Border Color', '#e9bf08');


// Slider box icon color
addColorPalatOption($wp_customize, 'slider_boxiconColor', 'premium_slider_section', 'Slider Box Icon Color', '#182848');

// Slider box icon bg color
addColorPalatOption($wp_customize, 'slider_boxiconbgColor', 'premium_slider_section', 'Slider Box Icon Background Color', '#e9bf08');


// Slider Prev Next Button bg color
addColorPalatOption($wp_customize, 'slider_nextprevbgColor', 'premium_slider_section', 'Slider Prev Next Button Background Color', '#0b1224');

// SliderPrev Next Button bg hover color
addColorPalatOption($wp_customize, 'slider_nextprevbghoverColor', 'premium_slider_section', 'Slider Prev Next Button Background Hover Color', '#e9bf08');