<?php
/**
 * Createing whychooseus pannel for customizer
 *
 */

// START whychooseus SECTION 
    $wp_customize->add_section(
        'premium_whychooseus_section',
        array(
            'title' => __( 'Why Choose Us Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    // ENABLE/DISABLE whychooseus SECTION
    $wp_customize->add_setting(
        'premium_whychooseus_section_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'premium_whychooseus_section_disable',
            array(
                'settings'      => 'premium_whychooseus_section_disable',
                'section'       => 'premium_whychooseus_section',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    );
backgroundManager($wp_customize, 'whychooseus', 'premium_whychooseus_section', $color='#f8f8f8', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'whychooseussection_padding', 'premium_whychooseus_section', ' Section Padding Setting:');

$wp_customize->add_setting(
    'whychooseussection_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'whychooseussection_toppadding',
    array(
        'settings'      => 'whychooseussection_toppadding',
        'section'       => 'premium_whychooseus_section',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'whychooseussection_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'whychooseussection_bottompadding',
    array(
        'settings'      => 'whychooseussection_bottompadding',
        'section'       => 'premium_whychooseus_section',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'whychooseussection_leftpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'whychooseussection_leftpadding',
    array(
        'settings'      => 'whychooseussection_leftpadding',
        'section'       => 'premium_whychooseus_section',
        'type'          => 'text',
        'label'         => __( 'Section Left Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'whychooseussection_rightpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'whychooseussection_rightpadding',
    array(
        'settings'      => 'whychooseussection_rightpadding',
        'section'       => 'premium_whychooseus_section',
        'type'          => 'text',
        'label'         => __( 'Section Right Padding', 'luzuk-premium' )
    )
);


    $wp_customize->add_setting(
        'whychooseus_title_heading',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'whychooseus_title_heading',
            array(
                'settings'      => 'whychooseus_title_heading',
                'section'       => 'premium_whychooseus_section',
                'label'         => __( 'Section Title', 'Luzuk Premium' ),
            )
        )
    );    

   $wp_customize->add_setting(
        'whychooseus_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Heading Here', 'Luzuk Premium' )
        )
    );
    $wp_customize->add_control(
        'whychooseus_title',
        array(
            'settings'      => 'whychooseus_title',
            'section'       => 'premium_whychooseus_section',
            'type'          => 'text',
            'label'         => __( 'Heading', 'Luzuk Premium' )
        )
    );


addColorPalatOption($wp_customize, 'whychooseus_subHeadingColor', 'premium_whychooseus_section', 'Select Section Heading color', '#FFF');

addColorPalatOption($wp_customize, 'whychooseus_subHeadingbgColor', 'premium_whychooseus_section', 'Select Section Heading Background color', '#182849');


     $wp_customize->add_setting(
        'whychooseus_maintitle',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'WHY CHOOSE US', 'Luzuk Premium' )
        )
    );
    $wp_customize->add_control(
        'whychooseus_maintitle',
        array(
            'settings'      => 'whychooseus_maintitle',
            'section'       => 'premium_whychooseus_section',
            'type'          => 'text',
            'label'         => __( 'Main Heading', 'Luzuk Premium' )
        )
    );

addColorPalatOption($wp_customize, 'whychooseus_HeadingColor', 'premium_whychooseus_section', 'Select Section Main Heading color', '#182849');


addColorPalatOption($wp_customize, 'whychooseus_HeadingborderColor', 'premium_whychooseus_section', 'Select Section Main Heading Border color', '#e9bf08');


 $wp_customize->add_setting(
        'whychooseus_text',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Donec ultrices, diam sed efficitur semper, diam lectus malesuada nisl, eget congue nisl ligula non purus. Phasellus at dapibus magna. Ut imperdiet nequ', 'Luzuk Premium' )
        )
    );
    $wp_customize->add_control(
        'whychooseus_text',
        array(
            'settings'      => 'whychooseus_text',
            'section'       => 'premium_whychooseus_section',
            'type'          => 'textarea',
            'label'         => __( 'Section Text', 'Luzuk Premium' )
        )
    );

      // Section Text color
    addColorPalatOption($wp_customize, 'whychooseus_textColor', 'premium_whychooseus_section', 'Section Text color', '#323232');

  
$wp_customize->add_setting('whychooseus_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'whychooseus_npp_heading',
        array(
            'settings'      => 'whychooseus_npp_heading',
            'section'       => 'premium_whychooseus_section',
            'label'         => __( 'Number Of Why Choose Us Plans', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('whychooseus_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 5));
$wp_customize->add_control(
    'whychooseus_npp_count',
    array(
        'settings'      => 'whychooseus_npp_count',
        'section'       => 'premium_whychooseus_section',
        'type'          => 'select',
        'label'         => __( 'Number of plan to show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9)
    )
);

$wp_customize->add_setting('whychooseus_section_imgnotelabel', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'whychooseus_section_imgnotelabel',
        array(
            'settings'      => 'whychooseus_section_imgnotelabel',
            'section'       => 'premium_whychooseus_section',
            'label'         => __( 'Note:', 'Luzuk' ),    
            'description'   => __( 'Changes Will not reflect untill you select Image', 'Luzuk' ),
        )
    )
);

//whychooseus PAGES
for( $i = 1; $i <= 9; $i++ ){
    $wp_customize->add_setting(
        'whychooseus_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'whychooseus_header'.$i,
            array(
                'settings'      => 'whychooseus_header'.$i,
                'section'       => 'premium_whychooseus_section',
                'label'         => __( 'Why Choose Us Page ', 'luzuk-premium' ).$i
            )
        )
    );

     lzAddImageElement($wp_customize, 'whychooseus_page_icon1'.$i, 'premium_whychooseus_section', $label=" Kindly Add Equal Size Of Image. Recommended Image Size: 385px X 280px");

     lzAddElement($wp_customize, 'whychooseus_page_url_'.$i, 'premium_whychooseus_section', $type = 'text', $label="Icon Link", $callback ='esc_url', $default='Add link here');

     $wp_customize->add_setting(
        'whychooseus_page_icon'.$i,
        array(
            'default'           => 'fa fa-user',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'whychooseus_page_icon'.$i,
            array(
                'settings'      => 'whychooseus_page_icon'.$i,
                'section'       => 'premium_whychooseus_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );

lzAddElement($wp_customize, 'whychooseus_page_title_'.$i, 'premium_whychooseus_section', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='PROFESSIONAL GUARDS');
    
}

   // img overlay color
    addColorPalatOption($wp_customize, 'whychooseus_imgoverlayColor', 'premium_whychooseus_section', 'Image Overlay color', '#182849');

       // img overlay icon color
    addColorPalatOption($wp_customize, 'whychooseus_imgoverlayiconColor', 'premium_whychooseus_section', 'Image Overlay Icon color', '#fff');

        // img overlay icon border color
    addColorPalatOption($wp_customize, 'whychooseus_imgoverlayiconborderColor', 'premium_whychooseus_section', 'Image Overlay Icon Border color', '#fff');

       // img overlay icon hover color
    addColorPalatOption($wp_customize, 'whychooseus_imgoverlayiconhoverColor', 'premium_whychooseus_section', 'Image Overlay Icon Hover color', '#e9bf08');

        // img overlay icon border hover color
    addColorPalatOption($wp_customize, 'whychooseus_imgoverlayiconborderhoverColor', 'premium_whychooseus_section', 'Image Overlay Icon Border Hover color', '#e9bf08');

     // icon color
    addColorPalatOption($wp_customize, 'whychooseus_iconColor', 'premium_whychooseus_section', 'Icon color', '#e9bf08');

    // icon hover color
    addColorPalatOption($wp_customize, 'whychooseus_iconhoverColor', 'premium_whychooseus_section', 'Icon hover color', '#0e1a30');

 // title color
    addColorPalatOption($wp_customize, 'whychooseus_titleColor', 'premium_whychooseus_section', 'Title color', '#fff');

     // title hover color
    addColorPalatOption($wp_customize, 'whychooseus_titlehoverColor', 'premium_whychooseus_section', 'Title hover color', '#0e1a30');

     // Content box color
    addColorPalatOption($wp_customize, 'whychooseus_contentboxColor', 'premium_whychooseus_section', 'Content Box color', '#182849');

    // Content box hover color
    addColorPalatOption($wp_customize, 'whychooseus_contentboxhoverColor', 'premium_whychooseus_section', 'Content Box Hover color', '#e9bf09');
// End whychooseus section 