<?php 
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Luzuk Premium
 */
get_header(); ?>
<header class="page-main-header">
    <div>
        <?php $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));?>
        <?php
        //print_r ($post);
            if (!empty($image)){
                echo '<img src="'.$image.'" class="ht-page-header-img" />';
            }
        ?>
        <!-- <img src="<?php //echo !empty($image)?$image : get_template_directory_uri().'/images/innerpage.jpg';?>" class="ht-page-header-img" alt="<?php //the_title();?>" /> -->
    </div>
    <div class="container">
        <?php the_title( '<h1 class="ht-main-title">', '</h1>' ); ?>
        <div class="clearfix"></div>
    </div>

</header><!-- .entry-header -->

 <?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'show') :
        ?>
        <div class="breadcrumbbox">
            <div class="container">
                <div class='button'><?php luzuk_lite_the_breadcrumb(); ?></div>
                <!--  <?php //luzuk_lite_the_breadcrumb(); ?> -->
            </div>
        </div>

    <?php endif ?>    

<?php 
            if( get_theme_mod('innerpagesbox_toppadding',true) ) {
                $innerpagesbox_toppadding = 'padding-top:'.esc_attr(get_theme_mod('innerpagesbox_toppadding')).';';
            }
            if( get_theme_mod('innerpagesbox_bottompadding',true) ) {
                $innerpagesbox_bottompadding = 'padding-bottom:'.esc_attr(get_theme_mod('innerpagesbox_bottompadding')).';';
            }
            if( get_theme_mod('innerpagesbox_leftpadding',true) ) {
                $innerpagesbox_leftpadding = 'padding-left:'.esc_attr(get_theme_mod('innerpagesbox_leftpadding')).';';
            }
            if( get_theme_mod('innerpagesbox_rightpadding',true) ) {
                $innerpagesbox_rightpadding = 'padding-right:'.esc_attr(get_theme_mod('innerpagesbox_rightpadding')).';';
            }
    ?>

<main id="innerpage-box" style="<?php echo esc_attr($innerpagesbox_toppadding); ?>" "<?php echo esc_attr($innerpagesbox_bottompadding); ?>" "<?php echo esc_attr($innerpagesbox_leftpadding); ?>" "<?php echo esc_attr($innerpagesbox_rightpadding); ?>">
    <div class="container">
        <?php 
            if( get_theme_mod('pages_h1font',true) ) {
                $pages_h1font = 'font-size:'.esc_attr(get_theme_mod('pages_h1font')).';';
            }
            if( get_theme_mod('pages_h2font',true) ) {
                $pages_h2font = 'font-size:'.esc_attr(get_theme_mod('pages_h2font')).';';
            }
            if( get_theme_mod('pages_h3font',true) ) {
                $pages_h3font = 'font-size:'.esc_attr(get_theme_mod('pages_h3font')).';';
            }
            if( get_theme_mod('pages_h4font',true) ) {
                $pages_h4font = 'font-size:'.esc_attr(get_theme_mod('pages_h4font')).';';
            }
            if( get_theme_mod('pages_h5font',true) ) {
                $pages_h5font = 'font-size:'.esc_attr(get_theme_mod('pages_h5font')).';';
            }
            if( get_theme_mod('pages_h6font',true) ) {
                $pages_h6font = 'font-size:'.esc_attr(get_theme_mod('pages_h6font')).';';
            }

        ?>

        <div id="content-box" class="innerpage-whitebox" style="<?php echo esc_attr($pages_h1font); ?>" "<?php echo esc_attr($pages_h2font); ?>" "<?php echo esc_attr($pages_h3font); ?>" "<?php echo esc_attr($pages_h4font); ?>" "<?php echo esc_attr($pages_h5font); ?>" "<?php echo esc_attr($pages_h6font); ?>">
            <?php while ( have_posts() ) : the_post(); ?>
                <?php get_template_part( 'template-parts/content', 'page' ); ?>
                <?php
                // If comments are open or we have at least one comment, load up the comment template.
                if ( comments_open() || get_comments_number() ) :
                    comments_template();
                endif;
                ?>
            <?php endwhile; // End of the loop. ?>
            <div class="clearfix"></div>
        </div><!-- #main -->
        <div class="clearfix"></div>
        
        <div class="pagingation"> 
            <?php lzGetPagination($query);?>
        </div>
    </div>
</main><!-- #main -->
<?php get_footer(); ?>
