<?php 

/**
 * Use for the show the testimonials at home page and in testimonial page with shortcode
 * @param int $pageId default is null the id of a post
 * @param boolean $isCustomizer default is false if set to true it mean the output is set for the home page
 * @param int $i default null
 * @param boolean $showStaticVals default is false
 * @return string
 * @author Luzuk <support@luzuk.com>
 * */

/*services*/
function ctserviceShortCode($pageId = null, $isCustomizer = false, $i = null) {
    ob_start();
    $args = array('post_type' => 'our-service'); 
    if (!empty($pageId)) {
        $args['page_id'] = absint($pageId);
    }
    $args['posts_per_page'] = -1;
    $colCls = '';
    // if($isCustomizer == true){
    $cols = get_theme_mod('luzuk_ct_service_npp_count',7);  
    $luzuk_ct_service_icon1 = get_theme_mod('luzuk_ct_service_icon1'.$i);
    ++$cols;
    switch ($cols) {
       case 1:
       $colCls = 'col-md-12 col-sm-12';
       break;
       case 2:
       $colCls = 'col-md-6 col-sm-6';
       break;        
       $colCls = 'col-md-2 col-sm-6';
       break;
       case 3:
       case 5:                             
       case 9:
       case 6: 
       case 4: 
       case 7:
       case 8:  
       case 10:
       case 11:
       case 12:
       case 13:
       case 14:
       case 15:
       case 16:
       case 17:
       case 18:
       $colCls = 'col-md-2 col-sm-6';
       break;
       default: 
       $colCls = 'col-md-2 col-sm-6';
       break;
   }
   $icons = array(1=>'heart', 2=>'star', 3=>'flash', 4=>'bell',5=>'heart', 6=>'star', 7=>'flash', 8=>'bell');  
    // }
   $text = '';
   $query = new WP_Query($args);
   if ($query->have_posts()):
    $postN = 0;

    while ($query->have_posts()) : $query->the_post();
        $luzuk_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'total-service-thumb');
        $post = get_post();
        ?>
        <div class="row">
            <div class="<?php echo $colCls; ?> complete-serbox">
               <div class="service-icon padding0 ">

                   <!-- <i class="<?php //echo $luzuk_ct_service_icon1; ?>"></i> -->
                   <a href="<?php the_permalink(); ?>">
                       <?php
                       if (has_post_thumbnail()) {
                        $image_url = $luzuk_image[0];
                    } else {
                        $image_url = get_template_directory_uri() . '/images/project.jpg';
                    }
                    ?>                                                          
                    <img class="secondry-bg img-responsive" src="<?php echo esc_url($image_url); ?>" alt="<?php the_title(); ?>" />
                </a>
            </div>
            <div class="serviceBox blue">

                <a href="<?php the_permalink(); ?>"> <h3 class="title"><?php the_title(); ?></h3> </a>

            </div>
            <div class="clearfix"></div>           

        </div>
        <?php
    endwhile;
    $text = ob_get_contents();
    ob_clean();
endif;
wp_reset_postdata();
return $text;
}
/*gallery*/

function galleryShortCode($pageId = null, $isCustomizer = false, $i = null) {

    ob_start();

    $args = array('post_type' => 'our_gallery');
    if (!empty($pageId)) {
        $args['page_id'] = absint($pageId);
    }
    $args['posts_per_page'] = -1;
    $colCls = '';
    // if($isCustomizer == true){
    $cols = get_theme_mod('lz_luzuk_gallery_npp_count', 19);  
    ++$cols;
    switch($cols){
        case 1:
        $colCls = 'col-md-12 col-sm-12';
        break;
        case 2:
        $colCls = 'col-md-6 col-sm-6';
        break;
        case 4:
        case 3:
        case 5:
        case 6:
        $colCls = 'col-md-3 col-sm-4';
        break;
        default: 
        $colCls = 'col-md-3 col-sm-4';
        break;
    }
    // }
    $text = '';
    $query = new WP_Query($args);
    if ($query->have_posts()):
        $postN = 0;

        while ($query->have_posts()) : $query->the_post();
            $lz_luzuk_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'medium_large');
            if ($isCustomizer === true) {
            } else {
                
            }

            $post = get_post();
            
            if (($postN % 3) == 0 && $isCustomizer == false) {
                ?>
                <div class="clearfix paddingBot20"></div>
            </div>
            <div class="row">
                <?php
            }
            ++$postN;
            ?>
            <div class="item <?php //echo $colCls; ?> gallery-img">
                <div class="ht-gallery-member">
                    <div class="gallery-image">
                        <?php
                        if (has_post_thumbnail()) {
                            $image_url = $lz_luzuk_image[0];
                        } else {
                            $image_url = get_template_directory_uri() . '/images/about1.jpg';
                        }
                        ?>
                        <a class="group1" href="<?php echo esc_url($image_url); ?>" title="<?php the_title(); ?>"> <img class="secondry-bg img-responsive" src="<?php echo esc_url($image_url); ?>" alt="" /> 
                            <div class="overlay-box"><h4><?php the_title(); ?></h4></div>                              

                        </a>
                    </div>

                    <?php ?>
                    <?php                                   
                    
                    ?>
                    
                </div>
                <div class="col-md-4 col-sm-6 gbox">
                    <div class=" gallerybox">
                       <?php
                       if (has_post_thumbnail()) {
                        $image_url = $lz_luzuk_image[0];
                    } else {
                        $image_url = get_template_directory_uri() . '/images/about1.jpg';
                    }
                    ?>
                    <a class="group1" href="<?php echo esc_url($image_url); ?>" title="<?php the_title(); ?>"> <img class="secondry-bg img-responsive" src="<?php echo esc_url($image_url); ?>" alt="" /> 
                    </a>
                    <div class="box-content">
                        <h3 class="title"><?php the_title(); ?></h3>                   
                    </div>
                    <ul class="icon">
                        <li><a class="group1" href="<?php echo esc_url($image_url); ?>" title="<?php the_title(); ?>"><i class="fa fa-search"></i></a></li>                    
                    </ul>
                </div><!--end -->
            </div>

        </div>

        <?php
    endwhile;
    $text = ob_get_contents();
    ob_clean();
endif;
wp_reset_postdata();
return $text;
}

function testimonialShortCode($pageId = null, $isCustomizer = false, $i = null) {

    ob_start();

    $args = array('post_type' => 'ourtestimonial');
    if (!empty($pageId)) {
        $args['page_id'] = absint($pageId);
    }
    $colCls = '';
    // if($isCustomizer == true){
    $cols = get_theme_mod('lz_luzuk_test_npp_count', 2);
    $cols++;
    switch($cols){

    }
    $icons = array(1=>'heart', 2=>'star', 3=>'flash', 4=>'bell',5=>'heart', 6=>'star', 7=>'flash', 8=>'bell');     
    // }
    $text = '';
    $query = new WP_Query($args);
    if ($query->have_posts()):
        $postN = 0;

        while ($query->have_posts()) : $query->the_post();
            $lz_luzuk_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'total-team-thumb');
            if ($isCustomizer === true) {
                $lz_luzuk_test_designation = get_theme_mod('lz_luzuk_test_designation' . $i);
            }
            $post = get_post();
            //designation
            $designation = get_post_meta($post->ID, 'designation', false);
            $lz_luzuk_test_designation = !empty($designation[0]) ? $designation[0] : '';

            if (($postN % 3) == 0 && $isCustomizer == false) {
                ?>
                <div class="clearfix paddingBot20"></div>
            </div>
            <div class="row">
                <?php
            }
            ++$postN;
            ?>
            <div class="<?php echo $colCls; ?>">
                <div class="innerbor"></div>
                <div class="ht-test-member ">
                    <div class="test-content">
                      <div class="member-image col-md-6 padding0">
                          <img src="<?php echo (!empty($lz_luzuk_image[0])) ? $lz_luzuk_image[0] : get_template_directory_uri() . '/images/team-thumb.png' ?>" class="img-responsive" alt="<?php the_title(); ?>" />
                      </div>
                      <div class="testimonial-content">                      
                          <p><?php 
                          if(has_excerpt()){
                              echo get_the_excerpt();
                          }else{
                              echo luzuk_excerpt( get_the_content() , 150 );
                          }
                          ?></p>
                          <div class="clearfix"></div>   
                          <h6 class="member-name"><?php the_title(); ?></h6>
                          <div class="clearfix"></div> 
                      </div>
                      <div class="clearfix"></div> 
                  </div>   

                  <?php
                  ?> 

                  
                  <div class="clearfix"></div>
              </div>
          </div>
          <?php
      endwhile;
      $text = ob_get_contents();
      ob_clean();
  endif;
  wp_reset_postdata();
  return $text;
}


// Services Shortcode:
function serviceInnerShortCode($pageId = null, $isCustomizer = false, $i = null) {
    ob_start();
    $args = array('post_type' => 'our-service'); 
    if (!empty($pageId)) {
        $args['page_id'] = absint($pageId);
    }
    $args['posts_per_page'] = -1;
    $colCls = '';
    // if($isCustomizer == true){
    $cols = get_theme_mod('luzuk_ct_service_npp_count',7);  
    $luzuk_ct_service_icon1 = get_theme_mod('luzuk_ct_service_icon1'.$i);
    ++$cols;
    switch ($cols) {
    }
    $icons = array(1=>'heart', 2=>'star', 3=>'flash', 4=>'bell',5=>'heart', 6=>'star', 7=>'flash', 8=>'bell');  
    $text = '';
    $query = new WP_Query($args);
    if ($query->have_posts()):
        $postN = 0;

        while ($query->have_posts()) : $query->the_post();
            $luzuk_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'total-service-thumb');
            $post = get_post();
            ?>
            <div class="row">
                <div class="col-md-3 col-sm-6 col-xs-12">
                    <figure class="services-inner-wrapper">
                       <?php
                       if (has_post_thumbnail()) {
                        $image_url = $luzuk_image[0];
                    } else {
                        $image_url = get_template_directory_uri() . '/images/project.jpg';
                    }
                    ?>                                                          
                    <img class="secondry-bg img-responsive" src="<?php echo esc_url($image_url); ?>" alt="<?php the_title(); ?>" />

                    <img class="secondry-bg img-responsive" src="<?php echo esc_url($image_url); ?>" alt="<?php the_title(); ?>" />
                    <figcaption>
                        <h3><?php the_title(); ?></h3>
                    </figcaption>
                    <a href="<?php the_permalink(); ?>"></a>
                </figure>
            </div>
            <?php
        endwhile;
        $text = ob_get_contents();
        ob_clean();
    endif;
    wp_reset_postdata();
    return $text;
}


add_shortcode('SERVICES', 'serviceInnerShortCode');


