<?php
$wp_customize->add_section(
    'luzuk_premium_aboutconstruction_section',
    array(
        'title' => __( 'About Us Section', 'lz-fitness-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
$wp_customize->add_setting(
    'luzuk_premium_aboutconstruction_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'luzuk_premium_aboutconstruction_section_disable',
        array(
            'settings'      => 'luzuk_premium_aboutconstruction_section_disable',
            'section'       => 'luzuk_premium_aboutconstruction_section',
            'label'         => __( 'Disable Section', 'lz-fitness-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'lz-fitness-premium' ),
                'off' => __( 'No', 'lz-fitness-premium' )
            ),
        )
    )
);
backgroundManager($wp_customize, 'about', 'luzuk_premium_aboutconstruction_section', $color='#ffffff'); 
addColorPalatOption($wp_customize, 'luzuk_aboutusection_animatedbx_Color', 'luzuk_premium_aboutconstruction_section', 'Select Image svg Dots color', '#538df8');
lzCustomLable($wp_customize, 'luzuk_aboutus_left1imagelblbuttonabtdisplay', 'luzuk_premium_aboutconstruction_section', 'About Left Image:');

$wp_customize->add_setting(
    'luzuk_about_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'luzuk_about_image',
        array(
            'section' => 'luzuk_premium_aboutconstruction_section',
            'settings' => 'luzuk_about_image',
            'description' => __('Recommended Image Size: 500X600px', 'lz-fitness-premium')
        )
    )
);
$wp_customize->add_setting(
    'luzuk_aboutconstruction_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'luzuk_aboutconstruction_title_heading',
        array(
            'settings'      => 'luzuk_aboutconstruction_title_heading',
            'section'       => 'luzuk_premium_aboutconstruction_section',
            'label'         => __( 'About Us Title & Text', 'lz-fitness-premium' ),
        )
    )
);    
$wp_customize->add_setting(
    'luzuk_aboutconstruction_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'About Us', 'lz-fitness-premium' )
    )
);
$wp_customize->add_control(
    'luzuk_aboutconstruction_title',
    array(
        'settings'      => 'luzuk_aboutconstruction_title',
        'section'       => 'luzuk_premium_aboutconstruction_section',
        'type'          => 'text',
        'label'         => __( 'Title for section', 'lz-fitness-premium' )
    )
);

addColorPalatOption($wp_customize, 'luzuk_aboutconstruction_HeadingColor', 'luzuk_premium_aboutconstruction_section', 'Section Title color', '#3b3b3b');

addColorPalatOption($wp_customize, 'aboutconstruction_HeadingborColor', 'luzuk_premium_aboutconstruction_section', 'Title Border color', '#f5bf1d');

addColorPalatOption($wp_customize, 'aboutconstruction_HeadingboriconColor', 'luzuk_premium_aboutconstruction_section', 'Title Border Icon color', '#ff6751');


$wp_customize->add_setting(
    'luzuk_aboutconstruction_text',
    array(
        'sanitize_callback'=>'luzuk_sanitize_text',
        'default'=> __('Donec ultrices, diam sed efficitur semper, diam lectus malesuada nisl, eget congue nisl ligula non purus. Phasellus at dapibus magna. Ut imperdiet neque a sem pellentesque venenatis. Sed efficitur arcu ac sapien pharetra, id feugiat dolor luctus. Aenean placerat mi eu enim porta dictum. Cras eu nulla vel mauris tristique vulputate laoreet in lorem. Vestibulum ut sem non tortor.', 'lz-fitness-premium')
    )
);
$wp_customize->add_control(
    'luzuk_aboutconstruction_text',
    array(
        'settings' =>'luzuk_aboutconstruction_text',
        'section' => 'luzuk_premium_aboutconstruction_section',
        'type'=> 'textarea',
        'label'=> __('Content for the section', 'lz-fitness-premium')
    )
);

addColorPalatOption($wp_customize, 'luzuk_aboutconstruction_contentColor', 'luzuk_premium_aboutconstruction_section', 'Content Text color', '#2f2f2f');    



lzCustomLable($wp_customize, 'luzuk_premium_aboutsectionbutton1display', 'luzuk_premium_aboutconstruction_section', 'Button Display, Button Text & Button Colors Setting:');
// to show & hide another button
$wp_customize->add_setting( 'aboutusection_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'aboutusection_button_display', array( 'label' => 'Button Display', 'section' => 'luzuk_premium_aboutconstruction_section', 'settings' => 'aboutusection_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button

$wp_customize->add_setting(
    'luzuk_aboutussection_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'READ MORE' )
    )
);
$wp_customize->add_control(
    'luzuk_aboutussection_txt',
    array(
        'settings'      => 'luzuk_aboutussection_txt',
        'section'       => 'luzuk_premium_aboutconstruction_section',
        'type'          => 'text',
        'label'         => __( 'Add Button Text Here:', 'luzuk' )
    )
);
$wp_customize->add_setting('luzuk_aboutusectionlink',   array('default'=> 'add Button link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('luzuk_aboutusectionlink',
    array(
        'settings'      => 'luzuk_aboutusectionlink',
        'section'       => 'luzuk_premium_aboutconstruction_section',
        'type'          => 'url',
        'label'         => __( 'Add Button Url Here:', 'Luzuk' )
    )
);


addColorPalatOption($wp_customize, 'luzuk_aboutusection_Buttontxt_Color', 'luzuk_premium_aboutconstruction_section', 'Select Button Text/Icon color', '#ff6752');

addColorPalatOption($wp_customize, 'luzuk_aboutusection_Buttontxthvr_Color', 'luzuk_premium_aboutconstruction_section', 'Select Button Text Hover color', '#ffca2a');


addColorPalatOption($wp_customize, 'luzuk_aboutusection_Buttonbordercl_Color', 'luzuk_premium_aboutconstruction_section', 'Select Button Border color', '#ff6752');

addColorPalatOption($wp_customize, 'luzuk_aboutusection_Buttonborderhvrcl_Color', 'luzuk_premium_aboutconstruction_section', 'Select Button Border Hover color', '#ffca2a');








