<?php   
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css?family=Poppins:400,500,600,700&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Raleway:ital,wght@0,100;0,200;0,500;0,600;0,700;0,800;0,900;1,100;1,500;1,600&display=swap" rel="stylesheet">


	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-scrollbar.js" ></script>

	
	<?php wp_head(); ?>
<script type="text/javascript">
            $(document).ready(function () {
               
                $("#progress-bar").onscroll();
                
            });
        </script>
</head>

<body <?php body_class(); ?>>
	<div id="progress-bar"></div>
	<div class="main-container">
		<!-- <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'Luzuk' ); ?></a> -->
		<div id="loading-area"><div class="la-anim-10"></div></div>
		<!-- header -->

		<?php 
		if( get_theme_mod('pages_logoTmargin',true) ) {
			$pages_logoTmargin = 'padding-top:'.esc_attr(get_theme_mod('pages_logoTmargin')).';';
		}
		if( get_theme_mod('pages_logoBmargin',true) ) {
			$pages_logoBmargin = 'padding-bottom:'.esc_attr(get_theme_mod('pages_logoBmargin')).';';
		}
		if( get_theme_mod('pages_logoLmargin',true) ) {
			$pages_logoLmargin = 'padding-left:'.esc_attr(get_theme_mod('pages_logoLmargin')).';';
		}
		if( get_theme_mod('pages_logoRmargin',true) ) {
			$pages_logoRmargin = 'padding-right:'.esc_attr(get_theme_mod('pages_logoRmargin')).';';
		}
		?>


		<header class="site-header header-transparent mo-left header header-seo" style="<?php echo esc_attr($pages_logoTmargin); ?>" "<?php echo esc_attr($pages_logoBmargin); ?>" "<?php echo esc_attr($pages_logoLmargin); ?>" "<?php echo esc_attr($pages_logoRmargin); ?>">
	<div class="header-leftsvg"><svg viewBox="0 0 500 150" preserveAspectRatio="none" style="height: 100%; width: 100%;"><path d="M154.62,-3.45 C152.36,107.06 35.55,62.66 0.00,149.50 L-2.25,143.58 L0.00,0.00 Z" style="stroke: none; "></path></svg></div>
			
			<div class="container heade-border">
				<?php 
				if( get_theme_mod('pages_logoboxtoppostionset',true) ) {
					$pages_logoboxtoppostionset = 'padding-top:'.esc_attr(get_theme_mod('pages_logoboxtoppostionset')).';';
				}
				
				?>

				<div class="col-md-3 col-sm-6 col-xs-8 logo"> 
					
					<div class="logobox">
						<?php 
						if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
							the_custom_logo();
					else : 
						if ( is_front_page() ) : ?>
							<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php else : ?>
								<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
							<?php endif; ?>
						<?php endif; ?>
						<!-- .site-branding -->
					</div>
					<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p> 
					
				</div>
				<!-- main header -->
				<div class="col-md-7 col-sm-6 col-xs-4  sticky-header main-bar-wraper navbar-expand-lg padding0">
					<?php 
							if( get_theme_mod('pages_BottomHeaderTpadding',true) ) {
								$pages_BottomHeaderTpadding = 'padding-top:'.esc_attr(get_theme_mod('pages_BottomHeaderTpadding')).';';
							}
							if( get_theme_mod('pages_BottomHeaderBpadding',true) ) {
								$pages_BottomHeaderBpadding = 'padding-bottom:'.esc_attr(get_theme_mod('pages_BottomHeaderBpadding')).';';
							}
							if( get_theme_mod('pages_BottomHeaderLpadding',true) ) {
								$pages_BottomHeaderLpadding = 'padding-left:'.esc_attr(get_theme_mod('pages_BottomHeaderLpadding')).';';
							}
							if( get_theme_mod('pages_BottomHeaderRpadding',true) ) {
								$pages_BottomHeaderRpadding = 'padding-right:'.esc_attr(get_theme_mod('pages_BottomHeaderRpadding')).';';
							}
							?>

				 <div class="site-navigation" style="<?php echo esc_attr($pages_BottomHeaderTpadding); ?>" "<?php echo esc_attr($pages_BottomHeaderRpadding); ?>" "<?php echo esc_attr($pages_BottomHeaderLpadding); ?>" "<?php echo esc_attr($pages_BottomHeaderRpadding); ?>">
                        <div class="hamburger-menus">
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                        <nav class="navigation">
                            <div class="overlaybg"></div><!--  /.overlaybg -->
                            <!-- Main Menu -->
                            <div class="menu-wrapper">
                                <div class="menu-content">
                                    <?php
                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
                                            wp_nav_menu ( array(
                                                'menu_class' => 'mainmenu',
                                                'container'=> 'ul',
                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
                                                'theme_location' => 'primary',  
                                            )); 
                                        } else {
                                            wp_nav_menu ( array(
                                                'menu_class' => 'mainmenu',
                                                'container'=> 'ul',
                                                'theme_location' => 'primary',  
                                            )); 
                                        }
                                    ?>
                                </div> <!-- /.hours-content-->
						
                     </div><!-- /.menu-wrapper --> 
                        </nav>
                        <div class="clearfix"></div>
                    </div><!--  /.site-navigation -->
				
					</div>
				
					<div class="col-md-2 col-sm-2">
									<?php if( get_theme_mod('cds_button_display','show' ) == 'show') :
										?>
										<div class="header-inquiry-btn">
											<?php
											$headerinquirytitle = get_theme_mod('headermain_headerinquirytitle', 'GET A QUOTE'); 
											$headerinquiry = get_theme_mod('header_headerinquiry', 'Make and link here');
											?>
											<?php if(!empty($headerinquiry)){ ?>
												<div class='head-button'><a href="<?php echo $headerinquiry ?>" title=""><?php echo ($headerinquirytitle);  ?></a></div>
											<?php }?> 
										</div>
									<?php endif ?>
								</div>
				<!-- main header END -->
				<div class="clearfix"></div>
			</div>
		</header><!-- #masthead -->
	</div>