<?php 

$wp_customize->add_panel(
	'luzuk_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'Luzuk Premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'Luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

//HEADER SETTINGS
$wp_customize->add_section(
	'luzuk_header_settings',
	array(
		'title' => __( 'Header Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'luzukogoWidth_settings', 'luzuk_header_settings', ' Set Logo Max Width');
$wp_customize->add_setting(
	'luzuk_logoTopsetmaxwidth',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '100', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'luzuk_logoTopsetmaxwidth',
	array(
		'settings'      => 'luzuk_logoTopsetmaxwidth',
		'section'       => 'luzuk_header_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Max Width', 'lz-fitness-premium' )
	)
);
addColorPalatOption($wp_customize, 'luzuk_sitetitletxt_color', 'luzuk_header_settings', 'Site Title Color', '#ffffff');

addColorPalatOption($wp_customize, 'luzuk_sitetaglinetxt_color', 'luzuk_header_settings', 'Site Tagline Color', '#ffffff');

lzCustomLable($wp_customize, 'luzuk_header_settings', 'luzuk_header_settings', ' Set Header Padding:');

$wp_customize->add_setting(
	'pages_logoTmargin',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '40px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoTmargin',
	array(
		'settings'      => 'pages_logoTmargin',
		'section'       => 'luzuk_header_settings',
		'type'          => 'text',
		'label'         => __( 'Top Padding', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoBmargin',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '30px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoBmargin',
	array(
		'settings'      => 'pages_logoBmargin',
		'section'       => 'luzuk_header_settings',
		'type'          => 'text',
		'label'         => __( 'Bottom Padding', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoLmargin',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '00px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoLmargin',
	array(
		'settings'      => 'pages_logoLmargin',
		'section'       => 'luzuk_header_settings',
		'type'          => 'text',
		'label'         => __( 'Left Padding', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoRmargin',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoRmargin',
	array(
		'settings'      => 'pages_logoRmargin',
		'section'       => 'luzuk_header_settings',
		'type'          => 'text',
		'label'         => __( 'Right Padding', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'header_lblbutton1display', 'luzuk_header_settings', 'Header Button Display & Text Setting:');
// to show & hide another button
$wp_customize->add_setting( 'cds_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'cds_button_display', array( 'label' => 'Button Display', 'section' => 'luzuk_header_settings', 'settings' => 'cds_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// appointment 
$wp_customize->add_setting(
	'headermain_headerinquirytitle',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'GET A QUOTE' )
	)
);
$wp_customize->add_control(
	'headermain_headerinquirytitle',
	array(
		'settings'      => 'headermain_headerinquirytitle',
		'section'       => 'luzuk_header_settings',
		'type'          => 'text',
		'label'         => __( 'Header Button Text', 'luzuk-premium' )
	)
);
$wp_customize->add_setting('header_headerinquiry',	array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_headerinquiry',
	array(
		'settings'      => 'header_headerinquiry',
		'section'       => 'luzuk_header_settings',
		'type'          => 'url',
		'label'         => __( 'Add "Header Button" link here', 'luzuk-premium' )
	)
);


addColorPalatOption($wp_customize, 'headerbutttext_color', 'luzuk_header_settings', 'Header Button Text Color', '#ffffff');

addColorPalatOption($wp_customize, 'headerbutthovtext_color', 'luzuk_header_settings', 'Header Button Hover Text Color', '#000000');

addColorPalatOption($wp_customize, 'headerbuttBg_color', 'luzuk_header_settings', 'Header Button Border Color', '#fff');

addColorPalatOption($wp_customize, 'headerbutthovBg_color', 'luzuk_header_settings', 'Header Button Hover Background Color', '#ffffff');
//Menu colors 

addColorPalatOption($wp_customize, 'homeheaderlogshapebg_color', 'luzuk_header_settings', 'Home Header Logo Background Shape Color', '#48ac6e');


addColorPalatOption($wp_customize, 'luzuk_headermenu_color', 'luzuk_header_settings', 'Header Menu Color', '#ffffff');

addColorPalatOption($wp_customize, 'luzuk_headerhovermenu_color', 'luzuk_header_settings', 'Header Menu Hover Color', '#000000');

addColorPalatOption($wp_customize, 'luzuk_headersubmenubgss_color', 'luzuk_header_settings', 'Header Dropdown Background Color', '#ffffff');


addColorPalatOption($wp_customize, 'luzuk_headersubmenu_color', 'luzuk_header_settings', 'Header Sub Menu Color', '#ff6752');
addColorPalatOption($wp_customize, 'luzuk_headersubmenuhover_color', 'luzuk_header_settings', 'Header Sub Menu hover Color', '#000000');

addColorPalatOption($wp_customize, 'headerrespomnuicon_color', 'luzuk_header_settings', 'Header Responsive Menu Icon Color', '#ffca2a');

addColorPalatOption($wp_customize, 'headerresslidemeBg_color', 'luzuk_header_settings', 'Header Responsive Slide Menu Background Color', '#48ac6e');

addColorPalatOption($wp_customize, 'headerresslidemebord_color', 'luzuk_header_settings', 'Header Responsive Slide Menu border Color', '#ffffff');


//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'Luzuk Premium'),
	'panel' => 'luzuk_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'luzuk_template_color', 'colors', 'Theme Primary Color', '#48ac6e');
//theme Secondary color
addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#fe4c64');

addColorPalatOption($wp_customize, 'theme_sidebarbg_color', 'colors', 'Theme Sidebar Background Color', '#ffffff');

lzCustomLable($wp_customize, 'luzuk_allinnerpagesec_colordisplaysettdisplay', 'colors', 'Color Setting For Innerpage Colors:');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');

// for gradiant

$wp_customize->add_setting(
    'luzuk_innerpagegradhead_bg_color_one', array(
        'default'           => '#61bd66',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'luzuk_innerpagegradhead_bg_color_one',array(
            'settings'      => 'luzuk_innerpagegradhead_bg_color_one',
            'section'       => 'colors',
            'label'         => __( 'Inner page Header Background Color ', 'Luzuk Premium' ),
        )
    )
);

$wp_customize->add_setting(
    'luzuk_innerpagegradhead_bg_color_two', array(
        'default'           => '#48ac6e',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'luzuk_innerpagegradhead_bg_color_two',array(
            'settings'      => 'luzuk_innerpagegradhead_bg_color_two',
            'section'       => 'colors',
            'label'         => __( 'Inner page Header SVG Background Color  ', 'Luzuk Premium' ),
        )
    )
); 


addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionbox_color', 'colors', 'Inner Page Box Background color', '#ffffff');


lzCustomLable($wp_customize, 'innerpagetitleboer_color', 'colors', 'Inner Page Title Border Gradient Colors:');

// for gradiant
$wp_customize->add_setting(
    'titlebor_bg_color_one', array(
        'default'           => '#93e088 ',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'titlebor_bg_color_one',array(
            'settings'      => 'titlebor_bg_color_one',
            'section'       => 'colors',
            'label'         => __( 'Border Gradient Color One ', 'luzuk Premium' ),
        )
    )
);

$wp_customize->add_setting(
    'titlebor_bg_color_two', array(
        'default'           => '#61bd66',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'titlebor_bg_color_two',array(
            'settings'      => 'titlebor_bg_color_two',
            'section'       => 'colors',
            'label'         => __( 'Border Gradient Color Two ', 'luzuk Premium' ),
        )
    )
);


addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading1_color', 'colors', 'Heading1 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading2_color', 'colors', 'Heading2 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading3_color', 'colors', 'Heading3 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading4_color', 'colors', 'Heading4 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading5_color', 'colors', 'Heading5 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading6_color', 'colors', 'Heading6 color', '#2e2e2e');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtext_color', 'colors', 'Inner Page Text color', '#121212');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinks_color', 'colors', 'Inner Page Links color', '#777777');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinkshvrs_color', 'colors', 'Inner Page Links Hover color', '#64c068');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinksicon_color', 'colors', 'Inner Page Icons, list number color', '#ffffff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinksiconbgssclr_color', 'colors', 'Inner Page list number Background color', '#61bd66');

//addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxallbrss_color', 'colors', 'Inner Page Sidebar border color', '#e1e1e1');






//addColorPalatOption($wp_customize, 'Widgets_Backgroudcolor', 'colors', 'Widgets Background color', '#fff');
addColorPalatOption($wp_customize, 'Widgets_BlogImageOverlaycolor', 'colors', 'Posts Image Overlay Color', '#64bf68');
//addColorPalatOption($wp_customize, 'Widgets_Bordercolor', 'colors', 'Inner Page Border color', '#cccccc');
addColorPalatOption($wp_customize, 'Widgets_Socialscolor', 'colors', 'Post Socials Hover color', '#777');
addColorPalatOption($wp_customize, 'Widgets_PostBxBgsscolor', 'colors', 'Post Box Background color', '#ffffff');

addColorPalatOption($wp_customize, 'Other_Text_color', 'colors', 'Other Text color', '#ffffff');

addColorPalatOption($wp_customize, 'rg_template_innerpagesidebardaybgsstxt_color', 'colors', 'Pages Other Fields Background Color', '#ffffff');

addColorPalatOption($wp_customize, 'innerpagemainsectionboxallbrss_color', 'colors', 'Inner Page Border color', '#e1e1e1');

//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'luzuk_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'luzuk_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 

$wp_customize->add_setting(
        'luzuk_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Home', 'luzuk' )
        )
    );
    $wp_customize->add_control(
        'luzuk_breadcrumbhometxt',
        array(
            'settings'      => 'luzuk_breadcrumbhometxt',
            'section'       => 'luzuk_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here:', 'luzuk' )
        )
    );

//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbtitlecolor', 'luzuk_breadcrumb_settings', 'Inner page breadcrumbbox title color', '#ffffff');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlecolor', 'luzuk_breadcrumb_settings', 'Inner page breadcrumbbox current title color', '#ffffff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlehovercolor', 'luzuk_breadcrumb_settings', 'Inner page breadcrumbbox current title hover color', '#e7ccf7');
 



// end to show & hide button

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'luzuk_postpagedate_settings',
	array(
		'title' => __( 'Postpage Date Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'luzuk_postpagedate_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Date', 'hide' => 'Hide Post Date', ), ) ); 

// end to show & hide button


//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'luzuk_footer_copyright_settings',
	array(
		'title' => __( 'Footer Copyright Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

$wp_customize->add_setting(
	'luzuk_footer_copyrighttext',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Copyright © 2020 Ultra Print | All Rights Reserved', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'luzuk_footer_copyrighttext',
	array(
		'settings'      => 'luzuk_footer_copyrighttext',
		'section'       => 'luzuk_footer_copyright_settings',
		'type'          => 'textarea',
		'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
	)
);

addColorPalatOption($wp_customize, 'footer_bg_color', 'luzuk_footer_copyright_settings', 'Footer Background Color', '#5bbd68');

//theme Footer title Color
addColorPalatOption($wp_customize, 'luzuk_footer_title_color', 'luzuk_footer_copyright_settings', 'Footer Title Color', '#ffffff');

//theme Footer icon Color
addColorPalatOption($wp_customize, 'luzuk_footer_icon_color', 'luzuk_footer_copyright_settings', 'Footer Icon Color', '#ada9b7');
//theme Footer icon hover Color
addColorPalatOption($wp_customize, 'luzuk_footer_iconhover_color', 'luzuk_footer_copyright_settings', 'Footer Icon Hover Color', '#fff');

//theme Footer text Color
addColorPalatOption($wp_customize, 'luzuk_footer_text_color', 'luzuk_footer_copyright_settings', 'Footer Text Color', '#ffffff');


addColorPalatOption($wp_customize, 'luzuk_footer_menu_color', 'luzuk_footer_copyright_settings', 'Footer Menu Color', '#ffffff');

//theme Footer menu hover Color
addColorPalatOption($wp_customize, 'luzuk_footer_menuhover_color', 'luzuk_footer_copyright_settings', 'Footer Menu Hover Color', '#000000');

addColorPalatOption($wp_customize, 'luzuk_footer_menuicon_color', 'luzuk_footer_copyright_settings', 'Footer Menu Icon Color', '#ffffff');

addColorPalatOption($wp_customize, 'luzuk_footer_menuiconhvr_color', 'luzuk_footer_copyright_settings', 'Footer Menu Hover Icon Color', '#000000');

//theme Footer menu date Color
addColorPalatOption($wp_customize, 'luzuk_footer_menudate_color', 'luzuk_footer_copyright_settings', 'Footer Menu Date Color', '#ffffff');

//theme Footer social Color
addColorPalatOption($wp_customize, 'luzuk_footer_social_color', 'luzuk_footer_copyright_settings', 'Footer Social Icon Color', '#ffffff');


//theme Footer social Hover Color
addColorPalatOption($wp_customize, 'luzuk_footer_socialhover_color', 'luzuk_footer_copyright_settings', 'Footer Social Icon Hover Color', '#ffffff');

//theme Footer table text Color
addColorPalatOption($wp_customize, 'luzuk_footer_tabletext_color', 'luzuk_footer_copyright_settings', 'Footer Table Text Color', '#ffffff');
//theme Footer table border Color
addColorPalatOption($wp_customize, 'luzuk_footer_tableborder_color', 'luzuk_footer_copyright_settings', 'Footer Table Border Color', '#ffffff');

addColorPalatOption($wp_customize, 'luzuk_footer_formlabeltxt_color', 'luzuk_footer_copyright_settings', 'Footer Form label Text Color', '#ffffff');

//theme Footer form Color
addColorPalatOption($wp_customize, 'luzuk_footer_form_color', 'luzuk_footer_copyright_settings', 'Footer Form Text & Placeholder Text Color', '#000');

//theme Footer form border Color
addColorPalatOption($wp_customize, 'luzuk_footer_formborder_color', 'luzuk_footer_copyright_settings', 'Footer Form text field background Color', '#fff');


//theme Footer form button Color
addColorPalatOption($wp_customize, 'luzuk_footer_formbtn_color', 'luzuk_footer_copyright_settings', 'Footer Form Button Text Color', '#ffffff');

//theme Footer Form Button Background Color
addColorPalatOption($wp_customize, 'luzuk_footer_formbtnbg_color', 'luzuk_footer_copyright_settings', 'Footer Form Button Background Color', '#a9a0be');

//theme Footer Form Button Background Color
addColorPalatOption($wp_customize, 'luzuk_footer_calday_color', 'luzuk_footer_copyright_settings', 'Calender days color', '#000000');

//theme Footer Form Button Background Color
addColorPalatOption($wp_customize, 'luzuk_footer_postag_color', 'luzuk_footer_copyright_settings', 'Footer Post Tag color', '#000000');


addColorPalatOption($wp_customize, 'luzuk_footer_copyrighttext_color', 'luzuk_footer_copyright_settings', 'Copyright Footer Text Color', '#ffffff');

addColorPalatOption($wp_customize, 'luzuk_footer_copyrightbgssclr_color', 'luzuk_footer_copyright_settings', 'Copyright Footer Border Color', '#ffffff');

addColorPalatOption($wp_customize, 'footer_svgwaveybg_color', 'luzuk_footer_copyright_settings', 'Footer svg wavey Background Color', '#48ac6e');

addColorPalatOption($wp_customize, 'footer_svgcirclebbg_color', 'luzuk_footer_copyright_settings', 'Footer svg circle Big Background Color', '#ffffff');

addColorPalatOption($wp_customize, 'footersvgcircsmllbg_color', 'luzuk_footer_copyright_settings', 'Footer svg circle Small Background Color', '#fe4c64');


//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'luzuk_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'luzuk_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 
// end to show & hide button

$wp_customize->add_section(
	'luzuk_innerpageshortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'lz-fitness-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'luzuk_servicepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Services Shortcode Page Colors:'); 

lzCustomLable($wp_customize, 'luzuk_serviceinnerpageimgdisplayset', 'luzuk_innerpageshortcode_page_settings', 'Note: Set Services images of equal height');

addColorPalatOption($wp_customize, 'luzuk_ServicesboxinnerpagettlColor', 'luzuk_innerpageshortcode_page_settings', 'Select Services Title color', '#ffffff');

addColorPalatOption($wp_customize, 'luzuk_ServicesboxinnerpagebxbgssColor', 'luzuk_innerpageshortcode_page_settings', 'Select Services Title Box Background color', '#61bd66');

addColorPalatOption($wp_customize, 'luzuk_ServicesboxOverlayColor', 'luzuk_innerpageshortcode_page_settings', 'Select Services Image Overlay color', '#000000');


lzCustomLable($wp_customize, 'luzuk_galleryinnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Gallery Shortcode Page Colors:');

lzCustomLable($wp_customize, 'luzuk_galleryinnerpageimgdisplayset', 'luzuk_innerpageshortcode_page_settings', 'Note: Set gallery images of equal height:');
addColorPalatOption($wp_customize, 'luzuk_GalleryImageOverlayColor', 'luzuk_innerpageshortcode_page_settings', 'Select Gallery Image Overlay color', '#e4c640'); 

addColorPalatOption($wp_customize, 'luzuk_GalleryImageBorderColor', 'luzuk_innerpageshortcode_page_settings', 'Select Border color', '#ffffff'); 

addColorPalatOption($wp_customize, 'luzuk_GalleryImageIconColor', 'luzuk_innerpageshortcode_page_settings', 'Select Icon color', '#ffffff'); 

addColorPalatOption($wp_customize, 'luzuk_GalleryImageIconBgssColor', 'luzuk_innerpageshortcode_page_settings', 'Select Icon Background color', '#61bd66'); 


lzCustomLable($wp_customize, 'luzuk_teaminnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Team Shortcode Page Colors:');

lzCustomLable($wp_customize, 'luzuk_teaminnerpageimgdisplayset', 'luzuk_innerpageshortcode_page_settings', 'Note: Set team member images of equal height of size atleast 300px');

addColorPalatOption($wp_customize, 'luzuk_teaminnermembernametextColor', 'luzuk_innerpageshortcode_page_settings', 'Select Member Name Text color', '#000000'); 

addColorPalatOption($wp_customize, 'luzuk_teaminnermemberdesignationtextColor', 'luzuk_innerpageshortcode_page_settings', 'Select Member Designation Text color', '#6abf62');

addColorPalatOption($wp_customize, 'luzuk_teaminnermembersocialColor', 'luzuk_innerpageshortcode_page_settings', 'Select Social Icon color', '#ffffff');

addColorPalatOption($wp_customize, 'luzuk_teaminnermembersocialHoverColor', 'luzuk_innerpageshortcode_page_settings', 'Select Social Icon Hover color', '#ffca2a');

addColorPalatOption($wp_customize, 'luzuk_teaminnermembersocialbackbgssColor', 'luzuk_innerpageshortcode_page_settings', 'Select Social Icon Background color', '#fe4c64');

addColorPalatOption($wp_customize, 'TeaminnerboxBakbgColor', 'luzuk_innerpageshortcode_page_settings', 'Team Box Background color', '#ffffff');

lzCustomLable($wp_customize, 'luzuk_testimonialinnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Testimonial Shortcode Page Colors:');
 
addColorPalatOption($wp_customize, 'testiminnertitleColor', 'luzuk_innerpageshortcode_page_settings', 'Select Testimonial Title color', '#ffffff');
addColorPalatOption($wp_customize, 'testiminnerboxtextColor', 'luzuk_innerpageshortcode_page_settings', 'Select Testimonial Text color', '#ffffff');


$wp_customize->add_setting(
    'TestimonialBoxBg_color_one', array(
        'default'           => '#61bd66',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'TestimonialBoxBg_color_one',array(
            'settings'      => 'TestimonialBoxBg_color_one',
            'section'       => 'luzuk_innerpageshortcode_page_settings',
            'label'         => __( 'Testimonial Box Background Color One ', 'Luzuk Premium' ),
        )
    )
);

$wp_customize->add_setting(
    'TestimonialBoxBg_color_two', array(
        'default'           => '#48ac6e',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'TestimonialBoxBg_color_two',array(
            'settings'      => 'TestimonialBoxBg_color_two',
            'section'       => 'luzuk_innerpageshortcode_page_settings',
            'label'         => __( 'Testimonial Box Background Color Two', 'Luzuk Premium' ),
        )
    )
);


lzCustomLable($wp_customize, 'luzuk_faqinnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Faq Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleIconColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq No. color', '#ffffff');
addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleIconboxbgssColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq No. box background color', '#61bd66');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Question Text color', '#121212');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleboxborderColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Question Text Box Background color', '#ffffff');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetextcColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Text color', '#ffffff');
addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetextboxbgsscbrssColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Text Box Background color', '#61bd66');


$wp_customize->add_section(
	'luzuk_innerpagefont_settings',
	array(
		'title' => __( 'Inner Page Fonts Settings', 'lz-fitness-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh1_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 1:');


$wp_customize->add_setting(
	'pages_innerpageheading',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '24px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading',
	array(
		'settings'      => 'pages_innerpageheading',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 1', 'lz-fitness-premium' )
	)
);


lzCustomLable($wp_customize, 'luzuk_innerpageh2_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 2:');


$wp_customize->add_setting(
	'pages_innerpageheading2',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '23px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading2',
	array(
		'settings'      => 'pages_innerpageheading2',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 2', 'lz-fitness-premium' )
	)
);


lzCustomLable($wp_customize, 'luzuk_innerpageh3_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 3:');


$wp_customize->add_setting(
	'pages_innerpageheading3',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '20px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading3',
	array(
		'settings'      => 'pages_innerpageheading3',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 3', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh4_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 4:');


$wp_customize->add_setting(
	'pages_innerpageheading4',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '19px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading4',
	array(
		'settings'      => 'pages_innerpageheading4',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 4', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh5_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 5:');


$wp_customize->add_setting(
	'pages_innerpageheading5',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '18px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading5',
	array(
		'settings'      => 'pages_innerpageheading5',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 5', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh6_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 6:');


$wp_customize->add_setting(
	'pages_innerpageheading6',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '10px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading6',
	array(
		'settings'      => 'pages_innerpageheading6',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 6', 'lz-fitness-premium' )
	)
);

$wp_customize->add_section(
	'luzuk_innerpage_animation_settings',
	array(
		'title' => __( 'Inner Page Animation Display Settings', 'lz-fitness-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);


// to show & hide another button
$wp_customize->add_setting( 'innerpagesallheaderanimation_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'innerpagesallheaderanimation_button_display', array( 'label' => 'Innerpage Animation Display Setting', 'section' => 'luzuk_innerpage_animation_settings', 'settings' => 'innerpagesallheaderanimation_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Start animation', 'hide' => 'Stop Animation', ), ) ); 
// end to show & hide button


