<?php 

$luzuk_categories = get_categories(array('hide_empty' => 0));
foreach ($luzuk_categories as $luzuk_category) {
	$luzuk_cat[$luzuk_category->term_id] = $luzuk_category->cat_name;
}
/****************************/
// START BLOG SECTION FOR HOME PAGE
/*============BLOG PANEL============*/
$wp_customize->add_section(
	'luzuk_blog_section',
	array(
		'title' => __( 'Blog Section', 'Luzuk' ),
		'panel' => 'luzuk_premium_home_panel',
     	//'priority' => '50',
	)
);

//ENABLE/DISABLE BLOG SECTION
$wp_customize->add_setting(
	'luzuk_blog_section_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'luzuk_blog_section_disable',
		array(
			'settings'      => 'luzuk_blog_section_disable',
			'section'       => 'luzuk_blog_section',
			'label'         => __( 'Disable Section', 'Luzuk' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'Luzuk' ),
				'off' => __( 'No', 'Luzuk' )
			)   
		)
	)
);
backgroundManager($wp_customize, 'blog', 'luzuk_blog_section', $color='#ffffff');

lzCustomLable($wp_customize, 'Blogsectionpadding', 'luzuk_blog_section', 'Set Section Padding:');

$wp_customize->add_setting(
    'sec_blogTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'sec_blogTpadding',
    array(
        'settings'      => 'sec_blogTpadding',
        'section'       => 'luzuk_blog_section',
        'type'          => 'text',
        'label'         => __( 'Blog Section Top Padding', 'Luzuk Premium' )
    )
);
$wp_customize->add_setting(
    'sec_blogBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'sec_blogBpadding',
    array(
        'settings'      => 'sec_blogBpadding',
        'section'       => 'luzuk_blog_section',
        'type'          => 'text',
        'label'         => __( 'Blog Section Bottom Padding', 'Luzuk Premium' )
    )
);

// end to show & hide button
$wp_customize->add_setting(
	'luzuk_blog_title_subtitle_heading',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text'
	)
);
$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'luzuk_blog_title_subtitle_heading',
		array(
			'settings'      => 'luzuk_blog_title_subtitle_heading',
			'section'       => 'luzuk_blog_section',
			'label'         => __( 'Section Title & Sub Title', 'Luzuk' ),
		)
	)
);
$wp_customize->add_setting(
	'luzuk_blog_title',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Latest News', 'Luzuk' )
	)
);
$wp_customize->add_control(
	'luzuk_blog_title',
	array(
		'settings'      => 'luzuk_blog_title',
		'section'       => 'luzuk_blog_section',
		'type'          => 'text',
		'label'         => __( 'Add Section Title Here:', 'Luzuk' )
	)
);

addColorPalatOption($wp_customize, 'luzuk_blog_sectionttlColor', 'luzuk_blog_section', 'Select Section Title color', '#202020');



$wp_customize->add_setting(
	'luzuk_blog_sub_title',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus eu pharetra ex. Etiam eget diam ligula. Sed at blandit ante.', 'Luzuk' )
	)
);
$wp_customize->add_control(
	'luzuk_blog_sub_title',
	array(
		'settings'      => 'luzuk_blog_sub_title',
		'section'       => 'luzuk_blog_section',
		'type'          => 'textarea',
		'label'         => __( 'Add Section Sub Title Here:', 'Luzuk' )
	)
);

// Heading color
addColorPalatOption($wp_customize, 'luzuk_blog_sectionSubtColor', 'luzuk_blog_section', 'Section Sub Text color', '#7790a4');

//BLOG SETTINGS
$wp_customize->add_setting(
	'luzuk_blog_post_count',
	array(
		'default'           => '3',
		'sanitize_callback' => 'luzuk_sanitize_choices'
	)
);
$wp_customize->add_control(
	new luzuk_Dropdown_Chooser(
		$wp_customize,
		'luzuk_blog_post_count',
		array(
			'settings'      => 'luzuk_blog_post_count',
			'section'       => 'luzuk_blog_section',
			'label'         => __( 'Number of Posts to show', 'Luzuk' ),
			'choices'       => $luzuk_post_count_choice
		)
	)
);
$wp_customize->add_setting(
	'luzuk_blog_cat_exclude',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text'
	)
);
$wp_customize->add_control(
	new luzuk_Customize_Checkbox_Multiple(
		$wp_customize,
		'luzuk_blog_cat_exclude',
		array(
			'label' => __('Exclude Category from Blog Posts', 'Luzuk'),
			'section' => 'luzuk_blog_section',
			'settings' => 'luzuk_blog_cat_exclude',
			'choices' => $luzuk_cat
		)
	)
);

lzCustomLable($wp_customize, 'blog_lblbuttonabtdisplay', 'luzuk_blog_section', 'Blog Button Display & Text Setting:');

// to show & hide another button
$wp_customize->add_setting( 'blog_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'blog_button_display', array( 'label' => 'Blog Button Display', 'section' => 'luzuk_blog_section', 'settings' => 'blog_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button


$wp_customize->add_setting(
    'blogbutn_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Read More', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blogbutn_text',
    array(
        'settings'      => 'blogbutn_text',
        'section'       => 'luzuk_blog_section',
        'type'          => 'text',
        'label'         => __( 'Blog Button Text', 'luzuk-premium' )
    )
);


lzCustomLable($wp_customize, 'blog_clrlbtnTxt', 'luzuk_blog_section', 'Set Blog Colors:');

addColorPalatOption($wp_customize, 'luzuk_blog_blgpostimgovericoncColor', 'luzuk_blog_section', 'Select Post Image Hover Icon color', '#fe4c64');

addColorPalatOption($wp_customize, 'luzuk_blog_blgpostimgovericonbgsscColor', 'luzuk_blog_section', 'Select Post Image Hover Icon Background color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_blog_blgpostimgovericonhovercColor', 'luzuk_blog_section', 'Select Post Image Hover Icon Hover color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_blog_blgpostimgovericonbghoversscColor', 'luzuk_blog_section', 'Select Post Image Hover Icon Hover Background color', '#fe4c64');

addColorPalatOption($wp_customize, 'luzuk_blog_blgpostTitleColor', 'luzuk_blog_section', 'Select Post Title color', '#212121');

addColorPalatOption($wp_customize, 'luzuk_blog_blgpostTitlehvrColor', 'luzuk_blog_section', 'Select Post Title Hover color', '#61be65');

addColorPalatOption($wp_customize, 'luzuk_blog_blgpostDatetxtColor', 'luzuk_blog_section', 'Select Post Date , Text  color', '#000');
addColorPalatOption($wp_customize, 'luzuk_blog_blgpostDateadminColor', 'luzuk_blog_section', 'Select Post Admin Text  color', '#fe4c64');

addColorPalatOption($wp_customize, 'blog_blgpostcattxtColor', 'luzuk_blog_section', 'Select Post Decription color', '#6c6967');
addColorPalatOption($wp_customize, 'Blogborder_color', 'luzuk_blog_section', 'Select Post Border color', '#e6e6e6');

addColorPalatOption($wp_customize, 'Blogcontentboxbg_color', 'luzuk_blog_section', 'Select Post Content Box Background color', '#fff');


//Set Blog button colour
addColorPalatOption($wp_customize, 'Blogbtn_color', 'luzuk_blog_section', 'Blog Button Color', '#fff');

//Set Blog button bg colour
addColorPalatOption($wp_customize, 'Blogbtnbg_color', 'luzuk_blog_section', 'Blog Button Background Color', '#61be66');

//Set Blog button hover colour
addColorPalatOption($wp_customize, 'Blogbtnhover_color', 'luzuk_blog_section', 'Blog Button Hover Color', '#fff');

//Set Blog Button Border colour
addColorPalatOption($wp_customize, 'Blogbtnborder_color', 'luzuk_blog_section', 'Blog Button Border Color', '#61be66');


//Set Blog button bg hover colour
addColorPalatOption($wp_customize, 'Blogbtnbghover_color', 'luzuk_blog_section', 'Blog Button Background Hover Color', '#fe4c64');



addColorPalatOption($wp_customize, 'blog_seccirclebgColor', 'luzuk_blog_section', 'Section Circle Background color', '#7669df');
// END BLOG SECTION FOR HOME PAGE
/****************************/

$wp_customize->add_section(
	'luzuk_premium_blog_section',
	array(
		'title' => __( 'Blog Page Settings', 'luzuk-premium' ),
        // 'panel' => 'luzuk_premium_home_panel'
		'priority' =>19
	)
);



$wp_customize->add_setting('luzuk_blog_categories_settings', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control('luzuk_blog_categories_settings', array(
    'settings' => 'luzuk_blog_categories_settings',
    'label'    => __('Posts on Blog Page', 'Luzuk'),
    'section'  => 'luzuk_premium_blog_section',
    'type'     => 'radio',
    'choices'  => array(
        '0' => __('Excerpts','Luzuk'),
        '1' => __('Full Posts','Luzuk'),
    ),
));

// ADDING THE CATEGORY TO SELECT
$wp_customize->add_setting('luzuk_blog_categories', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Checkbox_Multiple(
		$wp_customize,
		'luzuk_blog_categories',
		array(
			'label' => __('Exclude Category from Blog Posts', 'Luzuk'),
			'section' => 'luzuk_premium_blog_section',
			'settings' => 'luzuk_blog_categories',
			'choices' => $luzuk_cat
		)
	)
);


