<?php
$wp_customize->add_section(
	'contact_section',
	array(
		'title'         => __( 'Contact Section', 'Luzuk Premium' ), 
		'panel'   => 'luzuk_premium_home_panel',
	)
);
$wp_customize->add_setting(
	'luzuk_contact_section_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'luzuk_contact_section_disable',
		array(
			'settings'      => 'luzuk_contact_section_disable',
			'section'       => 'contact_section',
			'label'         => __( 'Disable Section', 'Luzuk Premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'Luzuk Premium' ),
				'off' => __( 'No', 'Luzuk Premium' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'contact', 'contact_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'contactsection_padding', 'contact_section', ' Section Padding Setting:');

$wp_customize->add_setting(
    'contactsection_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'contactsection_toppadding',
    array(
        'settings'      => 'contactsection_toppadding',
        'section'       => 'contact_section',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'contactsection_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'contactsection_bottompadding',
    array(
        'settings'      => 'contactsection_bottompadding',
        'section'       => 'contact_section',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'contactbox_MainTitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'We are Here to Help You', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'contactbox_MainTitle',
    array(
        'settings'      => 'contactbox_MainTitle',
        'section'       => 'contact_section',
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'luzuk-premium' )
    )
);
addColorPalatOption($wp_customize, 'contact_AllSectionTitleColor', 'contact_section', 'Section Title Colors', '#3b3b3b');

$wp_customize->add_setting(
    'contactbox_MainTitleTxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our mission is to deliver reliable, latest news & opinions.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'contactbox_MainTitleTxt',
    array(
        'settings'      => 'contactbox_MainTitleTxt',
        'section'       => 'contact_section',
        'type'          => 'textarea',
        'label'         => __( 'Section Sub Heading', 'luzuk-premium' )
    )
);
addColorPalatOption($wp_customize, 'contact_AllSectionTextColor', 'contact_section', 'Section Text Colors', '#68869e');


lzCustomLable($wp_customize, 'detailsForBox1', 'contact_section', 'Details For Box 1:');


$wp_customize->add_setting(
    'contactbox_loanTxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'OFFICE ADDRESS', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'contactbox_loanTxt',
    array(
        'settings'      => 'contactbox_loanTxt',
        'section'       => 'contact_section',
        'type'          => 'text',
        'label'         => __( 'Tagline 1', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'contactbox_loanDescTxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '135 Barnard St. Brooklyn, NY 10036, United States', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'contactbox_loanDescTxt',
    array(
        'settings'      => 'contactbox_loanDescTxt',
        'section'       => 'contact_section',
        'type'          => 'textarea',
        'label'         => __( 'Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'contactbox_BtnTxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Get Appointment', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'contactbox_BtnTxt',
    array(
        'settings'      => 'contactbox_BtnTxt',
        'section'       => 'contact_section',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('contactbox_Btnlink',   array('default'=> 'add Button link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('contactbox_Btnlink',
    array(
        'settings'      => 'contactbox_Btnlink',
        'section'       => 'contact_section',
        'type'          => 'url',
        'label'         => __( 'Add Button Url Here:', 'Luzuk' )
    )
);


lzCustomLable($wp_customize, 'detailsForBox2', 'contact_section', 'Details For Box 2:');



// all new data

$wp_customize->add_setting(
    'contactbox_CallTxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'CALL US AT', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'contactbox_CallTxt',
    array(
        'settings'      => 'contactbox_CallTxt',
        'section'       => 'contact_section',
        'type'          => 'text',
        'label'         => __( 'Phone Tagline', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'contactbox_CallDescTxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '91-400-123-1234', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'contactbox_CallDescTxt',
    array(
        'settings'      => 'contactbox_CallDescTxt',
        'section'       => 'contact_section',
        'type'          => 'text',
        'label'         => __( 'Phone Number', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'contactbox_email',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'info@loanadvisor.com', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'contactbox_email',
    array(
        'settings'      => 'contactbox_email',
        'section'       => 'contact_section',
        'type'          => 'text',
        'label'         => __( 'Email-Id', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'contactbox_BtnTxt2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Contact Us', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'contactbox_BtnTxt2',
    array(
        'settings'      => 'contactbox_BtnTxt2',
        'section'       => 'contact_section',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('contactbox_Btnlink2',   array('default'=> 'add Button link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('contactbox_Btnlink2',
    array(
        'settings'      => 'contactbox_Btnlink2',
        'section'       => 'contact_section',
        'type'          => 'url',
        'label'         => __( 'Add Button Url Here:', 'Luzuk' )
    )
);
lzCustomLable($wp_customize, 'detailsForBox3', 'contact_section', 'Details For Box 3:');


$wp_customize->add_setting(
    'contactbox_AdvisorTxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'TALK TO ADVISOR', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'contactbox_AdvisorTxt',
    array(
        'settings'      => 'contactbox_AdvisorTxt',
        'section'       => 'contact_section',
        'type'          => 'text',
        'label'         => __( 'Tagline', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'contactbox_AdvisorDescTxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'contactbox_AdvisorDescTxt',
    array(
        'settings'      => 'contactbox_AdvisorDescTxt',
        'section'       => 'contact_section',
        'type'          => 'textarea',
        'label'         => __( 'Text', 'luzuk-premium' )
    )
);



$wp_customize->add_setting(
    'contactbox_BtnTxt3',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Meet The Advisor', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'contactbox_BtnTxt3',
    array(
        'settings'      => 'contactbox_BtnTxt3',
        'section'       => 'contact_section',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('contactbox_Btnlink3',   array('default'=> 'add Button link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('contactbox_Btnlink3',
    array(
        'settings'      => 'contactbox_Btnlink3',
        'section'       => 'contact_section',
        'type'          => 'url',
        'label'         => __( 'Add Button Url Here:', 'Luzuk' )
    )
);
lzCustomLable($wp_customize, 'contactus_Set_Colors', 'contact_section', 'Set Colors:');

addColorPalatOption($wp_customize, 'contact_AllIconColor', 'contact_section', 'Icon Colors', '#61bd66');

addColorPalatOption($wp_customize, 'contact_AllTaglineColor', 'contact_section', 'Tagline Colors', '#212121');

addColorPalatOption($wp_customize, 'contact_AllTextsColor', 'contact_section', 'Texts Colors', '#1c232b');

addColorPalatOption($wp_customize, 'contact_ButtonTextswithBorderColor', 'contact_section', 'Button Text & Border Color', '#61bd66');

addColorPalatOption($wp_customize, 'contact_BoxBackgroundColor', 'contact_section', 'Box Background Colors', '#ffffff');

addColorPalatOption($wp_customize, 'contact_BoxexBorderColor', 'contact_section', 'Box Border Color', '#dbe0ec');

addColorPalatOption($wp_customize, 'contact_PhoneTextColor', 'contact_section', 'Phone Text Colors', '#61bd66');

