<?php   
    $wp_customize->add_section(
        'luzuk_premium_counter_section',
        array(
            'title' => __( 'Counter Section', 'lz-fitness-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'luzuk_premium_counter_section_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'luzuk_premium_counter_section_disable',
            array(
                'settings'      => 'luzuk_premium_counter_section_disable',
                'section'       => 'luzuk_premium_counter_section',
                'label'         => __( 'Disable Section', 'lz-fitness-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'lz-fitness-premium' ),
                    'off' => __( 'No', 'lz-fitness-premium' )
                ),
            )
        )
    );

backgroundManager($wp_customize, 'counter', 'luzuk_premium_counter_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');
$wp_customize->add_setting(
    'luzuk_premium_counter_title_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'luzuk_premium_counter_title_subtitle_heading',
        array(
            'settings'      => 'luzuk_premium_counter_title_subtitle_heading',
            'section'       => 'luzuk_premium_counter_section',
            'label'         => __( 'Section Title & Section Subtitle', 'lz-fitness-premium' ),
        )
    )
);
$wp_customize->add_setting(
    'luzuk_countersec_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Aenean vestibulum tortor erat nec tincidunt ex molestie vel Nam lacus', 'lz-fitness-premium' )
    )
);
$wp_customize->add_control(
    'luzuk_countersec_title',
    array(
        'settings'      => 'luzuk_countersec_title',
        'section'       => 'luzuk_premium_counter_section',
        'type'          => 'textarea',
        'label'         => __( 'Section Title', 'lz-fitness-premium' )
    )
);

addColorPalatOption($wp_customize, 'luzuk_counter_sectionttlcolor', 'luzuk_premium_counter_section', 'Section Title color', '#313131');

$wp_customize->add_setting(
    'luzuk_counter_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Adipiscing elit. Vivamus eu pharetra ex. Etiam eget diam ligula. Sed blandit ante. Vivamus feugiat.', 'lz-fitness-premium' )
    )
);
$wp_customize->add_control(
    'luzuk_counter_subtitle',
    array(
        'settings'      => 'luzuk_counter_subtitle',
        'section'       => 'luzuk_premium_counter_section',
        'type'          => 'textarea',
        'label'         => __( 'Section Sub Title', 'lz-fitness-premium' )
    )
);

addColorPalatOption($wp_customize, 'luzuk_counter_sectionsubttlcolor', 'luzuk_premium_counter_section', 'Section Sub Title color', '#6d6c6c');


$wp_customize->add_setting('luzuk_counter_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'luzuk_counter_npp_heading',
        array(
            'settings'      => 'luzuk_counter_npp_heading',
            'section'       => 'luzuk_premium_counter_section',
            'label'         => __( 'Number Of Counter', 'Luzuk' ),
        )
    )
);    
$wp_customize->add_setting('luzuk_counter_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 2));
$wp_customize->add_control(
    'luzuk_counter_npp_count',
    array(
        'settings'      => 'luzuk_counter_npp_count',
        'section'       => 'luzuk_premium_counter_section',
        'type'          => 'select',
        'label'         => __( 'Number of counter to show', 'Luzuk' ),
        'choices'=>array(1,2,3,4,5,6)
    )
);

for( $i = 1; $i <= 6; $i++ ){
    $wp_customize->add_setting(
        'luzuk_counter_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_counter_header'.$i,
            array(
                'settings'      => 'luzuk_counter_header'.$i,
                'section'       => 'luzuk_premium_counter_section',
                'label'         => __( 'Counter ', 'Luzuk' ).$i
            )
        )
    );

lzAddElement($wp_customize, 'luzuk_counter_page_number_'.$i, 'luzuk_premium_counter_section', $type = 'text', $label="Counter Number", $callback ='luzuk_sanitize_text', $default='150');
lzAddElement($wp_customize, 'luzuk_counter_page_title_'.$i, 'luzuk_premium_counter_section', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Management Team');
  
}

    addColorPalatOption($wp_customize, 'luzuk_countersecnumtextColor', 'luzuk_premium_counter_section', 'Counter Number Text color', '#b099dd');
    addColorPalatOption($wp_customize, 'luzuk_countersecnumtexthoverColor', 'luzuk_premium_counter_section', 'Counter Number Text Hover color', '#6843c4');

    addColorPalatOption($wp_customize, 'luzuk_countersecnum_numbertitleColor', 'luzuk_premium_counter_section', 'Counter title color', '#2f2f2f');
    addColorPalatOption($wp_customize, 'luzuk_countersecnum_numbertitlehvrColor', 'luzuk_premium_counter_section', 'Counter title Hover color', '#6d6c6c');


        addColorPalatOption($wp_customize, 'luzuk_countersecnum_mainbxhgtbrssColor', 'luzuk_premium_counter_section', 'Counter Box Background color', '#fff');
    addColorPalatOption($wp_customize, 'luzuk_countersecnum_hoverbgsscolorColor', 'luzuk_premium_counter_section', 'Counter Box Hover Background color', '#fff');

    addColorPalatOption($wp_customize, 'luzuk_countersecnum_mainbxbgColor', 'luzuk_premium_counter_section', 'Counter Box Border color', '#b099dd');

    addColorPalatOption($wp_customize, 'luzuk_countersecnum_hvrhihghlightbgssColor', 'luzuk_premium_counter_section', 'Counter Box Hover Border color', '#6943c4');
