<?php
$wp_customize->add_section(
	'appointment_section',
	array(
		'title'         => __( 'Enquiry Section', 'Luzuk' ), 
		'panel'   => 'luzuk_premium_home_panel',
	)
);

$wp_customize->add_setting(
    'luzuk_enquiry_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'luzuk_enquiry_section_disable',
        array(
            'settings'      => 'luzuk_enquiry_section_disable',
            'section'       => 'appointment_section',
            'label'         => __( 'Disable Section', 'Luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk Premium' ),
                'off' => __( 'No', 'Luzuk Premium' )
            )   
        )
    )
);
backgroundManager($wp_customize, 'secappointment', 'appointment_section', $color='#ffffff', get_template_directory_uri().'/images/section.jpg', 'color');

lzCustomLable($wp_customize, 'secappointment_padding', 'appointment_section', ' Section Padding Setting:');

$wp_customize->add_setting(
    'secappointment_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'secappointment_toppadding',
    array(
        'settings'      => 'secappointment_toppadding',
        'section'       => 'appointment_section',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'luzuk' )
    )
);
$wp_customize->add_setting(
    'secappointment_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'secappointment_bottompadding',
    array(
        'settings'      => 'secappointment_bottompadding',
        'section'       => 'appointment_section',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'luzuk' )
    )
);

$wp_customize->add_setting(
    'appointment_section_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'appointment_section_subtitle_heading',
        array(
            'settings'      => 'appointment_section_subtitle_heading',
            'section'       => 'appointment_section',
            'label'         => __( 'Section Form Title', 'Luzuk' ),
        )
    )
);


$wp_customize->add_setting(
    'appointment_section_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Get in touch!', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'appointment_section_title',
    array(
        'settings'      => 'appointment_section_title',
        'section'       => 'appointment_section',
        'type'          => 'text',
        'label'         => __( 'Add Form Title Here:', 'Luzuk' )
    )
);
addColorPalatOption($wp_customize, 'appointment_SectiontitleColor', 'appointment_section', 'Section Title color', '#ffffff');

$wp_customize->add_setting(
	'appointment_form_shortcode_lbl',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
	)
);

$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'appointment_form_shortcode_lbl',
		array(
			'settings'      => 'appointment_form_shortcode_lbl',
			'section'       => 'appointment_section',
			'label'         => __( 'Add form shortcode', 'Luzuk' ),
		)
	)
);
$wp_customize->add_setting(
	'appointment_form_shortcode',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Add form shortcode on customiser', 'Luzuk' )
	)
);
$wp_customize->add_control(
	'appointment_form_shortcode',
	array(
		'settings'      => 'appointment_form_shortcode',
		'section'       => 'appointment_section',
		'type'          => 'text',
		'label'         => __( 'Shortcode', 'Luzuk' )
	)
);


addColorPalatOption($wp_customize, 'appointment_formTextColor', 'appointment_section', 'Form text & placeholder text color', '#666'); 

addColorPalatOption($wp_customize, 'appointment_labelColor', 'appointment_section', 'Form label Text color', '#ffffff');

addColorPalatOption($wp_customize, 'appointment_formborderColor', 'appointment_section', 'Form text fields Background color', '#ffffff');

addColorPalatOption($wp_customize, 'appointment_btntextColor', 'appointment_section', 'Form button text color', '#ffffff');

addColorPalatOption($wp_customize, 'appointment_btntexthoverColor', 'appointment_section', 'Form button text hover color', '#000000');

addColorPalatOption($wp_customize, 'appointment_btnbgColor', 'appointment_section', 'Form button background color', '#212121'); 

addColorPalatOption($wp_customize, 'appointment_btnbghovborderColor', 'appointment_section', 'Form button hover Background color', '#5eb652');
