<?php
    $wp_customize->add_section(
        'luzuk_premium_aboutus_section',
        array(
            'title' => __( 'Facilities Section', 'lz-fitness-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'luzuk_premium_aboutus_section_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'luzuk_premium_aboutus_section_disable',
            array(
                'settings'      => 'luzuk_premium_aboutus_section_disable',
                'section'       => 'luzuk_premium_aboutus_section',
                'label'         => __( 'Disable Section', 'lz-fitness-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'lz-fitness-premium' ),
                    'off' => __( 'No', 'lz-fitness-premium' )
                ),
            )
        )
    );

 

backgroundManager($wp_customize, 'facilities', 'luzuk_premium_aboutus_section', $color='#ffffff', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'forfacilitisection_padding', 'luzuk_premium_aboutus_section', ' Section facilities Padding Setting:'); 

$wp_customize->add_setting(
    'facilitiosection_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '6em', 'unbox' )
    )
);
$wp_customize->add_control(
    'facilitiosection_toppadding',
    array(
        'settings'      => 'facilitiosection_toppadding',
        'section'       => 'luzuk_premium_aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'unbox' )
    )
);
$wp_customize->add_setting(
    'facilitiosection_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'unbox' )
    )
);
$wp_customize->add_control(
    'facilitiosection_bottompadding',
    array(
        'settings'      => 'facilitiosection_bottompadding',
        'section'       => 'luzuk_premium_aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'unbox' )
    )
);

  $wp_customize->add_setting(
        'luzuk_aboutus_title_heading',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    ); 
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_aboutus_title_heading',
            array(
                'settings'      => 'luzuk_aboutus_title_heading',
                'section'       => 'luzuk_premium_aboutus_section',
                'label'         => __( 'Section Title', 'lz-fitness-premium' ),
            )
        )
    );  
    $wp_customize->add_setting(
        'luzuk_aboutus_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Our Facilities', 'lz-fitness-premium' )
        )
    );
    $wp_customize->add_control(
        'luzuk_aboutus_title',
        array(
            'settings'      => 'luzuk_aboutus_title',
            'section'       => 'luzuk_premium_aboutus_section',
            'type'          => 'text',
            'label'         => __( 'Section Title', 'lz-fitness-premium' )
        )
    ); 
   
     
    
// Heading color
addColorPalatOption($wp_customize, 'facilities_HeadingColor', 'luzuk_premium_aboutus_section', 'Section Title color ', '#3b3b3b');

 lzAddElement($wp_customize, 'luzuk_about_sub_title', 'luzuk_premium_aboutus_section', 'textarea', $label="Section Sub Text", 'luzuk_sanitize_text', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever.');


// Heading color
addColorPalatOption($wp_customize, 'facilities_secsubtexColor', 'luzuk_premium_aboutus_section', 'Section Sub Text color ', '#7790a4');

    $wp_customize->add_setting('luzuk_about_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'luzuk_about_npp_heading',
        array(
            'settings'      => 'luzuk_about_npp_heading',
            'section'       => 'luzuk_premium_aboutus_section',
            'label'         => __( 'Number Of Facility Plans', 'lz-fitness-premium' ),
        )
    )
);    
$wp_customize->add_setting('luzuk_about_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'luzuk_about_npp_count',
    array(
        'settings'      => 'luzuk_about_npp_count',
        'section'       => 'luzuk_premium_aboutus_section',
        'type'          => 'select',
        'label'         => __( 'Number of plan to show', 'lz-fitness-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'luzuk_about_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_about_header'.$i,
            array(
                'settings'      => 'luzuk_about_header'.$i,
                'section'       => 'luzuk_premium_aboutus_section',
                'label'         => __( 'Facility Page ', 'lz-fitness-premium' ).$i
            )
        )
    );

$wp_customize->add_setting(
        'luzuk_about_page_icon'.$i,
        array(
            'default'           => 'fa fa-th-large',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'luzuk_about_page_icon'.$i,
            array(
                'settings'      => 'luzuk_about_page_icon'.$i,
                'section'       => 'luzuk_premium_aboutus_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'lz-fitness-premium' ),
            )
        )
    );   
lzAddElement($wp_customize, 'luzuk_about_page_title_'.$i, 'luzuk_premium_aboutus_section', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Optional finishing');

lzAddElement($wp_customize, 'luzuk_about_page_description_'.$i, 'luzuk_premium_aboutus_section', $type = 'textarea', $label="Description", $callback ='luzuk_sanitize_text', $default='There are many variations passages of Lorem Ipsum availables.');
}

addColorPalatOption($wp_customize, 'Facilitiebox_fpagetitleColor', 'luzuk_premium_aboutus_section', 'Facilitie Page Title color ', '#ffffff');

addColorPalatOption($wp_customize, 'facilitie_iconColor', 'luzuk_premium_aboutus_section', 'Facility Icon color ', '#ffffff');
addColorPalatOption($wp_customize, 'facilitie_iconHoverColor', 'luzuk_premium_aboutus_section', 'Facility Hover Icon color ', '#ffffff');

addColorPalatOption($wp_customize, 'facilitie_iconhoborColor', 'luzuk_premium_aboutus_section', 'Facility Icon Hover Border color ', '#ffffff');

addColorPalatOption($wp_customize, 'Facilitiebox_fpagetitleColor', 'luzuk_premium_aboutus_section', 'Facility Page Title color ', '#ffffff');


addColorPalatOption($wp_customize, 'Facilitiebox_fpagetextColor', 'luzuk_premium_aboutus_section', 'Facility Page Text color ', '#ffffff');


addColorPalatOption($wp_customize, 'faciltboxBgColor', 'luzuk_premium_aboutus_section', 'Facility Box Background color ', '#61bd66');

addColorPalatOption($wp_customize, 'faciltboxBgHoverBgssColor', 'luzuk_premium_aboutus_section', 'Facility Box Hover Background color ', '#61bd66');


addColorPalatOption($wp_customize, 'Facilitiebox_fpagetitleHoverColor', 'luzuk_premium_aboutus_section', 'Facility Page Title & Text Hover color ', '#ffffff');
