<?php
$wp_customize->add_section(
    'feature_products_section',
    array(
        'title' => __( 'Feature Products Section', 'Luzuk' ), 
        'panel' => 'luzuk_premium_home_panel'
    )
);

$wp_customize->add_setting(
    'feature_products_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'feature_products_section_disable',
        array(
            'settings'      => 'feature_products_section_disable',
            'section'       => 'feature_products_section',
            'label'         => __( 'Disable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ), 
                'off' => __( 'No', 'Luzuk' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'featuredpro', 'feature_products_section', $color='#ffffff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'forfacilitisection_padding', 'feature_products_section', ' Section Padding Setting:'); 

$wp_customize->add_setting(
    'featuredpro_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'unbox' )
    )
);
$wp_customize->add_control(
    'featuredpro_toppadding',
    array(
        'settings'      => 'featuredpro_toppadding',
        'section'       => 'feature_products_section',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'unbox' )
    )
);
$wp_customize->add_setting(
    'featuredpro_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'unbox' )
    )
);
$wp_customize->add_control(
    'featuredpro_bottompadding',
    array(
        'settings'      => 'featuredpro_bottompadding',
        'section'       => 'feature_products_section',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'unbox' )
    )
);


$wp_customize->add_setting(
    'featured_product_title_sub_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'featured_product_title_sub_title_heading',
        array(
            'settings'      => 'featured_product_title_sub_title_heading',
            'section'       => 'feature_products_section',
            'label'         => __( 'Section Title & Sub Text', 'Luzuk' ),
        )
    )
);    

$wp_customize->add_setting(
    'featured_product_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our Products', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'featured_product_title',
    array(
        'settings'      => 'featured_product_title',
        'section'       => 'feature_products_section',
        'type'          => 'text',
        'label'         => __( 'Section Title', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'featureproducts_secTitleColor', 'feature_products_section', 'Section Title color ', '#3b3b3b');



$wp_customize->add_setting(
    'featured_product_subttl',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever.', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'featured_product_subttl',
    array(
        'settings'      => 'featured_product_subttl',
        'section'       => 'feature_products_section',
        'type'          => 'textarea',
        'label'         => __( 'Section Sub Text', 'Luzuk' ),
    )
);


addColorPalatOption($wp_customize, 'featureproducts_SubTitleColor', 'feature_products_section', 'Section Sub Text color ', '#68869e');


$wp_customize->add_setting('featureproductssectionimgheight_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'featureproductssectionimgheight_lbl',
        array(
            'settings'      => 'featureproductssectionimgheight_lbl',
            'section'       => 'feature_products_section',
            'label'         => __( 'Note:', 'Luzuk' ),  
            'description'   => __( 'Kindly Add Feature Products Images of Same Resolution', 'Luzuk' ),
        )
    )
);


$wp_customize->add_setting(
    'lz_prodbutton_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'BUY NOW' )
    )
);
$wp_customize->add_control(
    'lz_prodbutton_title',
    array(
        'settings'      => 'lz_prodbutton_title',
        'section'       => 'feature_products_section',
        'type'          => 'text',
        'label'         => __( 'Add Product Button Text', 'Luzuk' ),
    )
);
addColorPalatOption($wp_customize, 'featureproducts_NameText_Color', 'feature_products_section', 'Products Title/Name Text color ', '#203a47');

addColorPalatOption($wp_customize, 'featureproducts_PriceText_Color', 'feature_products_section', 'Products Regular price color ', '#67859d');

addColorPalatOption($wp_customize, 'featureproducts_PriceTextmainColor', 'feature_products_section', 'Products Sale Price color ', '#60be68');

addColorPalatOption($wp_customize, 'featureproducts_buttBg_Color', 'feature_products_section', 'Products Button Background color ', '#ffffff');

addColorPalatOption($wp_customize, 'featureproducts_butthovBg_Color', 'feature_products_section', 'Products Button Hover Background color ', '#212121');

addColorPalatOption($wp_customize, 'featureproducts_buttbordBg_Color', 'feature_products_section', 'Products Button Border color ', '#efefef');

addColorPalatOption($wp_customize, 'featureprod_butthovbordBg_Color', 'feature_products_section', 'Products Button Hover Border color ', '#212121');

addColorPalatOption($wp_customize, 'featureproducts_butticon_Color', 'feature_products_section', 'Products Button Text color ', '#69879f');

addColorPalatOption($wp_customize, 'featureproducts_butthortex_Color', 'feature_products_section', 'Products Button Hover Text color ', '#ffffff');

addColorPalatOption($wp_customize, 'featureproducts_boxbg_Color', 'feature_products_section', 'Products Box Background color ', '#ffffff');


addColorPalatOption($wp_customize, 'featurepro_slidArrowColor', 'feature_products_section', ' Product Slider Arrow color', '#6a849b');

addColorPalatOption($wp_customize, 'featurepro_slidhoverArrowColor', 'feature_products_section', ' Product Slider Arrow color', '#ffffff');

addColorPalatOption($wp_customize, 'featurepro_nextprevindicatorbgColor', 'feature_products_section', 'Slider Arrow Background color', '#212121');

addColorPalatOption($wp_customize, 'featurepro_indicatorbg1Color', 'feature_products_section', 'Slider Arrow Hover Background color', '#61bd66');