<?php
    $wp_customize->add_section(
        'luzuk_premium_ourfeatureshmp_section',
        array(
            'title' => __( 'Our Features Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'luzuk_premium_ourfeatureshmp_section_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'luzuk_premium_ourfeatureshmp_section_disable',
            array(
                'settings'      => 'luzuk_premium_ourfeatureshmp_section_disable',
                'section'       => 'luzuk_premium_ourfeatureshmp_section',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    );
lzCustomLable($wp_customize, 'luzuk_features_sectionbackgrounddisplay', 'luzuk_premium_ourfeatureshmp_section', 'Background Manager For Complete Section');

backgroundManager($wp_customize, 'features_sub', 'luzuk_premium_ourfeatureshmp_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');


addColorPalatOption($wp_customize, 'ourfeatureshmp_svgwavebgColor', 'luzuk_premium_ourfeatureshmp_section', 'Section svg wave Background color', '#57bd6b');

addColorPalatOption($wp_customize, 'ourfeatureshmp_svgcirclebgColor', 'luzuk_premium_ourfeatureshmp_section', 'Section svg circle Background color', '#7669df');

$wp_customize->add_setting('luzuk_ourfeatureshmp_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'luzuk_ourfeatureshmp_npp_heading',
        array(
            'settings'      => 'luzuk_ourfeatureshmp_npp_heading',
            'section'       => 'luzuk_premium_ourfeatureshmp_section',
            'label'         => __( 'Number Of Features Plans', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('luzuk_ourfeatureshmp_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'luzuk_ourfeatureshmp_npp_count',
    array(
        'settings'      => 'luzuk_ourfeatureshmp_npp_count',
        'section'       => 'luzuk_premium_ourfeatureshmp_section',
        'type'          => 'select',
        'label'         => __( 'Number of plan to show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'luzuk_ourfeatureshmp_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_ourfeatureshmp_header'.$i,
            array(
                'settings'      => 'luzuk_ourfeatureshmp_header'.$i,
                'section'       => 'luzuk_premium_ourfeatureshmp_section',
                'label'         => __( 'Features Page ', 'luzuk-premium' ).$i
            )
        )
    );

    $wp_customize->add_setting(
        'luzuk_ourfeatureshmp_page_icon'.$i,
        array(
            'default'           => 'fa fa-print',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'luzuk_ourfeatureshmp_page_icon'.$i,
            array(
                'settings'      => 'luzuk_ourfeatureshmp_page_icon'.$i,
                'section'       => 'luzuk_premium_ourfeatureshmp_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'lz-fitness-premium' ),
            )
        )
    ); 

lzAddElement($wp_customize, 'luzuk_ourfeatureshmp_page_title_'.$i, 'luzuk_premium_ourfeatureshmp_section', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='High Quality Printing');

 
   // lzAddElement($wp_customize, 'luzuk_ourfeatureshmp_page_url_'.$i, 'luzuk_premium_ourfeatureshmp_section', $type = 'text', $label="Link", $callback ='esc_url', $default='Add link here');

}

addColorPalatOption($wp_customize, 'ourfeatureshmp_pageiconColor', 'luzuk_premium_ourfeatureshmp_section', 'Features Page Icon color ', '#9fbbd1');
addColorPalatOption($wp_customize, 'ourfeatureshmp_pageiconHoverColor', 'luzuk_premium_ourfeatureshmp_section', 'Features Page Icon Hover color ', '#ffffff');

addColorPalatOption($wp_customize, 'luzuk_ourfeatureshmp_featbxbgsscColor', 'luzuk_premium_ourfeatureshmp_section', 'Features Icon Background color ', '#fff');
addColorPalatOption($wp_customize, 'luzuk_ourfeatureshmp_featbxbgsscHoverColor', 'luzuk_premium_ourfeatureshmp_section', 'Features Icon Hover Background color ', '#ffca2a');

addColorPalatOption($wp_customize, 'luzuk_ourfeatureshmp_featpagettlColor', 'luzuk_premium_ourfeatureshmp_section', 'Features Page Title color ', '#69869d');

addColorPalatOption($wp_customize, 'luzuk_ourfeatureshmp_featpagettlhovColor', 'luzuk_premium_ourfeatureshmp_section', 'Features Page Title Hover color ', '#ffca2a');
