<?php 
$wp_customize->add_section(
	'luzuk_gallery_section',
	array(
		'title'         => __( 'Gallery Section', 'Luzuk Premium' ),
		'panel'   => 'luzuk_premium_home_panel',
	)
);
$wp_customize->add_setting(
	'luzuk_gallery_section_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);

$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'luzuk_gallery_section_disable',
		array(
			'settings'      => 'luzuk_gallery_section_disable',
			'section'       => 'luzuk_gallery_section',
			'label'         => __( 'Disable Section', 'Luzuk Premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'Luzuk Premium' ),
				'off' => __( 'No', 'Luzuk Premium' )
			)   
		)
	)
);


backgroundManager($wp_customize, 'gallery', 'luzuk_gallery_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'luzuk_gallerysectionpadding', 'luzuk_gallery_section', 'Section Padding Setting:');

$wp_customize->add_setting(
    'sec_galleryTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'sec_galleryTpadding',
    array(
        'settings'      => 'sec_galleryTpadding',
        'section'       => 'luzuk_gallery_section',
        'type'          => 'text',
        'label'         => __( 'Gallery Section Top Padding', 'Luzuk Premium' )
    )
);
$wp_customize->add_setting(
    'sec_galleryBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'sec_galleryBpadding',
    array(
        'settings'      => 'sec_galleryBpadding',
        'section'       => 'luzuk_gallery_section',
        'type'          => 'text',
        'label'         => __( 'Gallery Section Bottom Padding', 'Luzuk Premium' )
    )
);

$wp_customize->add_setting('luzuk_gallery_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'luzuk_gallery_npp_heading',
		array(
			'settings'      => 'luzuk_gallery_npp_heading',
			'section'       => 'luzuk_gallery_section',
			'label'         => __( 'Number Of Gallery images to show', 'Luzuk Premium' ),
		)
	)
);    
$wp_customize->add_setting('luzuk_gallery_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 19));
$wp_customize->add_control(
	'luzuk_gallery_npp_count',
	array(
		'settings'      => 'luzuk_gallery_npp_count',
		'section'       => 'luzuk_gallery_section',
		'type'          => 'select',
		'label'         => __( 'Number of Gallery images to show', 'Luzuk Premium' ),
		'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20)
	)
);

for( $i = 1; $i <= 20; $i++ ){
	$wp_customize->add_setting(
		'luzuk_gallery_heading'.$i,
		array(
			'sanitize_callback' => 'luzuk_sanitize_text'
		)
	);
	$wp_customize->add_control(
		new luzuk_Customize_Heading(
			$wp_customize,
			'luzuk_gallery_heading'.$i,
			array(
				'settings'      => 'luzuk_gallery_heading'.$i,
				'section'       => 'luzuk_gallery_section',
				'label'         => __( 'Gallery Image ', 'Luzuk Premium' ).$i, 
			)
		)
	);
	if(is_array($lzFitnessGallerySingleChoice)){
		$wp_customize->add_setting(
			'luzuk_gallery_page'.$i,
			array(
				'sanitize_callback' => 'absint'
			)
		);
		$wp_customize->add_control(
			'luzuk_gallery_page'.$i,
			array(
				'settings'      => 'luzuk_gallery_page'.$i,
				'section'       => 'luzuk_gallery_section',
				'type'=> 'select',
				'label'         => __( 'Select a Gallery Image', 'Luzuk Premium' ),
				'choices' => $lzFitnessGallerySingleChoice,
			)
		);
	}else{
		$wp_customize->add_setting('luzuk_gallery_section_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
		$wp_customize->add_control(
			new luzuk_Info_Text( 
				$wp_customize,
				'luzuk_gallery_section_lbl'.$i,
				array(
					'settings'		=> 'luzuk_gallery_section_lbl'.$i,
					'section'		=> 'luzuk_gallery_section',
					'label'			=> __( 'Note:', 'Luzuk Premium' ),	
					'description'	=> __( '<strong>Changes will not reflect unless you select the Gallery Image.</strong> <br/>Please add the gallary team from "Gallery menu" and then select gallary Image to show information.', 'Luzuk Premium' ),
				)
			)
		);
	}
}


//Image border color
addColorPalatOption($wp_customize, 'gallery_imgehovericonColor', 'luzuk_gallery_section', 'Gallery Image Hover Title color', '#fff');

addColorPalatOption($wp_customize, 'gallery_imgehovertibgColor', 'luzuk_gallery_section', 'Gallery Image Hover Title Background color', '#000');
