<?php   

$wp_customize->add_section(
    'luzuk_ct_service_section',
    array(
        'title'         => __( 'Services Section', 'print' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
$wp_customize->add_setting(
    'luzuk_ct_service_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'luzuk_ct_service_section_disable',
        array(
            'settings'      => 'luzuk_ct_service_section_disable',
            'section'       => 'luzuk_ct_service_section',
            'label'         => __( 'Disable Section', 'print' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'print' ),
                'off' => __( 'No', 'print' )
            )   
        )
    )
);
backgroundManager($wp_customize, 'ctservice', 'luzuk_ct_service_section', $color='#ffffff');


lzCustomLable($wp_customize, 'featureproductsection_padding', 'luzuk_ct_service_section', 'Services Section Padding Setting:'); 

$wp_customize->add_setting(
    'ctservice_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'ctservice_toppadding',
    array(
        'settings'      => 'ctservice_toppadding',
        'section'       => 'luzuk_ct_service_section',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'luzuk' )
    )
);
$wp_customize->add_setting(
    'ctservice_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'ctservice_bottompadding',
    array(
        'settings'      => 'ctservice_bottompadding',
        'section'       => 'luzuk_ct_service_section',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'luzuk' )
    )
);

$wp_customize->add_setting(
    'luzuk_ct_service_title_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'luzuk_ct_service_title_subtitle_heading',
        array(
            'settings'      => 'luzuk_ct_service_title_subtitle_heading',
            'section'       => 'luzuk_ct_service_section',
            'label'         => __( 'Section Title & Sub Text', 'print' ),
        )
    )
);

$wp_customize->add_setting(
    'luzuk_ct_service_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our Services', 'print' )
    )
);
$wp_customize->add_control(
    'luzuk_ct_service_title',
    array(
        'settings'      => 'luzuk_ct_service_title',
        'section'       => 'luzuk_ct_service_section', 
        'type'          => 'text',
        'label'         => __( 'Section Title', 'print' )
    )
);


addColorPalatOption($wp_customize, 'lz_servicessection_HeadingColor', 'luzuk_ct_service_section', 'Select Section Title color', '#3b3b3b');


$wp_customize->add_setting(
    'service_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever.', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'service_subtitle',
    array(
        'settings'      => 'service_subtitle',
        'section'       => 'luzuk_ct_service_section',
        'type'          => 'textarea',
        'label'         => __( 'Section Sub Text', 'Luzuk' ),
    )
);


addColorPalatOption($wp_customize, 'lz_service_subtitleColor', 'luzuk_ct_service_section', 'Select Section Sub Text color', '#7790a4');

/*for note text*/
$wp_customize->add_setting('lz_CT_service_sectionnoteser_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'lz_CT_service_sectionnoteser_lbl',
        array(
            'settings'      => 'lz_CT_service_sectionnoteser_lbl',
            'section'       => 'luzuk_ct_service_section',
            'label'         => __( 'Note:', 'print' ),    
            'description'   => __( 'Just place the shortcode "[SERVICES]" in your page to Show all services in a page', 'print' ),
        )
    )
);

/*for note text*/

$wp_customize->add_setting('lz_img_service_sectionnoteser_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'lz_img_service_sectionnoteser_lbl',
        array(
            'settings'      => 'lz_img_service_sectionnoteser_lbl',
            'section'       => 'luzuk_ct_service_section',
            'label'         => __( 'Note:', 'print' ),    
            'description'   => __( 'Please add the Same Recommended Image Size: 215X215px ', 'print' ),
        )
    )
);
/*for note text*/


$wp_customize->add_setting('luzuk_ct_service_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'luzuk_ct_service_npp_heading',
        array(
            'settings'      => 'luzuk_ct_service_npp_heading',
            'section'       => 'luzuk_ct_service_section',
            'label'         => __( 'Set Number Of service to show', 'print' ),
        )
    )
);    
$wp_customize->add_setting('luzuk_ct_service_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 5));
$wp_customize->add_control(
    'luzuk_ct_service_npp_count',
    array(
        'settings'      => 'luzuk_ct_service_npp_count',
        'section'       => 'luzuk_ct_service_section',
        'type'          => 'select',
        'label'         => __( 'Number of Services to show', 'print' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12,)
    )
);

// service PAGES
for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'luzuk_ct_service_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_ct_service_heading'.$i,
            array(
                'settings'      => 'luzuk_ct_service_heading'.$i,
                'section'       => 'luzuk_ct_service_section',
                'label'         => __( 'Our Service', 'print' ).$i,
            )
        )
    );

    if(is_array($lzFitnessserviceSingleChoice)){
        $wp_customize->add_setting(
            'luzuk_ct_service_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'luzuk_ct_service_page'.$i,
            array(
                'settings'      => 'luzuk_ct_service_page'.$i,
                'section'       => 'luzuk_ct_service_section',
                'type'=> 'select',
                'label'         => __( 'Select a service', 'print' ),
                'choices' => $lzFitnessserviceSingleChoice,
            )
        );

    }else{
        $wp_customize->add_setting('luzuk_ct_service_section_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'luzuk_ct_service_section_lbl'.$i,
                array(
                    'settings'      => 'luzuk_ct_service_section_lbl'.$i,
                    'section'       => 'luzuk_ct_service_section',
                    'label'         => __( 'Note:', 'print' ),  
                    'description'   => __( '<strong>Changes will not reflect unless you select the service.</strong> <br/>Please add the service from "services menu" and then select service to show.', 'print' ),
                )
            )
        );
    }

}


addColorPalatOption($wp_customize, 'lz_servicessection_ServiceBoxBackgroundColor', 'luzuk_ct_service_section', 'Select Service Box Background color', '#fff');

addColorPalatOption($wp_customize, 'lz_servicessection_ServiceBoxTitleColor', 'luzuk_ct_service_section', 'Select Service Page Title color', '#333333');

addColorPalatOption($wp_customize, 'lz_servicessection_ServicePageTitleHoverColor', 'luzuk_ct_service_section', 'Select Service Page Title Hover color', '#5aac3e');

addColorPalatOption($wp_customize, 'sec_ServiceimgHoverbgColor', 'luzuk_ct_service_section', 'Select Service Image Hover Overlay Background color', '#ffca2a');


