<?php 

$wp_customize->add_section(
    'testimonialals_section',
    array(
        'title'         => __( 'Testimonials Section', 'luzuk-premium' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);

$wp_customize->add_setting(
    'luzuk_testimonialsection_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'luzuk_testimonialsection_disable',
        array(
            'settings'      => 'luzuk_testimonialsection_disable',
            'section'       => 'testimonialals_section',
            'label'         => __( 'Disable Section', 'Luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk Premium' ),
                'off' => __( 'No', 'Luzuk Premium' )
            )   
        )
    )
);


backgroundManager($wp_customize, 'testimonials', 'testimonialals_section', $color='#ffffff', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'featureproductsection_padding', 'testimonialals_section', ' Section Testimonials Box Padding Setting:'); 

$wp_customize->add_setting(
    'testimonialsection_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'testimonialsection_toppadding',
    array(
        'settings'      => 'testimonialsection_toppadding',
        'section'       => 'testimonialals_section',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'luzuk' )
    )
);
$wp_customize->add_setting(
    'testimonialsection_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'testimonialsection_bottompadding',
    array(
        'settings'      => 'testimonialsection_bottompadding',
        'section'       => 'testimonialals_section',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'luzuk' )
    )
);

$wp_customize->add_setting(
    'testimonialals_title__heading',
    array(
        'sanitize_callback' => 'lz_luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'testimonialals_title__heading',
        array(
            'settings'      => 'testimonialals_title__heading',
            'section'       => 'testimonialals_section',
            'label'         => __( 'Section Title ', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
        'luzuk_testimonialals_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Our Testimonials', 'lz-fitness-premium' )
        )
    );
    $wp_customize->add_control(
        'luzuk_testimonialals_title',
        array(
            'settings'      => 'luzuk_testimonialals_title',
            'section'       => 'testimonialals_section',
            'type'          => 'text',
            'label'         => __( 'Title for section', 'lz-fitness-premium' )
        )
    );

// Heading color
addColorPalatOption($wp_customize, 'testimonialals_HeadingColor', 'testimonialals_section', 'Section Heading color', '#212121');


$wp_customize->add_setting(
    'testimonial_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever.', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'testimonial_subtitle',
    array(
        'settings'      => 'testimonial_subtitle',
        'section'       => 'testimonialals_section',
        'type'          => 'text',
        'label'         => __( 'Section Sub Text', 'Luzuk' ),
    )
);

// Heading sub color
addColorPalatOption($wp_customize, 'testimonialals_subtextColor', 'testimonialals_section', 'Section Sub Text color', '#7490a5');




$wp_customize->add_setting('lz_luzuk_test_npp_heading',array('sanitize_callback' => 'lz_luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'lz_luzuk_test_npp_heading',
        array(
            'settings'      => 'lz_luzuk_test_npp_heading',
            'section'       => 'testimonialals_section',
            'label'         => __( 'Number Of Testimonial to show', 'luzuk-premium' ),
        )
    )
);    

$wp_customize->add_control(
    'lz_luzuk_test_npp_count',
    array(
        'settings'      => 'lz_luzuk_test_npp_count',
        'section'       => 'testimonialals_section',
        'type'          => 'select',
        'label'         => __( 'Number of Client to show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);


for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'testimonialals_heading'.$i,
        array(
            'sanitize_callback' => 'lz_luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'testimonialals_heading'.$i,
            array(
                'settings'      => 'testimonialals_heading'.$i,
                'section'       => 'testimonialals_section',
                'label'         => __( 'Add Testimonial ', 'luzuk-premium' ).$i,
            )
        )
    );
    if(is_array($lzFitnessTesimonialsSingleChoice)){
        $wp_customize->add_setting(
            'testimonialals_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'testimonialals_page'.$i,
            array(
                'settings'      => 'testimonialals_page'.$i,
                'section'       => 'testimonialals_section',
                'type'=> 'select',
                'label'         => __( 'Select A Client', 'luzuk-premium' ),
                'choices' => $lzFitnessTesimonialsSingleChoice,
            )
        );

    }else{
        $wp_customize->add_setting('lz_luzuk_premium_testimonials_section_lbl'.$i, array('sanitize_callback'=>'lz_luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'lz_luzuk_premium_testimonials_section_lbl'.$i,
                array(
                    'settings'      => 'lz_luzuk_premium_testimonials_section_lbl'.$i,
                    'section'       => 'testimonialals_section',
                    'label'         => __( 'Note:', 'luzuk-premium' ),  
                    'description'   => __( 'Just place the shortcode "[TESTIMONIALS]" in your page to list the Testimonials in a page', 'luzuk-premium' ),
                )
            )
        );
    }
}



// Text color

addColorPalatOption($wp_customize, 'testimonialals_contentbgColor', 'testimonialals_section', 'Testimonial Content Box Background Color', '#ffffff');

addColorPalatOption($wp_customize, 'testimonialals_contentborColor', 'testimonialals_section', 'Testimonial Content Box Border Color', '#e9e9e9');

addColorPalatOption($wp_customize, 'testimonialals_boxTextColor', 'testimonialals_section', 'Testimonial Text Color', '#1c232b');

addColorPalatOption($wp_customize, 'testimonialals_clientnameColor', 'testimonialals_section', 'Testimonial Client Name Color', '#68869e');

// indicator active color
addColorPalatOption($wp_customize, 'testimoni_nextprevindicatorbgColor', 'testimonialals_section', 'Slider Active indicator Color', '#60c066');

// indicator  color
addColorPalatOption($wp_customize, 'testimoni_indicatorbg1Color', 'testimonialals_section', 'Slider indicator Color', '#dddee0');

// img hover color
addColorPalatOption($wp_customize, 'testimoni_imghoverbgColor', 'testimonialals_section', 'Image Hover Overlay Color', '#7cbe67');

