<?php
/**
 * The main template file.
 *
 * Used to display the homepage when home.php doesn't exist.
 */
?>
<?php get_header(); ?>

<header class="page-main-header innerblogstatpage">
    <?php if( get_theme_mod('innerpagesallheaderanimation_button_display','show' ) == 'show') :
        ?>  
       <!--  <div class="layer-1">
            <img  src="<?php //echo esc_url(get_template_directory_uri().'/images/icon2.png');?>" alt="" />
        </div>  -->
        <div class="layer-2">
            <img  src="<?php echo esc_url(get_template_directory_uri().'/images/icon3.png');?>" alt="" />
        </div>
        <!-- <div class="layer-3">
            <img  src="<?php //echo esc_url(get_template_directory_uri().'/images/icon4.png');?>" alt="" />
        </div> -->
        <div class="layer-4">
            <img  src="<?php echo esc_url(get_template_directory_uri().'/images/icon5.png');?>" alt="" />
        </div>
        <div class="layer-7">
            <img  src="<?php echo esc_url(get_template_directory_uri().'/images/icon8.png');?>" alt="" />
        </div>
        <div class="layer-8">
            <img  src="<?php echo esc_url(get_template_directory_uri().'/images/icon6.png');?>" alt="" />
        </div>
        <div class="layer-9">
            <img  src="<?php echo esc_url(get_template_directory_uri().'/images/icon8.png');?>" alt="" />
        </div>
    <?php endif ?>
    <div>
      <?php $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));?>
      <img src="<?php echo !empty($image)?$image : get_template_directory_uri().'/images/default-gray.png';?>" class="ht-page-header-img" alt="<?php the_title();?>" />
  </div>
  <div class="container">
      <?php the_title( '<h1 class="ht-main-title">', '</h1>' ); ?>
      <div class="clearfix"></div>
  </div>
</header><!-- .entry-header -->



<main id="innerpage-box">
	<div class="container">
     <div id="blog-box" class="col-md-9 innerpage-whitebox">
         <?php
         $current_page = max(1, get_query_var('paged'));
         $luzuk_blog_cat_exclude = get_theme_mod('luzuk_blog_categories');
         $luzuk_blog_cat_exclude = explode(',', $luzuk_blog_cat_exclude);
         $excerpt = get_theme_mod('luzuk_blog_categories_settings');
         $args = array(
            'category__not_in' => $luzuk_blog_cat_exclude,
                // 'page'=,
            'paged'=> $current_page,

        );
         $query = new WP_Query($args);
         if($query -> have_posts()):
            while($query -> have_posts()) : $query -> the_post();
             $luzuk_image = wp_get_attachment_image_src(get_post_thumbnail_id() , 'total-blog-thumb');
             $img = (has_post_thumbnail())?esc_url($luzuk_image[0]):get_template_directory_uri().'/images/default.png';
             ?>
                   <div class="inner-blog-post">
                    <div class="row row-eq-height">
                     <div class="col-md-4 padding0">
                             <div class="inside-full-height">
                                <a href="<?php the_permalink(); ?>">
                                    <div class="ht-blog-thumbnail box">
                                   
                                         
                                         <img class="inner-blog-img" src="<?php echo $img; ?>" alt="<?php the_title(); ?>">
                                 </div>
                             </a> 
                             <div class="clearfix"></div>
                         </div>
                         </div>
                    <div class="col-md-8 col-sm-8 col-xs-12 inner-blog-excerpt">
                        <div class="inside-full-height">
                           <?php if( get_theme_mod('postdate_button_display','show' ) == 'show') :
                               ?>
                               <div class="htblogdate"><?php echo get_the_date( 'j M, Y' ); ?></div>
                           <?php endif ?> 
                           <a href="<?php the_permalink(); ?>"> <h4><?php the_title(); ?></h4></a>
                           <?php echo wp_trim_words(get_the_content(), 40); ?>
                           <hr>
                           <div class="clearfix"></div>
                           <div class="col-md-6 col-sm-6 col-xs-12 social-Media padding0">
                            <a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink();?>" target="_blank"><i class="fa fa-facebook" aria-hidden="true"></i></a>
                            <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink();?>&title=<?php the_title();?>&source=<?php the_title();?>" target="_blank"><i class="fa fa-linkedin" aria-hidden="true"></i></a>
                            <a href="https://twitter.com/share?url=<?php the_permalink();?>&amp;text=<?php the_title();?>" target="_blank"><i class="fa fa-twitter" aria-hidden="true"></i></a>
                            <a href="http://www.digg.com/submit?url=<?php the_permalink();?>" target="_blank"><i class="fa fa-digg" aria-hidden="true"></i></a>

                        </div>
                        <div class="col-md-6 col-sm-6 col-xs-12 bloginner-commentbox padding0">
                            <i class="fa fa-comment"></i>Comments (<?php echo $my_var = get_comments_number(); ?>) 
                        </div>
                    </div>
                </div>
            </div>
            <div class="clearfix"></div>
        </div>
    <?php
endwhile;
endif;
wp_reset_postdata();
?>
</div>
<div class="col-md-3">
 <div <div id="secondary" class="widget-area">
    <?php dynamic_sidebar('lz-fitness-blog-sidebar'); ?>
</div>
</div>
<div class="clearfix"></div>

<div class="row">
 <div class="col-md-12">
    <div class="pagingation">
        <?php lzGetPagination($query);?>
    </div>
</div>
</div>
</div>
</main>
<?php get_footer(); ?>
