<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package LZ Fitness Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css?family=Roboto:700" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Dancing+Script" rel="stylesheet">
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>

	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>

	<script type="text/javascript">
		$(document).ready(function(){
			$("#formButton").click(function(){
				$("#form1").toggle();
			});
		});
 	</script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <div class="main-container">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'gurukul' ); ?></a>
		<header id="ht-masthead" class="ht-site-header">
			<div class="header-top">
				<div class="container">
					<div class="col-md-6 col-sm-6 Header-tagline padding0">								
						 <?php if( get_theme_mod('luzuk_tagline_display','show' ) == 'show') : ?>  
						<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>
						 <?php endif ?>
					</div>
					<div class="col-md-6 col-sm-6">
						<?php
							$socialtag = get_theme_mod('lz_fitness_headermain_socialtag', 'Follow Us:');
							// $facebook = get_theme_mod('lz_fitness_header_fb','Facebook');
							// $twitter = get_theme_mod('lz_fitness_header_tw','Twitter');
							// $googlePlus = get_theme_mod('lz_fitness_header_it','GooglePlus');
							// $linkedIn = get_theme_mod('lz_fitness_header_in','Linked In');
							// $instagram = get_theme_mod('lz_fitness_header_insta','Instagram');
							// $youtube = get_theme_mod('lz_fitness_header_yt','Youtube');

							$facebook = get_theme_mod('lz_fitness_header_fb', '//facebook.com/');
							$twitter = get_theme_mod('lz_fitness_header_tw', '//twitter.com/');
							$googlePlus = get_theme_mod('lz_fitness_header_it', '//plus.google.com/');
							$linkedIn = get_theme_mod('lz_fitness_header_in', '//linkedin.com/');
							$instagram = get_theme_mod('lz_fitness_header_insta', '//www.instagram.com/');
							$youtube = get_theme_mod('lz_fitness_header_yt', '//www.youtube.com/');

							?>
							<div class="header-social-links">
								<?php if($socialtag){ ?>
									<?php echo esc_html($socialtag);  ?> 
								<?php } ?>
								<?php if(!empty($facebook)){ ?>
									<a href="<?php echo $facebook ?>" target="_blank" title="Facebook"><span class="fa fa-facebook"></span></a>
								<?php }?>
								<?php if(!empty($twitter)){ ?>
									<a href="<?php echo $twitter ?>" target="_blank" title="Twitter"><span class="fa fa-twitter"></span></a>
								<?php }?>
								<?php if(!empty($linkedIn)){ ?>
									<a href="<?php echo $linkedIn ?>" target="_blank" title="Linked In"><span class="fa fa-linkedin"></span></a>
								<?php }?>
								<?php if(!empty($googlePlus)){ ?>
									<a href="<?php echo $googlePlus ?>" target="_blank" title="Google Plus"><span class="fa fa-google-plus"></span></a>
								<?php }?>
								<?php if(!empty($instagram)){ ?>
									<a href="<?php echo $instagram ?>" target="_blank" title="Instagram"><span class="fa fa-instagram"></span></a>
								<?php }?>
								<?php if(!empty($youtube)){ ?>
									<a href="<?php echo $youtube ?>" target="_blank" title="youtube"><span class="fa fa-youtube"></span></a>
								<?php }?>
							</div>
					</div>
				<div class="clearfix"></div>
				</div>
				<div class="clearfix"></div>
			</div>
			<div class="medal-header">
				<div class="col-md-4 col-sm-12 col-md-offset-1">
					<div class="logobox">
						<?php 
							if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
								the_custom_logo();					
							 endif; ?>
						 <?php if( get_theme_mod('luzuk_sitetitle_display','show' ) == 'show') : ?>  
						<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
						 <?php endif ?>

							
							<!-- .site-branding -->
						<!-- .site-branding -->
					</div>
					<div class="clearfix"></div>
				</div>
				<div class="header-right col-md-6 padding0">
					<div class="header-box">
							<?php
							$phone = get_theme_mod('lz_fitness_headermain_phone', '+123-345-6789');
							$email = get_theme_mod('lz_fitness_headermain_email', 'info@yourwebsite.com');						
							$address1 = get_theme_mod('lz_fitness_headermain_address1', '234 Wales Street');
							$address2 = get_theme_mod('lz_fitness_headermain_address2', 'Syd, Australia 60001');					
							$time1 = get_theme_mod('lz_fitness_headermain_time1', 'Mon-Sat 8.00-18.00');
							$time2 = get_theme_mod('lz_fitness_headermain_time2', 'Sunday CLOSED');
							?>
							<div class="header-right-box">
								<?php if($phone || $email){ ?>
										<div class="col-md-1 col-sm-1 textcenter padding0">
										<i class="fa fa-phone" aria-hidden="true"></i>
										</div>
										<div class="col-md-3 col-sm-3 padding0">	
											<div class="contact-border">
												<div class="mailto"><a href="tel:<?php echo $phone;?>"><?php echo ($phone);  ?></a></div>
												<div class="mailto"><a href="mailto:<?php echo $email;?>"><?php echo $email ;?></a></div>
											</div>
											<div class="clearfix"></div>
										</div>
								<?php } ?>

								<?php if($address1 || $address2){ ?>
										<div class="col-md-1 col-sm-1 textcenter padding0">
										<i class="fa fa-map-marker" aria-hidden="true"></i>
										</div>
										<div class="col-md-3 col-sm-3 padding0">	
											<div class="contact-border">
												<div class="themetext"><?php echo $address1;?></div>
												<div class="data"><?php echo $address2;?></div>
											</div>
											<div class="clearfix"></div>
										</div>
								<?php } ?>

								<?php if($time1 || $time2){ ?>
										<div class="col-md-1 col-sm-1 textcenter padding0">
											<i class="fa fa-clock-o" aria-hidden="true"></i>
										</div>
										<div class="col-md-3 col-sm-3 padding0">	
											<div class="contact-border">
												<div class="themetext"><?php echo $time1;?></div>
											<div class="data"><?php echo $time2;?></div>
											</div>
											<div class="clearfix"></div>
										</div>
								<?php } ?>
							<div class="clearfix"></div>
							</div>
							<div class="clearfix"></div>	
						</div><!--header-box-->
					</div>
					<div class="clearfix"></div>
				</div>				
				<div class="nav-upper">
					<div class="container">
						<div class="site-navigation col-md-10 col-sm-10 col-xs-10 padding0">
                        <div class="hamburger-menus">
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                        <nav class="navigation ht-main-navigation" id="ht-site-navigation">
                            <div class="overlaybg"></div><!--  /.overlaybg -->
                            <!-- Main Menu -->
                            <div class="menu-wrapper">
                                <div class="menu-content">
                                    <?php
                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
                                            wp_nav_menu ( array(
                                                'menu_class' => 'mainmenu ht-clearfix',
                                                'container'=> 'ul ',
                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
                                                'theme_location' => 'primary',  
                                            )); 
                                        } else {
                                            wp_nav_menu ( array(
                                                'menu_class' => 'mainmenu ht-clearfix',
                                                'container'=> 'ul',
                                                'theme_location' => 'primary',  
                                            )); 
                                        }
                                    ?>
                                </div> <!-- /.hours-content-->
							<div class="clearfix"></div>
                            </div><!-- /.menu-wrapper --> 
                            <div class="mobi">

									<div class="total-count  pull-right">
										<?php if(function_exists ('wc_get_cart_url')){?>				
										<a href="<?php echo wc_get_cart_url();?>" class="button wc-forward"><img src="<?php echo get_template_directory_uri(); ?>/images/cart.png"  alt="">
											<div class="count"><?php global $woocommerce; ?><?php echo WC()->cart->get_cart_contents_count(); ?></div>
										</a>
										<!-- <a href="<?php echo get_permalink(120); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/wishlists.png"  alt=""></a> -->
										<?php }?>
									</div>
								</div>
                        </nav>
                        <div class="clearfix"></div>
                    </div><!--  /.site-navigation -->
							<div class="col-md-1 col-sm-1 col-xs-1 top-form ">
								<button type="button" id="formButton" ></button>		
								<form id="form1">					
									<?php get_search_form(); ?>
								</form>
							</div>
							<div class="col-md-1 col-sm-1 col-xs-1 header-icons text-center">
								<div class="mobi1">
									
									<div class="total-count  pull-right">
										<?php if(function_exists ('wc_get_cart_url')){?>				
										<a href="<?php echo wc_get_cart_url();?>" class="button wc-forward"><img src="<?php echo get_template_directory_uri(); ?>/images/cart.png"  alt="">
											<div class="count"><?php global $woocommerce; ?><?php echo WC()->cart->get_cart_contents_count(); ?></div>
										</a>
										<!-- <a href="<?php echo get_permalink(120); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/wishlists.png"  alt=""></a> -->
										<?php }?>
									</div>
								</div>
							</div>
						<div class="clearfix"></div>
					</div>
				</div>
				<div class="clearfix"></div>
			</header><!-- #masthead -->
	</div>
