<?php

$wp_customize->add_panel(
	'lz_fitness_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'lz-fitness-premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'lz-fitness-premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

$wp_customize->add_setting( 'luzuk_sitetitle_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'luzuk_sitetitle_display', array( 'label' => 'Site Title Display', 'section' => 'title_tagline', 'settings' => 'luzuk_sitetitle_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Site Title', 'hide' => 'Hide Site Title', ), ) ); 
$wp_customize->add_setting( 'luzuk_tagline_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'luzuk_tagline_display', array( 'label' => 'Tagline Display', 'section' => 'title_tagline', 'settings' => 'luzuk_tagline_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Tagline', 'hide' => 'Hide Tagline', ), ) ); 


//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'lz-fitness-premium'),
	'panel' => 'lz_fitness_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'lz_fitness_template_color', 'colors', 'Theme Primary Color', '#f4b601');

// Set heading/title colour
//addColorPalatOption($wp_customize, 'lz_fitness_title_color', 'colors', 'Heading Text Color', '#fe5722');

//theme Secondary color
//addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#f15a24');

//Set header menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headermenu_color', 'colors', 'Header Menu Color', '#fff');
//Set header sub menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenu_color', 'colors', 'Header Sub Menu Color', '#fff');
//Set header sub menu Background colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenubg_color', 'colors', 'Header Sub Menu Background Color', '#272727');

//theme Footer Background Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_bg_color', 'colors', 'Footer Background Color', '#2e2e2e');
// //theme Footer Background Color
// addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrightbg_color', 'colors', 'Copyright Footer Background Color', '#2a2a2a');
//Inner page title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');

//HEADER SETTINGS
$wp_customize->add_section(
	'lz_fitness_header_settings',
	array(
		'title' => __( 'Header Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);


	//ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
	'lz_fitness_sticky_header_enable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);

$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_sticky_header_enable',
		array(
			'settings'		=> 'lz_fitness_sticky_header_enable',
			'section'		=> 'lz_fitness_header_settings',
			'label'			=> __( 'Sticky Header', 'lz-fitness-premium' ),
			'on_off_label' 	=> array(
				'on' => __( 'Enable', 'lz-fitness-premium' ),
				'off' => __( 'Disable', 'lz-fitness-premium' )
			)	
		)
	)
);
//top header
$wp_customize->add_setting(
	'lz_fitness_headermain_socialtag',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Follow Us:', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_socialtag',
	array(
		'settings'      => 'lz_fitness_headermain_socialtag',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Social Tagline', 'lz-fitness-premium' )
	)
);

$sectionHeader = 'lz_fitness_header_settings';
// Adding the Label
lzCustomLable($wp_customize, 'lz_fitness_reservation_lblImgTxt', $sectionHeader, 'Social media icons');
//ADD TEXT BOX FOR FORM SHORTCODE
// lzAddElement($wp_customize, 'lz_fitness_header_fb', $sectionHeader, 'text', $label = "Facebook", 'lz_fitness_sanitize_text', 'http://Facbook.com');
// lzAddElement($wp_customize, 'lz_fitness_header_tw', $sectionHeader, 'text', $label = "Twitter", 'lz_fitness_sanitize_text', 'http://twitter.com');
// lzAddElement($wp_customize, 'lz_fitness_header_it', $sectionHeader, 'text', $label = "GooglePlus", 'lz_fitness_sanitize_text', 'https://plus.google.com');
// lzAddElement($wp_customize, 'lz_fitness_header_in', $sectionHeader, 'text', $label = "LinedIn", 'lz_fitness_sanitize_text', 'http://Linkedin.com');
// lzAddElement($wp_customize, 'lz_fitness_header_insta', $sectionHeader, 'text', $label = "Instagram", 'lz_fitness_sanitize_text', 'http://Instragram.com');
// lzAddElement($wp_customize, 'lz_fitness_header_yt', $sectionHeader, 'text', $label = "Youtube", 'lz_fitness_sanitize_text', 'https://www.youtube.com');

// FACEBOOK 
$wp_customize->add_setting('lz_fitness_header_fb',	array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_fb',
	array(
		'settings'      => 'lz_fitness_header_fb',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Facebook Url', 'lz-fitness-premium' )
	)
);
// TWITTER
$wp_customize->add_setting('lz_fitness_header_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_tw',
	array(
		'settings'      => 'lz_fitness_header_tw',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Twitter Url', 'lz-fitness-premium' )
	)
);
// GOOGLE PLUS
$wp_customize->add_setting('lz_fitness_header_it', array('default' => 'https://plus.google.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_it',
	array(
		'settings'      => 'lz_fitness_header_it',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Google Plus Url', 'lz-fitness-premium' )
	)
);
// LINKED IN
$wp_customize->add_setting('lz_fitness_header_in',array('default'=> 'https://linkedin.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_in',
	array(
		'settings'      => 'lz_fitness_header_in',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Linkedin Url', 'lz-fitness-premium' )
	)
);
// Instagram
$wp_customize->add_setting('lz_fitness_header_insta', array('default' => 'https://www.instagram.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_insta',
	array(
		'settings'      => 'lz_fitness_header_insta',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Instagram', 'gurukul' )
	)
); 

// Youtube IN
$wp_customize->add_setting('lz_fitness_header_yt',array('default'=> 'https://www.youtube.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_yt',
	array(
		'settings'      => 'lz_fitness_header_yt',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Youtube Url', 'gurukul' )
	)
);



//medal header
$wp_customize->add_setting(
	'lz_fitness_headermain_phone',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '+123-345-6789', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_phone',
	array(
		'settings'      => 'lz_fitness_headermain_phone',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Phone Number', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'lz_fitness_headermain_email',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'info@yourwebsite.com', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_email',
	array(
		'settings'      => 'lz_fitness_headermain_email',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Email Address', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'lz_fitness_headermain_address1',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '234 Wales Street', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_address1',
	array(
		'settings'      => 'lz_fitness_headermain_address1',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Address Line 1', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'lz_fitness_headermain_address2',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Syd, Australia 60001', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_address2',
	array(
		'settings'      => 'lz_fitness_headermain_address2',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Address Line 2', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'lz_fitness_headermain_time1',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Mon-Sat 8.00-18.00', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_time1',
	array(
		'settings'      => 'lz_fitness_headermain_time1',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Day Time', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'lz_fitness_headermain_time2',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Sunday CLOSED', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_time2',
	array(
		'settings'      => 'lz_fitness_headermain_time2',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Off Time', 'lz-fitness-premium' )
	)
);

 // header background color
 addColorPalatOption($wp_customize, 'lz_fitness_header_TopHeaderbackgroundColor', 'lz_fitness_header_settings', 'Top Header Background Color', '#303030'); 
addColorPalatOption($wp_customize, 'lz_fitness_header_MedalHeaderbackgroundColor', 'lz_fitness_header_settings', 'Medial Header Background color', '#fff'); 
addColorPalatOption($wp_customize, 'lz_fitness_header_NavHeaderbackgroundColor', 'lz_fitness_header_settings', 'Main Header Background color', '#181818'); 


 //header main tagline color   
addColorPalatOption($wp_customize, 'lz_fitness_header_taglineColor', 'lz_fitness_header_settings', ' Header main tagline color', '#fff'); 

 //header social tagline color   
addColorPalatOption($wp_customize, 'lz_fitness_header_socialtaglineColor', 'lz_fitness_header_settings', ' Header social tagline color', '#fff'); 
 //header social color   
addColorPalatOption($wp_customize, 'lz_fitness_header_socialColor', 'lz_fitness_header_settings', ' Header social color', '#fff'); 
 //header social color   
addColorPalatOption($wp_customize, 'lz_fitness_header_socialColor', 'lz_fitness_header_settings', ' Header social color', '#fff'); 
 //header icon color   
addColorPalatOption($wp_customize, 'lz_fitness_header_iconColor', 'lz_fitness_header_settings', ' Header icons color', '#8e8e8e'); 
//header icon color   
addColorPalatOption($wp_customize, 'lz_fitness_header_iconColor', 'lz_fitness_header_settings', ' Header icons color', '#8e8e8e'); 
//header phone address day time color   
addColorPalatOption($wp_customize, 'lz_fitness_header_titleColor', 'lz_fitness_header_settings', ' header address and day time color', '#000'); 

//header address data off time color   
addColorPalatOption($wp_customize, 'lz_fitness_header_dataColor', 'lz_fitness_header_settings', ' header email, address data and off time color', '#000'); 

//header email color   
addColorPalatOption($wp_customize, 'lz_fitness_header_emailColor', 'lz_fitness_header_settings', ' header phone & email color', '#000'); 

addColorPalatOption($wp_customize, 'lz_fitness_header_sicnbgClr', 'lz_fitness_header_settings', ' header search Icon background color', '#f4b601');

addColorPalatOption($wp_customize, 'lz_fitness_header_sicnClr', 'lz_fitness_header_settings', ' header search Icon color', '#fff');

addColorPalatOption($wp_customize, 'header_serchbtnbx', 'header_settings', 'Search Box Background Color', '#f4b601');

addColorPalatOption($wp_customize, 'header_serchbtntxtbx', 'header_settings', 'Search Text Box Background Color', '#fff');

addColorPalatOption($wp_customize, 'header_serchbtntxtbxbrd', 'header_settings', 'Search Text Box Border Color', '#fff');

addColorPalatOption($wp_customize, 'header_serchbtntxt', 'header_settings', 'Search Box Text Color', '#000');

addColorPalatOption($wp_customize, 'header_serchbtnbxbtnbg', 'header_settings', 'Search Box Button Background Color', '#000');

addColorPalatOption($wp_customize, 'header_serchbtnbxbtntxt', 'header_settings', 'Search Box Button Text Color', '#fff');

//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'lz_fitness_footer_copyright_settings',
	array(
		'title' => __( 'Footer Copyright Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

$wp_customize->add_setting(
	'lz_fitness_footer_copyrighttext',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Copyright © 2018 urja-solar-energy-pro. All Rights Reserved', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_footer_copyrighttext',
	array(
		'settings'      => 'lz_fitness_footer_copyrighttext',
		'section'       => 'lz_fitness_footer_copyright_settings',
		'type'          => 'text',
		'label'         => __( 'Footer Copyright Text', 'lz-fitness-premium' )
	)
);


//theme Footer Text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrighttext_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Text Color', '#aaa');

//theme Footer Background Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrightbg_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Background Color', '#2a2a2a');