<?php
/**
 * Createing an about us pannel for customizer
 */

// START ABOUT SECTION 
    $wp_customize->add_section(
        'lz_fitness_premium_aboutus_section',
        array(
            'title' => __( 'About Us Section', 'lz-fitness-premium' ),
            'panel' => 'lz_fitness_premium_home_panel'
        )
    );
    // ENABLE/DISABLE FEATURED SECTION
    $wp_customize->add_setting(
        'lz_fitness_premium_aboutus_section_disable',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Switch_Control(
            $wp_customize,
            'lz_fitness_premium_aboutus_section_disable',
            array(
                'settings'      => 'lz_fitness_premium_aboutus_section_disable',
                'section'       => 'lz_fitness_premium_aboutus_section',
                'label'         => __( 'Disable Section', 'lz-fitness-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'lz-fitness-premium' ),
                    'off' => __( 'No', 'lz-fitness-premium' )
                ),
            )
        )
    );

    backgroundManager($wp_customize, 'about', 'lz_fitness_premium_aboutus_section', $color='#ffffff', get_template_directory_uri().'/images/default-gray.png', 'img');


    $wp_customize->add_setting(
        'lz_fitness_aboutus_title_heading',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'lz_fitness_aboutus_title_heading',
            array(
                'settings'      => 'lz_fitness_aboutus_title_heading',
                'section'       => 'lz_fitness_premium_aboutus_section',
                'label'         => __( 'ABOUT Title & Text', 'lz-fitness-premium' ),
            )
        )
    );    
    $wp_customize->add_setting(
        'lz_fitness_aboutus_title',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default'           => __( 'About us', 'lz-fitness-premium' )
        )
    );
    $wp_customize->add_control(
        'lz_fitness_aboutus_title',
        array(
            'settings'      => 'lz_fitness_aboutus_title',
            'section'       => 'lz_fitness_premium_aboutus_section',
            'type'          => 'text',
            'label'         => __( 'Title for section', 'lz-fitness-premium' )
        )
    );
    // lzAddElement($wp_customize, 'lz_fitness_aboutus_subTitle', 'lz_fitness_premium_aboutus_section', 'textarea', $label="Sub Title", 'lz_fitness_sanitize_text', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit, <span>nonummy nibh euismod tincidunt </span>ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci Lorem ipsum dolor sit amet.');

    $wp_customize->add_setting(
        'lz_fitness_about_image_heading',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'lz_fitness_about_image_heading',
            array(
                'settings'      => 'lz_fitness_about_image_heading',
                'section'       => 'lz_fitness_premium_aboutus_section',
                'label'         => __( 'Left Image', 'lz-fitness-premium' ),
            )
        )
    );
    $wp_customize->add_setting(
        'lz_fitness_about_image',
        array(
            'sanitize_callback' => 'esc_url_raw'
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'lz_fitness_about_image',
            array(
                'section' => 'lz_fitness_premium_aboutus_section',
                'settings' => 'lz_fitness_about_image',
                'description' => __('Recommended Image Size: 500X600px', 'lz-fitness-premium')
            )
        )
    );

    $wp_customize->add_setting(
        'lz_fitness_aboutus_subText',
        array(
            'sanitize_callback'=>'lz_fitness_sanitize_text',
            'default'=> __('Lorem ipsum dolor sit amet, consectetuer adipiscing elit, <span>nonummy nibh euismod tincidunt </span>ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci Lorem ipsum dolor sit amet.Lorem ipsum dolor sit amet, consectetuer adipiscing elit', 'lz-fitness-premium')
        )
    );
    $wp_customize->add_control(
        'lz_fitness_aboutus_subText',
        array(
            'settings' =>'lz_fitness_aboutus_subText',
            'section' => 'lz_fitness_premium_aboutus_section',
            'type'=> 'textarea',
            'label'=> __('Content for the section', 'lz-fitness-premium')
        )
    );


    $wp_customize->add_setting(
        'lz_fitness_aboutus_text',
        array(
            'sanitize_callback'=>'lz_fitness_sanitize_text',
            'default'=> __('Lorem ipsum dolor sit amet, consectetuer adipiscing elit, nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci Lorem ipsum dolor sit amet.Lorem ipsum dolor sit amet, consectetuer adipiscing elit, nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. <span>Ut wisi enim ad minim veniam</span>, quis nostrud exerci Lorem ipsum dolor sit amet.Lorem ipsum dolor sit amet, consectetuer adipiscing elit, nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci Lorem ipsum dolor sit amet.Lorem ipsum dolor sit amet, consectetuer adipiscing elit, nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci Lorem ipsum dolor sit amet.Lorem ipsum dolor sit amet, consectetuer adipiscing elit, nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat.', 'lz-fitness-premium')
        )
    );
    $wp_customize->add_control(
        'lz_fitness_aboutus_text',
        array(
            'settings' =>'lz_fitness_aboutus_text',
            'section' => 'lz_fitness_premium_aboutus_section',
            'type'=> 'textarea',
            'label'=> __('Content for the section', 'lz-fitness-premium')
        )
    );
    $wp_customize->add_setting(
        'lz_fitness_aboutus_page',
        array(
            'sanitize_callback'=> 'absint',
            'default' => __('About Page Readmore Link', 'lz-fitness-premium')
        )
    );
    $wp_customize->add_control(
        'lz_fitness_aboutus_page',
        array(
            'settings'=> 'lz_fitness_aboutus_page',
            'section' => 'lz_fitness_premium_aboutus_section',
            'type'=>'select',
            'label'=>__('Link to About us page', 'lz-fitness-premium'),
            'choices'=>$lz_fitness_page_choice
        )
    );

    // Heading color
    addColorPalatOption($wp_customize, 'lz_fitness_aboutus_page_HeadingColor', 'lz_fitness_premium_aboutus_section', 'Heading color', '#333333');
    // Text color
    addColorPalatOption($wp_customize, 'lz_fitness_aboutus_page_TextColor', 'lz_fitness_premium_aboutus_section', 'Text color', '#333333');

    // END ABOUT SECTION 