<?php

// START Gym Timing & Address SECTION
    $wp_customize->add_section(
        'lz_fitness_time_n_address',
        array(
            'title'=> __('Timing & Address', 'lz-fitness-premium'),
            'panel'=> 'lz_fitness_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'lz_fitness_time_n_address_disabled',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default' => 'off'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Switch_Control(
            $wp_customize,
            'lz_fitness_time_n_address_disabled',
            array(
                'settings'=>'lz_fitness_time_n_address_disabled',
                'section'=>'lz_fitness_time_n_address',
                'label'=>__('Disable Section', 'lz-fitness-premium'),
                'on_off_label'=> array(
                    'on'=> __('Yes', 'lz-fitness-premium'),
                    'off'=> __('No', 'lz-fitness-premium')
                )
            )
        )
    );

    backgroundManager($wp_customize, 'gym', 'lz_fitness_time_n_address', $color='#fff');

    $wp_customize->add_setting(
    	'lz_fitness_time_n_address_into', 
    	array(
    		'sanitize_callback'=>'lz_fitness_sanitize_text'
    	)
    );
    $wp_customize->add_control(
    	new lz_fitness_Customize_Heading(
    		$wp_customize, 
    		'lz_fitness_time_n_address_into', 
    		array(
    			'settings'=>'lz_fitness_time_n_address_into', 
    			'section'=>'lz_fitness_time_n_address', 
    			'label'=>__('Section Title & Sub Title', 'lz-fitness-premium')
    		)
    	)
    );
    $wp_customize->add_setting(
    	'lz_fitness_time_n_address_title', 
    	array(
    		'sanitize_callback' => 'lz_fitness_sanitize_text', 
    		'default'=> __('Gym Timing & Address', 'lz-fitness-premium')
    	)
    );
    $wp_customize->add_control(
    	'lz_fitness_time_n_address_title', 
    	array(
    		'settings'=>'lz_fitness_time_n_address_title', 
    		'section'=>'lz_fitness_time_n_address', 
    		'type'=>'text', 
    		'label'=> __('Title', 'lz-fitness-premium')
    	)
    );
    $wp_customize->add_setting(
    	'lz_fitness_time_n_address_subtitle',
    	array(
    		'sanitize_callback' => 'lz_fitness_sanitize_text', 
    		'default'=> __('Here goes the short description for the section', 'lz-fitness-premium')
    	)
    );
    $wp_customize->add_control(
    	'lz_fitness_time_n_address_subtitle',
    	array(
    		'settings'=>'lz_fitness_time_n_address_subtitle', 
    		'section'=>'lz_fitness_time_n_address', 
    		'type'=>'textarea', 
    		'label'=> __('Sub Title', 'lz-fitness-premium')
    	)
    );

// Heading color
addColorPalatOption($wp_customize, 'lz_fitness_gym_HeadingColor', 'lz_fitness_time_n_address', 'Heading color', $headingColor);
// Text color
addColorPalatOption($wp_customize, 'lz_fitness_gym_TextColor', 'lz_fitness_time_n_address', 'Text color', '#333333');

    $wp_customize->add_setting(
    	'lz_fitness_time_n_address_time_section', 
    	array(
    		'sanitize_callback'=> 'lz_fitness_sanitize_text',
			// 'default'           => __( 'Gym Timeings', 'lz-fitness-premium' )
    	)
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'lz_fitness_time_n_address_time_section', 
            array(
            	'settings'=>'lz_fitness_time_n_address_time_section', 
            	'section'=>'lz_fitness_time_n_address', 
            	'label'=>__('Timing', 'lz-fitness-premium')
            )
        )
    );
    // gym time title
    $wp_customize->add_setting(
        'lz_fitness_time_n_address_time_title', 
        array(
            'sanitize_callback'=> 'lz_fitness_sanitize_text',
            'default'           => __( 'Gym Timings', 'lz-fitness-premium' )
        )
    );
    $wp_customize->add_control(
        'lz_fitness_time_n_address_time_title', 
        array(
            'settings'=>'lz_fitness_time_n_address_time_title', 
            'section'=>'lz_fitness_time_n_address', 
            'type'=>'text', 
            'label'=>__('Timing Title', 'lz-fitness-premium')
        )
    );
    $days = array('Monday', 'Tuesday','Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday');
    //Gym time
    foreach ($days as $i => $value) {
        $wp_customize->add_setting(
        	'lz_fitness_time_n_address_time_'.($i+1), 
        	array(
        		'sanitize_callback' => 'lz_fitness_sanitize_text', 
        		'default' => __( '5:00 AM - 12:00 PM', 'lz-fitness-premium' )
        	)
        );
        $wp_customize->add_control(
        	'lz_fitness_time_n_address_time_'.($i+1), 
        	array(
        		'settings'=>'lz_fitness_time_n_address_time_'.($i+1), 
        		'section'=>'lz_fitness_time_n_address', 
        		'type'=>'text', 
        		'label'=> __($value, 'lz-fitness-premium')
        	)
        );
    }
    