<?php
/**
 * Customiser section for services
 **/
// Start services section 
$wp_customize->add_section(
    'lz_fitness_services_section',
    array(
        'title' => __( 'Services Section', 'lz-fitness-premium' ),
        'panel' => 'lz_fitness_premium_home_panel'
    )
);
// ENABLE/DISABLE services SECTION
$wp_customize->add_setting(
    'lz_fitness_service_section_disable',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
    )
);
$wp_customize->add_control(
    new lz_fitness_Switch_Control(
        $wp_customize,
        'lz_fitness_service_section_disable',
        array(
            'settings'      => 'lz_fitness_service_section_disable',
            'section'       => 'lz_fitness_services_section',
            'label'         => __( 'Disable Section', 'lz-fitness-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'lz-fitness-premium' ),
                'off' => __( 'No', 'lz-fitness-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'services', 'lz_fitness_services_section', $color='#ffffff', get_template_directory_uri().'/images/default-gray.png', 'img');

$wp_customize->add_setting(
    'lz_fitness_service_title_sub_title_heading',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text'
    )
);
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'lz_fitness_services_title_sub_title_heading',
        array(
            'settings'      => 'lz_fitness_services_title_sub_title_heading',
            'section'       => 'lz_fitness_services_section',
            'label'         => __( 'Section Title', 'lz-fitness-premium' ),
        )
    )
);    
$wp_customize->add_setting(
    'lz_fitness_services_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'Our Services', 'lz-fitness-premium' )
    )
);
$wp_customize->add_control(
    'lz_fitness_services_title',
    array(
        'settings'      => 'lz_fitness_services_title',
        'section'       => 'lz_fitness_services_section',
        'type'          => 'text',
        'label'         => __( 'Title', 'lz-fitness-premium' )
    )
);

$wp_customize->add_setting('lz_fitness_services_npp_heading',array('sanitize_callback' => 'lz_fitness_sanitize_text'));
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'lz_fitness_services_npp_heading',
        array(
            'settings'      => 'lz_fitness_services_npp_heading',
            'section'       => 'lz_fitness_services_section',
            'label'         => __( 'Number Of services Plans', 'lz-fitness-premium' ),
        )
    )
);    
$wp_customize->add_setting('lz_fitness_services_npp_count',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => 2));
$wp_customize->add_control(
    'lz_fitness_services_npp_count',
    array(
        'settings'      => 'lz_fitness_services_npp_count',
        'section'       => 'lz_fitness_services_section',
        'type'          => 'select',
        'label'         => __( 'Number of plan to show', 'lz-fitness-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

$ServicesSingleChoice[] = 'Select';
// services PAGES
for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'lz_fitness_services_heading'.$i,
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'lz_fitness_services_heading'.$i,
            array(
                'settings'      => 'lz_fitness_services_heading'.$i,
                'section'       => 'lz_fitness_services_section',
                'label'         => __( 'Services Member ', 'gurukul' ).$i,
            )
        )
    );
    if(is_array($ServicesSingleChoice)){
        $wp_customize->add_setting(
            'lz_fitness_services_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'lz_fitness_services_page'.$i,
            array(
                'settings'      => 'lz_fitness_services_page'.$i,
                'section'       => 'lz_fitness_services_section',
                'type'=> 'select',
                'label'         => __( 'Select A Service', 'gurukul' ),
                'choices' => $ServicesSingleChoice,
            )
        );

        
    }else{
        $wp_customize->add_setting('lz_fitness_services_section_lbl'.$i, array('sanitize_callback'=>'lz_fitness_sanitize_text'));
        $wp_customize->add_control(
            new lz_fitness_Info_Text( 
                $wp_customize,
                'lz_fitness_services_section_lbl'.$i,
                array(
                    'settings'      => 'lz_fitness_services_section_lbl'.$i,
                    'section'       => 'lz_fitness_services_section',
                    'label'         => __( 'Note:', 'gurukul' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the service.</strong> <br/>Please add the service from "service menu" and then select service to show information.', 'gurukul' ),
                )
            )
        );
    }
}

$wp_customize->add_setting(
    'ser_button1',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'Read More', 'lz_fitness-premium' )
    )
);
$wp_customize->add_control(
    'ser_button1',
    array(
        'settings'      => 'ser_button1',
        'section'       => 'lz_fitness_services_section',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'lz_fitness-premium' )
    )
);


// End Feature section 
  // Heading color
    addColorPalatOption($wp_customize, 'lz_services_HeadingColor', 'lz_fitness_services_section', 'Heading color ', '#161616');
    // Title color
    addColorPalatOption($wp_customize, 'lz_services_TitleColor', 'lz_fitness_services_section', 'Title color ', '#161616');
     // Text color
    addColorPalatOption($wp_customize, 'lz_services_TextColor', 'lz_fitness_services_section', 'Text color', '#383838');
    // Button text color
    addColorPalatOption($wp_customize, 'lz_services_btntextColor', 'lz_fitness_services_section', 'Button Text color', '#141414');
    
