<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css?family=Roboto:700" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Poppins:400,500,600" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Dancing+Script" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Open+Sans:400,600,700&display=swap" rel="stylesheet">
	<!-- <link rel="stylesheet" href="<?php //echo get_template_directory_uri(); ?>/css/owl.carousel.min.css" />
	<link rel="stylesheet" href="<?php //echo get_template_directory_uri(); ?>/css/owl.theme.default.min.css" />
	<link rel="stylesheet" href="<?php //echo get_template_directory_uri(); ?>/css/style-ltr.css" /> -->
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>

<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'utsavplanner' ); ?></a>

		<header id="ht-masthead" class="ht-site-header">
							
			<div class="main-header">
				
				<div class="overlap-header">	
					
					<div class="lower-header">	
						<div class="row row-eq-height"> 
							<div class="header-left col-md-3 col-sm-4 col-xs-8">
								<div class="inside-full-height">

									<?php 
										if( get_theme_mod('pages_logoTmargin',true) ) {
							                $pages_logoTmargin = 'margin-top:'.esc_attr(get_theme_mod('pages_logoTmargin')).';';
							            }
							            if( get_theme_mod('pages_logoBmargin',true) ) {
							                $pages_logoBmargin = 'margin-bottom:'.esc_attr(get_theme_mod('pages_logoBmargin')).';';
							            }
							            if( get_theme_mod('pages_logoLmargin',true) ) {
							                $pages_logoLmargin = 'margin-left:'.esc_attr(get_theme_mod('pages_logoLmargin')).';';
							            }
							            if( get_theme_mod('pages_logoRmargin',true) ) {
							                $pages_logoRmargin = 'margin-right:'.esc_attr(get_theme_mod('pages_logoRmargin')).';';
							            }
				 					?>
									<div class="col-md-offset-3 logobox"  style="<?php echo esc_attr($pages_logoTmargin); ?>" "<?php echo esc_attr($pages_logoBmargin); ?>" "<?php echo esc_attr($pages_logoLmargin); ?>" "<?php echo esc_attr($pages_logoRmargin); ?>">
										<?php 
										if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
											the_custom_logo();
									else : 
										if ( is_front_page() ) : ?>
											<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
											<?php else : ?>
												<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
											<?php endif; ?>
											<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
										<?php endif; ?>
										<!-- .site-branding -->
									</div>
								</div>
								<div class="clearfix"></div>
							</div>
							<div class="cilppath col-md-1 padding0 ">

							</div>
							<div class="col-md-8 col-sm-12 col-xs-12 padding0 socialalign">

								<div class="col-md-9 inside-full-height header-about-theme">
									<nav id="ht-site-navigation" class="ht-main-navigation">
										<div class="toggle-bar"><span><i class="fa fa-bars" aria-hidden="true"></i></span></div>
										<?php 
										wp_nav_menu( array( 
											'theme_location' => 'primary', 
											'container_class' => 'ht-menu clearfix' ,
											'menu_class' => 'ht-clearfix',
											'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
										) ); 
										?>
									</nav><!-- #ht-site-navigation -->
									
									<div class="clearfix"></div>
									
								</div>
								<?php if( get_theme_mod('headerrightbtn_number_display','show' ) == 'show') :
									?>
									
									<div class="col-md-3 header-right-box">
								<?php
								$phone = get_theme_mod('lz_fitness_headermain_phone', '+999 999 9999');
								?>
										<?php if($phone){ ?>
											<div class="telnumber"><?php echo ($phone);  ?></div>
										<?php } ?>
										<!-- <?php
										$headerrightExt = get_theme_mod('lz_fitness_headermain_headerrightExt', 'CALL NOW'); 
										$headerrightExtlink = get_theme_mod('lz_fitness_header_headerrightExtlink', '#');
										?>
									<?php if($headerrightExt){ ?>
										<?php if(!empty($headerrightExtlink)){ ?>
											<a href="<?php echo $headerrightExtlink ?>" title=""><?php echo($headerrightExt);  ?></a>
										<?php }?> -->
										<?php } ?>
									</div>
									
								<?php endif ?>
							</div>
							
					<!-- <div class="sitenav">
					<div class="col-md-2 col-sm-12 col-xs-12 padding0">
								<span class="search-icon">
							<i class="fa fa-search" aria-hidden="true"></i>
					    </span>	
					  
					</div>
						<div class="clearfix"></div>
						<div class="search-bar"> 			
								<?php //get_search_form(); ?>   
						</div>  .search-bar
					<div class="clearfix"></div>
				</div> -->
				<div class="clearfix"></div>
				
			</div>	
			<div class="clearfix"></div>
		</div>		
		<div class="clearfix"></div>
	</div>
	
</header><!-- #masthead -->
<script>
	jQuery(document).ready(function($){
		$('.fa-search').on('click', function() {
			$('.search-bar').slideToggle();
		});
	});
</script>
</div>
