<?php

$wp_customize->add_panel(
	'lz_fitness_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'Luzuk Premium')
	)
);
//STATIC FRONT PAGE 
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'Luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
) );


//HEADER LOGO MARGIN SETTINGS
$wp_customize->add_section(
	'lz_fitness_headerlogo_settings',
	array(
		'title' => __( 'Header Logo Margin Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_headerlogo_margin', 'lz_fitness_headerlogo_settings', ' Site Header Logo Margin:');


$wp_customize->add_setting(
	'pages_logoTmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '15px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoTmargin',
	array(
		'settings'      => 'pages_logoTmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Top Margin', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoBmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '15px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoBmargin',
	array(
		'settings'      => 'pages_logoBmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Bottom Margin', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoLmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoLmargin',
	array(
		'settings'      => 'pages_logoLmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Left Margin', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoRmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoRmargin',
	array(
		'settings'      => 'pages_logoRmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Right Margin', 'lz-fitness-premium' )
	)
);

//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//HEADER LOGO MARGIN SETTINGS
$wp_customize->add_section(
	'lz_fitness_headerlogo_settings',
	array(
		'title' => __( 'Header Logo Margin Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_headerlogo_margin', 'lz_fitness_headerlogo_settings', ' Site Header Logo Margin:');

$wp_customize->add_setting(
	'pages_logoTmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoTmargin',
	array(
		'settings'      => 'pages_logoTmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Top Margin', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoBmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '10px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoBmargin',
	array(
		'settings'      => 'pages_logoBmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Bottom Margin', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoLmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoLmargin',
	array(
		'settings'      => 'pages_logoLmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Left Margin', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoRmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoRmargin',
	array(
		'settings'      => 'pages_logoRmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Right Margin', 'lz-fitness-premium' )
	)
);

//Header IMAGE
// $wp_customize->add_section( 'header_image', array(
// 	'title' => __( 'Header Image', 'Luzuk Premium' ),
// 	'panel' => 'lz_fitness_general_panel',
// ) );

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'Luzuk Premium'),
	'panel' => 'lz_fitness_general_panel',
) );





//theme primary color
addColorPalatOption($wp_customize, 'lz_fitness_template_color', 'colors', 'Theme Primary Color', '#f67104');

// // Set heading/title colour
// addColorPalatOption($wp_customize, 'lz_fitness_title_color', 'colors', 'Heading Text Color', '#fe5722');

// //theme Secondary color
// addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#f15a24');

//Inner page title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');
//Inner page background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_bgcolor', 'colors', 'Inner page backgroundcolor', '#f67104');

addColorPalatOption($wp_customize, 'lz_fitness_innerpageheadingh1', 'colors', 'Inner page h1 color', '#000');
addColorPalatOption($wp_customize, 'lz_fitness_innerpageheadingh2', 'colors', 'Inner page h2 color', '#000');

addColorPalatOption($wp_customize, 'lz_fitness_innerpageheadingh3', 'colors', 'Inner page h3 color', '#000');
addColorPalatOption($wp_customize, 'lz_fitness_innerpageheadingh4', 'colors', 'Inner page h4 color', '#000');
addColorPalatOption($wp_customize, 'lz_fitness_innerpageheadingh5', 'colors', 'Inner page h5 color', '#000');
addColorPalatOption($wp_customize, 'lz_fitness_innerpageheadingh6', 'colors', 'Inner page h6 color', '#000');

addColorPalatOption($wp_customize, 'lz_fitness_innerpagetextcolors', 'colors', 'Inner page Text color', '#333');
addColorPalatOption($wp_customize, 'lz_fitness_innerpagetextullicolors', 'colors', 'Inner page Text ul li color', '#333');
addColorPalatOption($wp_customize, 'lz_fitness_innerpagetextollicolors', 'colors', 'Inner page Text ol li color', '#333');
addColorPalatOption($wp_customize, 'lz_fitness_innerpagetextspancolors', 'colors', 'Inner page Span Text color', '#f07100');




$wp_customize->add_section(
	'lz_fitness_innerpageshortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);







// lzCustomLable($wp_customize, 'lz_fitness_recentworkpageinnerclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Recent Work Shortcode Page Colors:');
// addColorPalatOption($wp_customize, 'lz_fitness_recentworkinnerpageimgbrsColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Image Border color', '#f67004');
// addColorPalatOption($wp_customize, 'lz_fitness_recentworkinnerpageimgbrshvrColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Image Hover Border color', '#ffffff');

// addColorPalatOption($wp_customize, 'lz_fitness_recentworkinnerpageimgiconhvrColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Image Hover Icon color', '#ffffff');







// Services page colors
lzCustomLable($wp_customize, 'lz_fitness_servicespageinnerclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Services Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'lz_fitness_imageoverlayColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select image overlay color', '#000');

addColorPalatOption($wp_customize, 'lz_fitness_servicesTitleColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Title color', '#000');

addColorPalatOption($wp_customize, 'lz_fitness_servicestextbgColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Text Background color', '#f3f3f3');

addColorPalatOption($wp_customize, 'lz_fitness_servicestextColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Text color', '#000');

addColorPalatOption($wp_customize, 'lz_fitness_servicesButtonbgColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Button Background color', '#ff7100');

addColorPalatOption($wp_customize, 'lz_fitness_servicesButtoniconColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Button icon color', '#ffffff');


addColorPalatOption($wp_customize, 'lz_fitness_servicesButtonhovbgColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Button Hover Background color', '#666');

addColorPalatOption($wp_customize, 'lz_fitness_servicesButtonhovtextbgColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Button Hover Text Background color', '#ffffff');




// Event page colors
lzCustomLable($wp_customize, 'lz_fitness_eventpageinnerclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Event Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'lz_fitness_eventboxborColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Box Border color', '#f67004');
addColorPalatOption($wp_customize, 'lz_fitness_eventboxTitleborColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Title color', '#f67004');
addColorPalatOption($wp_customize, 'lz_fitness_eventboxtextColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Text color', '#000');
addColorPalatOption($wp_customize, 'lz_fitness_eventboxbuttexColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Button Text color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_eventboxbutBgColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Button Background color', '#f67004');
addColorPalatOption($wp_customize, 'lz_fitness_eventboxbuthovtextColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Button Hover Text color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_eventboxbutHovBgColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Button Hover Background color', '#000');
addColorPalatOption($wp_customize, 'lz_fitness_eventboxBgCColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Button Hover Background color', '#ffffff');




// Team page colors 
lzCustomLable($wp_customize, 'lz_fitness_teaminnerpagepageclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Team Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'lz_fitness_teaminnerImageborColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Team Image Border color', '#f67004');

addColorPalatOption($wp_customize, 'lz_fitness_teaminnerMemtitleColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Team Member Title color', '#000');

addColorPalatOption($wp_customize, 'lz_fitness_teaminnerDesignationColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Team Member Designation color', '#fc7406');

addColorPalatOption($wp_customize, 'lz_fitness_teaminnerSocialiconbgColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Social Icon Background color', '#909090');

addColorPalatOption($wp_customize, 'lz_fitness_teaminnerSocialiconcolorColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Social Icon Background color', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_teaminnerSocialhovbgColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Social Hover Background color', '#333');

addColorPalatOption($wp_customize, 'lz_fitness_teaminnerSocialhoviconColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Social Hover Icon color', '#f67004');








// Event page colors testimonial
lzCustomLable($wp_customize, 'lz_fitness_testimonialinnerpagepageclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Testimonial Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'lz_fitness_testimonialinnerpageborderColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Image Border color', '#f67004');
addColorPalatOption($wp_customize, 'lz_fitness_testimonialinnerpagetextColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Text color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_testimonialinnerpageclientnametextColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Client Name Text color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_testimonialinnerpageclientnametexthoverColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Client Name Text Hover color', '#f67004');

addColorPalatOption($wp_customize, 'lz_fitness_testimonialinnerpageclienttestboxbgddColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Testimonial Box Background color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_testimonialinnerpageclienttestboxborderColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Testimonial Box Border color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_testimonialinnerpageclienttestboxhighlightborderColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Testimonial Box Highlight Border color', '#f67004');





// FAQ page colors
lzCustomLable($wp_customize, 'lz_fitness_faqspageinnerclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Faq Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'lz_fitness_faqspageinnerpagetitleColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Title color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_faqspageinnerpagetitlebgColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Title Background color', '#f66f05');
addColorPalatOption($wp_customize, 'lz_fitness_faqspageinnerpagetitleiconColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Title Icon color', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_faqspageinnerpagetextColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Text color', '#000');

addColorPalatOption($wp_customize, 'lz_fitness_faqspageinnerpageboxbortColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Box border color', '#f66f05');




//HEADER SETTINGS
$wp_customize->add_section(
	'lz_fitness_header_settings',
	array(
		'title' => __( 'Header Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

	//ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
	'lz_fitness_sticky_header_enable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);

$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_sticky_header_enable',
		array(
			'settings'		=> 'lz_fitness_sticky_header_enable',
			'section'		=> 'lz_fitness_header_settings',
			'label'			=> __( 'Sticky Header', 'Luzuk Premium' ),
			'on_off_label' 	=> array(
				'on' => __( 'Enable', 'Luzuk Premium' ),
				'off' => __( 'Disable', 'Luzuk Premium' )
			)	
		)
	)
);
// //top header
// $wp_customize->add_setting(
// 	'lz_fitness_headermain_phonelabel',
// 	array(
// 		'sanitize_callback' => 'lz_fitness_sanitize_text',
// 		'default'           => __( 'Call Us Free:', 'Luzuk Premium' )
// 	)
// );
// $wp_customize->add_control(
// 	'lz_fitness_headermain_phonelabel',
// 	array(
// 		'settings'      => 'lz_fitness_headermain_phonelabel',
//		'section'       => 'lz_fitness_header_settings',
//		'type'          => 'text',
//		'label'         => __( 'Phone Label', 'Luzuk Premium' )
///	)
//);

//$wp_customize->add_setting(
//	'lz_fitness_headermain_phone',
//	array(
//		'sanitize_callback' => 'lz_fitness_sanitize_text',
//		'default'           => __( '(012) 345 6789' )
//	)
//);
//$wp_customize->add_control(
//	'lz_fitness_headermain_phone',
//	array(
//		'settings'      => 'lz_fitness_headermain_phone',
//		'section'       => 'lz_fitness_header_settings',
//		'type'          => 'text',
//		'label'         => __( 'Phone Number', 'Luzuk Premium' )
//	)
//);

 //header phone color
//header phone icon color
  // addColorPalatOption($wp_customize, 'lz_fitness_header_phoneiconColor', 'lz_fitness_header_settings', 'header phone number icon color', '#fbda4d');
  
  // addColorPalatOption($wp_customize, 'lz_fitness_header_phonetitleColor', 'lz_fitness_header_settings', 'header phone Label Text color', '#27394d'); 
   
 //addColorPalatOption($wp_customize, 'lz_fitness_header_phoneColor', 'lz_fitness_header_settings', 'header phone number color', '#27394d'); 
//$sectionHeader = 'lz_fitness_header_settings';
// Adding the Label
//lzCustomLable($wp_customize, 'lz_fitness_reservation_lblImgTxt', $sectionHeader, 'Social media icons');

// FACEBOOK 
//$wp_customize->add_setting('lz_fitness_header_fb',	array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
//$wp_customize->add_control('lz_fitness_header_fb',
//	array(
//		'settings'      => 'lz_fitness_header_fb',
//		'section'       => 'lz_fitness_header_settings',
//		'type'          => 'url',
//		'label'         => __( 'Facebook Url', 'lz-fitness-premium' )
//	)
//);
// TWITTER
//$wp_customize->add_setting('lz_fitness_header_tw', array('default'=> 'https://twitter.com', '//sanitize_callback' => 'esc_url_raw'));
//$wp_customize->add_control('lz_fitness_header_tw',
//	array(
//		'settings'      => 'lz_fitness_header_tw',
//		'section'       => 'lz_fitness_header_settings',
//		'type'          => 'url',
//		'label'         => __( 'Twitter Url', 'lz-fitness-premium' )
//	)
//);
// LINKED IN
//$wp_customize->add_setting('lz_fitness_header_in',array('default'=> 'https://linkedin.com','sanitize_callback' => 'esc_url_raw'));
//$wp_customize->add_control('lz_fitness_header_in',
//	array(
//		'settings'      => 'lz_fitness_header_in',
//		'section'       => 'lz_fitness_header_settings',
//		'type'          => 'url',
//		'label'         => __( 'Linkedin Url', 'lz-fitness-premium' )
//	)
//);
// Instagram
//$wp_customize->add_setting('lz_fitness_header_insta', array('default' => 'https://www.instagram.com', 'sanitize_callback' => 'esc_url_raw'));
//$wp_customize->add_control('lz_fitness_header_insta',
	//array(
//		'settings'      => 'lz_fitness_header_insta',
//		'section'       => 'lz_fitness_header_settings',
//		'type'          => 'url',
//		'label'         => __( 'Instagram', 'utsavplanner' )
//	)
//); 
//PINTREST
//$wp_customize->add_setting('lz_fitness_header_pintrest',array('default'=> 'https://in.pinterest.com/','sanitize_callback' => 'esc_url_raw'));
//$wp_customize->add_control('lz_fitness_header_pintrest',
	//array(
	//	'settings'      => 'lz_fitness_header_pintrest',
	//	'section'       => 'lz_fitness_header_settings',
	//	'type'          => 'url',
	//	'label'         => __( 'pintrest Url', 'lz-fitness-premium' )
//	)
//);



 // header Social color
 //  addColorPalatOption($wp_customize, 'lz_fitness_header_socialColor', 'lz_fitness_header_settings', 'Header social Icon color', '#283a48');
  //  addColorPalatOption($wp_customize, 'lz_fitness_header_socialBorderColor', 'lz_fitness_header_settings', 'Header social Icon Border color', '#283a48');
  // header Social hover color
  // addColorPalatOption($wp_customize, 'lz_fitness_header_socialhoverColor', 'lz_fitness_header_settings', 'Header social hover color', '#fbda4d');
//addColorPalatOption($wp_customize, 'lz_fitness_header_socialBorderhoverColor', 'lz_fitness_header_settings', 'Header social Icon Border Hover color', '#fbda4d');

 //addColorPalatOption($wp_customize, 'lz_fitness_header_backgroundColor', 'lz_fitness_header_settings', 'Upper header background color', '#f8f8f8');


//Menu colors
  // -----------------------

 //Set header menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headermenu_color', 'lz_fitness_header_settings', 'Header Menu Color', '#202020');
	//Set Current Menu Text colour
addColorPalatOption($wp_customize, 'lz_fitness_headercurrentmenu_color', 'lz_fitness_header_settings', 'Current Menu Text Color', '#ff7200');
	//Set Menu Hover Text colour
addColorPalatOption($wp_customize, 'lz_fitness_headerhovermenu_color', 'lz_fitness_header_settings', 'Hover Menu Text  Color', '#ff7200');
	//Set header sub menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenu_color', 'lz_fitness_header_settings', 'Header Dropdown Menu Color', '#ffffff');
	//Set header sub menu Background colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenubg_color', 'lz_fitness_header_settings', 'Header Dropdown Background Color', '#131313');

	//Set header sub menu hover colour
	addColorPalatOption($wp_customize, 'lz_fitness_headersubmenuhover_color', 'lz_fitness_header_settings', 'Header Dropdown Menu hover Color', '#000');

	//Set header sub menu Background hover colour
	addColorPalatOption($wp_customize, 'lz_fitness_headersubmenubghover_color', 'lz_fitness_header_settings', 'Header Dropdown Background hover Color', '#fff');
	//Set header sub menu border colour
	addColorPalatOption($wp_customize, 'lz_fitness_headersubmenuborder_color', 'lz_fitness_header_settings', 'Header Dropdown Border Color', '#f67104');

  //lower header background color
 // addColorPalatOption($wp_customize, 'lz_fitness_header_backgroundlowerColor', 'lz_fitness_header_settings', 'Logo Box background color', '#fff');
 
 addColorPalatOption($wp_customize, 'lz_fitness_header_navigationbgsbackgroundlowerColor', 'lz_fitness_header_settings', 'Navigation Box background color', '#ffffff');

lzCustomLable($wp_customize, 'lz_fitness_premium_headerbtn_lblbutton1display', 'lz_fitness_header_settings', 'Header Number Display & Text Setting:');
// to show & hide another button
$wp_customize->add_setting( 'headerrightbtn_number_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'headerrightbtn_number_display', array( 'label' => 'Number Display', 'section' => 'lz_fitness_header_settings', 'settings' => 'headerrightbtn_number_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Number', 'hide' => 'Hide Number', ), ) ); 
// end to show & hide button

// $wp_customize->add_setting(
// 	'lz_fitness_headermain_headerrightExt',
// 	array(
// 		'sanitize_callback' => 'lz_fitness_sanitize_text',
// 		'default'           => __( 'CALL NOW' )
// 	)
// );
// $wp_customize->add_control(
// 	'lz_fitness_headermain_headerrightExt',
// 	array(
// 		'settings'      => 'lz_fitness_headermain_headerrightExt',
// 		'section'       => 'lz_fitness_header_settings',
// 		'type'          => 'text',
// 		'label'         => __( 'Button Text', 'lz-fitness-premium' )
// 	)
// );
// $wp_customize->add_setting('lz_fitness_header_headerrightExtlink',	array('default'=> 'add Button link here', 'sanitize_callback' => 'esc_url_raw'));
// $wp_customize->add_control('lz_fitness_header_headerrightExtlink',
// 	array(
// 		'settings'      => 'lz_fitness_header_headerrightExtlink',
// 		'section'       => 'lz_fitness_header_settings',
// 		'type'          => 'url',
// 		'label'         => __( 'Button Url', 'utsavplanner' )
// 	)
// );

$wp_customize->add_setting(
	'lz_fitness_headermain_phone',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '+999 999 9999', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_phone',
	array(
		'settings'      => 'lz_fitness_headermain_phone',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Phone Number', 'lz-fitness-premium' )
	)
);

addColorPalatOption($wp_customize, 'lz_fitness_headerrightboxbtntest_color', 'lz_fitness_header_settings', 'Button Text Color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_headerrightboxbtntesthover_color', 'lz_fitness_header_settings', 'Button Text Hover Color', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_headerrightboxbgss_color', 'lz_fitness_header_settings', 'Button Background Color', '#ff7200');
addColorPalatOption($wp_customize, 'lz_fitness_headerrightboxbgsshover_color', 'lz_fitness_header_settings', 'Button Background Hover Color', '#000');


  
//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'lz_fitness_footer_copyright_settings',
	array(
		'title' => __( 'Footer Copyright Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

$wp_customize->add_setting(
	'lz_fitness_footer_copyrighttext',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Event Planner | All rigjt reserved', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_footer_copyrighttext',
	array(
		'settings'      => 'lz_fitness_footer_copyrighttext',
		'section'       => 'lz_fitness_footer_copyright_settings',
		'type'          => 'text',
		'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
	)
);

backgroundManager($wp_customize, 'footer', 'lz_fitness_footer_copyright_settings', $color='#131313', get_template_directory_uri().'/images/default-gray.png', 'img');

//theme Footer text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_text_color', 'lz_fitness_footer_copyright_settings', 'Footer Text Color', '#fff');

//theme Footer Text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrighttext_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Text Color', '#fff');


addColorPalatOption($wp_customize, 'lz_fitness_footer_menu_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Color', '#fff');

addColorPalatOption($wp_customize, 'lz_fitness_footer_menuhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Hover Color', '#ff7101');




//theme Footer menu hover Color






//theme Copyright Footer bg Color
//addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrightbg_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Background Color', '#283949');





//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'lz_fitness_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'lz_fitness_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 

// end to show & hide button
//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbtitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox title color', '#000');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title color', '#f67104');

//Inner page breadcrumbbox background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbbgcolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox background color', '#fff');


//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'lz_fitness_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'lz_fitness_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 
// end to show & hide button


// Innerpage Font Setting:
$wp_customize->add_section(
	'lz_fitness_innerpagefont_settings',
	array(
		'title' => __( 'Inner Page Fonts Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_innerpageh1_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading1:');


$wp_customize->add_setting(
	'pages_innerpageheading',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '35px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading',
	array(
		'settings'      => 'pages_innerpageheading',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading1', 'lz-fitness-premium' )
	)
);





lzCustomLable($wp_customize, 'lz_fitness_innerpageh2_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading2:');


$wp_customize->add_setting(
	'pages_innerpageheading2',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '30px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading2',
	array(
		'settings'      => 'pages_innerpageheading2',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading2', 'lz-fitness-premium' )
	)
);


lzCustomLable($wp_customize, 'lz_fitness_innerpageh3_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading3:');


$wp_customize->add_setting(
	'pages_innerpageheading3',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '25px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading3',
	array(
		'settings'      => 'pages_innerpageheading3',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading3', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'lz_fitness_innerpageh4_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading4:');


$wp_customize->add_setting(
	'pages_innerpageheading4',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '20px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading4',
	array(
		'settings'      => 'pages_innerpageheading4',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading4', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'lz_fitness_innerpageh5_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading5:');


$wp_customize->add_setting(
	'pages_innerpageheading5',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '15px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading5',
	array(
		'settings'      => 'pages_innerpageheading5',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading5', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'lz_fitness_innerpageh6_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading5:');


$wp_customize->add_setting(
	'pages_innerpageheading6',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '18px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading6',
	array(
		'settings'      => 'pages_innerpageheading6',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading6', 'lz-fitness-premium' )
	)
);




