<?php   
/**
 * Createing an about us pannel for customizer
 *
 */
// TEAM SECTION START HERE 
/*============TEAM SECTION PANEL============*/
$wp_customize->add_section(
	'lz_fitness_ct_team_section',
	array(
		'title'         => __( 'Our Teams Section', 'lz-fitness-premium' ),
		'panel'   => 'lz_fitness_premium_home_panel',
	)
);
// ENABLE/DISABLE TEAM SECTION
$wp_customize->add_setting(
	'lz_fitness_ct_team_section_disable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_ct_team_section_disable',
		array(
			'settings'      => 'lz_fitness_ct_team_section_disable',
			'section'       => 'lz_fitness_ct_team_section',
			'label'         => __( 'Disable Section', 'lz-fitness-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'lz-fitness-premium' ),
				'off' => __( 'No', 'lz-fitness-premium' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'ctteam', 'lz_fitness_ct_team_section', $color='#fff');


$wp_customize->add_setting(
	'lz_fitness_team_title_subtitle_heading',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
	)
);
$wp_customize->add_control(
	new lz_fitness_Customize_Heading(
		$wp_customize,
		'lz_fitness_team_title_subtitle_heading',
		array(
			'settings'      => 'lz_fitness_team_title_subtitle_heading',
			'section'       => 'lz_fitness_ct_team_section',
			'label'         => __( 'Section Title', 'lz-fitness-premium' ),
		)
	)
);


$wp_customize->add_setting(
	'lz_fitness_team_title',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Our Team', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_team_title',
	array(
		'settings'      => 'lz_fitness_team_title',
		'section'       => 'lz_fitness_ct_team_section',
		'type'          => 'text',
		'label'         => __( 'Section Title', 'lz-fitness-premium' )
	)
);
// Heading color
addColorPalatOption($wp_customize, 'team_HeadingColor', 'lz_fitness_ct_team_section', 'Heading color','#282828');


// Heading border color
addColorPalatOption($wp_customize, 'team_HeadingIconColor', 'lz_fitness_ct_team_section', 'Heading Icon color','#5f5f5f');

// Heading border color
addColorPalatOption($wp_customize, 'team_HeadingIconborderColor', 'lz_fitness_ct_team_section', 'Heading Icon Border color','#5f5f5f');


/*for note text*/
$wp_customize->add_setting('lz_team_sectionnoteser_lbl', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
$wp_customize->add_control(
    new lz_fitness_Info_Text( 
        $wp_customize,
        'lz_team_sectionnoteser_lbl',
        array(
            'settings'      => 'lz_team_sectionnoteser_lbl',
            'section'       => 'lz_fitness_ct_team_section',
            'label'         => __( 'Note:', 'worldwide' ),    
            'description'   => __( 'Just place the shortcode "[TEAMLIST]" in your page to Show all team members in a page', 'worldwide' ),
        )
    )
);

$wp_customize->add_setting('lz_fitness_teammembername_section_lbl', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
$wp_customize->add_control(
	new lz_fitness_Info_Text( 
		$wp_customize,
		'lz_fitness_teammembername_section_lbl',
		array(
			'settings'		=> 'lz_fitness_teammembername_section_lbl',
			'section'		=> 'lz_fitness_ct_team_section',
			'label'			=> __( 'Note:', 'eventplanner' ),	
			'description'	=> __( 'Add team member images of equal height, recommend image height of size 380px', 'eventplanner' ),
		)
	)
);
/*for note text*/

$wp_customize->add_setting('lz_fitness_team_npp_heading',array('sanitize_callback' => 'lz_fitness_sanitize_text'));
$wp_customize->add_control(
	new lz_fitness_Customize_Heading(
		$wp_customize,
		'lz_fitness_team_npp_heading',
		array(
			'settings'      => 'lz_fitness_team_npp_heading',
			'section'       => 'lz_fitness_ct_team_section',
			'label'         => __( 'Number Of team members to show', 'lz-fitness-premium' ),
		)
	)
);    
$wp_customize->add_setting('lz_fitness_team_npp_count',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => 2));
$wp_customize->add_control(
	'lz_fitness_team_npp_count',
	array(
		'settings'      => 'lz_fitness_team_npp_count',
		'section'       => 'lz_fitness_ct_team_section',
		'type'          => 'select',
		'label'         => __( 'Number of team members to show', 'lz-fitness-premium' ),
		'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
	)
);

// TEAM PAGES
for( $i = 1; $i <= 12; $i++ ){
	$wp_customize->add_setting(
		'lz_fitness_team_heading'.$i,
		array(
			'sanitize_callback' => 'lz_fitness_sanitize_text'
		)
	);
	$wp_customize->add_control(
		new lz_fitness_Customize_Heading(
			$wp_customize,
			'lz_fitness_team_heading'.$i,
			array(
				'settings'      => 'lz_fitness_team_heading'.$i,
				'section'       => 'lz_fitness_ct_team_section',
				'label'         => __( 'Team Member ', 'lz-fitness-premium' ).$i,
			)
		)
	);
	if(is_array($lzFitnessTeamsSingleChoice)){
		$wp_customize->add_setting(
			'lz_fitness_team_page'.$i,
			array(
				'sanitize_callback' => 'absint'
			)
		);
		$wp_customize->add_control(
			'lz_fitness_team_page'.$i,
			array(
				'settings'      => 'lz_fitness_team_page'.$i,
				'section'       => 'lz_fitness_ct_team_section',
				'type'=> 'select',
				'label'         => __( 'Select a Team Member', 'lz-fitness-premium' ),
				'choices' => $lzFitnessTeamsSingleChoice,
			)
		);
	}else{
		$wp_customize->add_setting('lz_fitness_ct_team_section_lbl'.$i, array('sanitize_callback'=>'lz_fitness_sanitize_text'));
		$wp_customize->add_control(
			new lz_fitness_Info_Text( 
				$wp_customize,
				'lz_fitness_ct_team_section_lbl'.$i,
				array(
					'settings'		=> 'lz_fitness_ct_team_section_lbl'.$i,
					'section'		=> 'lz_fitness_ct_team_section',
					'label'			=> __( 'Note:', 'lz-fitness-premium' ),	
					'description'	=> __( '<strong>Changes will not reflect unless you select the team member.</strong> <br/>Please add the team from "Teams menu" and then select team member to show information.', 'lz-fitness-premium' ),
				)
			)
		);
	}
}
// member image overlay color
addColorPalatOption($wp_customize, 'team_imgborderColor', 'team_section', 'Image border color', '#4d4d4d');

// member image overlay color
addColorPalatOption($wp_customize, 'team_imgborderhorColor', 'team_section', 'Image hover border color', '#fc7406');

// member name color
addColorPalatOption($wp_customize, 'team_MemTitleColor', 'team_section', 'Member Title color', '#ffffff');

// member designation color
addColorPalatOption($wp_customize, 'team_DesColor', 'team_section', 'Designation color', '#ffffff');

addColorPalatOption($wp_customize, 'team_boxColor', 'team_section', 'Member Title background color', '#f67203');
