<?php

$wp_customize->add_panel(
	'lz_fitness_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'lz-fitness-premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'lz-fitness-premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );


//HEADER LOGO MARGIN SETTINGS
$wp_customize->add_section(
	'lz_fitness_headerlogo_settings',
	array(
		'title' => __( 'Header Logo Margin Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_headerlogo_margin', 'lz_fitness_headerlogo_settings', ' Site Header Logo Margin:');


$wp_customize->add_setting(
	'pages_logoTmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '5px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoTmargin',
	array(
		'settings'      => 'pages_logoTmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Top Margin', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoBmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '5px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoBmargin',
	array(
		'settings'      => 'pages_logoBmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Bottom Margin', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoLmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoLmargin',
	array(
		'settings'      => 'pages_logoLmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Left Margin', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoRmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoRmargin',
	array(
		'settings'      => 'pages_logoRmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Right Margin', 'lz-fitness-premium' )
	)
);

/// page fonts
//INNER PAGE HEADING FONT SIZE SETTINGS
$wp_customize->add_section(
	'innerheadingfontsize_settings',
	array(
		'title' => __( 'Inner Page Heading Font Size Settings', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);


$wp_customize->add_setting(
	'pages_h1font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '28px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h1font',
	array(
		'settings'      => 'pages_h1font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 1 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h2font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '26px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h2font',
	array(
		'settings'      => 'pages_h2font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 2 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h3font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '24px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h3font',
	array(
		'settings'      => 'pages_h3font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 3 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h4font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '22px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h4font',
	array(
		'settings'      => 'pages_h4font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 4 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h5font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '20px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h5font',
	array(
		'settings'      => 'pages_h5font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 5 Font Size', 'luzuk-premium' )
	)
);


$wp_customize->add_setting(
	'pages_h6font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '18px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h6font',
	array(
		'settings'      => 'pages_h6font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 6 Font Size', 'luzuk-premium' )
	)
);







//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );



//HEADER SETTINGS
$wp_customize->add_section(
	'lz_fitness_header_settings',
	array(
		'title' => __( 'Header Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

	//ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
	'lz_fitness_sticky_header_enable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);

$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_sticky_header_enable',
		array(
			'settings'		=> 'lz_fitness_sticky_header_enable',
			'section'		=> 'lz_fitness_header_settings',
			'label'			=> __( 'Sticky Header', 'lz-fitness-premium' ),
			'on_off_label' 	=> array(
				'on' => __( 'Enable', 'lz-fitness-premium' ),
				'off' => __( 'Disable', 'lz-fitness-premium' )
			)	
		)
	)
);

$sectionHeader = 'lz_fitness_header_settings';


lzCustomLable($wp_customize, 'lz_fitness_header_clrlblbgTxt', 'lz_fitness_header_settings', 'Set Header Background Colors:');

//Set top header colour
addColorPalatOption($wp_customize, 'lz_fitness_topheader_color', 'lz_fitness_header_settings', 'Top Header Background Color', '#f7f7f7');


//Set top header shape colour
addColorPalatOption($wp_customize, 'lz_fitness_topheadershape_color', 'lz_fitness_header_settings', 'Top Header Shape Color', '#014282');

$wp_customize->add_setting(
	'lz_fitness_headermain_phone',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '012 345 6789', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_phone',
	array(
		'settings'      => 'lz_fitness_headermain_phone',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Phone Number', 'lz-fitness-premium' )
	)
);

$wp_customize->add_setting(
	'lz_fitness_headermain_email',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Info@example.com', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_email',
	array(
		'settings'      => 'lz_fitness_headermain_email',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Email Address', 'lz-fitness-premium' )
	)
);





//Set header phone icon  colour
addColorPalatOption($wp_customize, 'lz_fitness_header_phoneiconColor', 'lz_fitness_header_settings', 'Header Icon Color', '#5b5b5b');

//Set header phone hover colour
addColorPalatOption($wp_customize, 'lz_fitness_header_phoneiconhoverColor', 'lz_fitness_header_settings', 'Header Icon Hover Color', '#000');

//Set header phone colour
addColorPalatOption($wp_customize, 'lz_fitness_header_phoneColor', 'lz_fitness_header_settings', 'Header Phone Color', '#5b5b5b');

//Set header Mail  colour
addColorPalatOption($wp_customize, 'lz_fitness_header_MailidColor', 'lz_fitness_header_settings', 'Header Mail id Color', '#5b5b5b');

//Set header Mail  colour
addColorPalatOption($wp_customize, 'lz_fitness_header_MailidhovColor', 'lz_fitness_header_settings', 'Header Mail id Hover Color', '#d31a3c');

// Adding the Label
lzCustomLable($wp_customize, 'lz_fitness_reservation_lblImgTxt', $sectionHeader, 'Social media icons');


// FACEBOOK 
$wp_customize->add_setting('lz_fitness_header_fb',	array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_fb',
	array(
		'settings'      => 'lz_fitness_header_fb',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Facebook Url', 'lz-fitness-premium' )
	)
);
// TWITTER
$wp_customize->add_setting('lz_fitness_header_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_tw',
	array(
		'settings'      => 'lz_fitness_header_tw',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Twitter Url', 'lz-fitness-premium' )
	)
);
// LINKED IN
$wp_customize->add_setting('lz_fitness_header_in',array('default'=> 'https://linkedin.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_in',
	array(
		'settings'      => 'lz_fitness_header_in',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Linkedin Url', 'lz-fitness-premium' )
	)
);

// Instagram
$wp_customize->add_setting('lz_fitness_header_insta', array('default' => 'https://www.instagram.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_insta',
	array(
		'settings'      => 'lz_fitness_header_insta',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Instagram', 'gurukul' )
	)
); 

// //googleplus
// $wp_customize->add_setting('lz_fitness_header_googleplus',array('default'=> 'https://accounts.google.com','sanitize_callback' => 'esc_url_raw'));
// $wp_customize->add_control('lz_fitness_header_googleplus',
// 	array(
// 		'settings'      => 'lz_fitness_header_googleplus',
// 		'section'       => 'lz_fitness_header_settings',
// 		'type'          => 'url',
// 		'label'         => __( 'Googleplus Url', 'gurukul' )
// 	)
// );

// //youtube
$wp_customize->add_setting('lz_fitness_header_youtube',array('default'=> 'https://www.youtube.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_youtube',
	array(
		'settings'      => 'lz_fitness_header_youtube',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Youtube Url', 'gurukul' )
	)
);


 //header social color   
addColorPalatOption($wp_customize, 'lz_fitness_header_socialColor', 'lz_fitness_header_settings', ' Header social color', '#fff');

//header social hover color   
addColorPalatOption($wp_customize, 'lz_fitness_header_socialhoverColor', 'lz_fitness_header_settings', ' Header social hover color', '#d31a3c');


//header

// $wp_customize->add_setting(
// 	'lz_fitness_headermain_emaillabel',
// 	array(
// 		'sanitize_callback' => 'lz_fitness_sanitize_text',
// 		'default'           => __( 'EMAIL SUPPORT', 'lz-fitness-premium' )
// 	)
// );
// $wp_customize->add_control(
// 	'lz_fitness_headermain_emaillabel',
// 	array(
// 		'settings'      => 'lz_fitness_headermain_emaillabel',
// 		'section'       => 'lz_fitness_header_settings',
// 		'type'          => 'text',
// 		'label'         => __( 'Email Label', 'lz-fitness-premium' )
// 	)
// );

// $wp_customize->add_setting(
// 	'lz_fitness_headermain_address',
// 	array(
// 		'sanitize_callback' => 'lz_fitness_sanitize_text',
// 		'default'           => __( 'Your Location, Sydney', 'lz-fitness-premium' )
// 	)
// );
// $wp_customize->add_control(
// 	'lz_fitness_headermain_address',
// 	array(
// 		'settings'      => 'lz_fitness_headermain_address',
// 		'section'       => 'lz_fitness_header_settings',
// 		'type'          => 'text',
// 		'label'         => __( 'Address', 'lz-fitness-premium' )
// 	)
// );






lzCustomLable($wp_customize, 'lz_fitness_premium_header_lblbutton1display', 'lz_fitness_header_settings', 'Header ENQUIRY NOW Button Display & Text Setting:');
// to show & hide another button
$wp_customize->add_setting( 'cds_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'cds_button_display', array( 'label' => 'Button Display', 'section' => 'lz_fitness_header_settings', 'settings' => 'cds_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button
// appointment 
$wp_customize->add_setting(
	'lz_fitness_headermain_headerinquirytitle',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'ENQUIRY NOW' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_headerinquirytitle',
	array(
		'settings'      => 'lz_fitness_headermain_headerinquirytitle',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Header Button Text', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting('lz_fitness_header_headerinquiry',	array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_headerinquiry',
	array(
		'settings'      => 'lz_fitness_header_headerinquiry',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Add "Header Button" link here', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'lz_fitness_header_clrlbtnTxt', 'lz_fitness_header_settings', 'Set Header Button Colors:');

//Set header button colour
addColorPalatOption($wp_customize, 'lz_fitness_headerbtn_color', 'lz_fitness_header_settings', 'Header Button Color', '#fff');

//Set header button bg colour
addColorPalatOption($wp_customize, 'lz_fitness_headerbtnbg_color', 'lz_fitness_header_settings', 'Header Button Background Color', '#d31a3c');

//Set header button hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headerbtnhover_color', 'lz_fitness_header_settings', 'Header Button Hover Color', '#fff');

//Set header button bg hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headerbtnbghover_color', 'lz_fitness_header_settings', 'Header Button Background Hover Color', '#000');


lzCustomLable($wp_customize, 'lz_fitness_header_clrlblImgTxt', 'lz_fitness_header_settings', 'Set Header Menu Colors:');

//Set header menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headermenu_color', 'lz_fitness_header_settings', 'Header Menu Color', '#292728');

//Set header current menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headercurrentmenu_color', 'lz_fitness_header_settings', 'Header Current Menu Color', '#292728');

//Set header current menu bg colour
addColorPalatOption($wp_customize, 'lz_fitness_headercurrentmenubg_color', 'lz_fitness_header_settings', 'Header Current Menu border Color', '#d21a3c');

//Set header menu hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headermenuhover_color', 'lz_fitness_header_settings', 'Header Menu Hover Color', '#000');

//Set header menu hover bg colour
addColorPalatOption($wp_customize, 'lz_fitness_headermenuhoverbg_color', 'lz_fitness_header_settings', 'Header Menu Hover border Color', '#d21a3c');

//Set header sub menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenu_color', 'lz_fitness_header_settings', 'Header Sub Menu Color', '#000');

//Set header dropdown Background colour
addColorPalatOption($wp_customize, 'lz_fitness_headerdropdownbg_color', 'lz_fitness_header_settings', 'Header dropdown Background Color', '#ffffff');

//Set header dropdown border colour
addColorPalatOption($wp_customize, 'lz_fitness_headerdropdownborder_color', 'lz_fitness_header_settings', 'Header dropdown Border Color', '#d31a3c');


//Set header sub menu hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenuhover_color', 'lz_fitness_header_settings', 'Header Sub Menu Hover Color', '#1f4282');

//Set header sub menu arrow hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenuarrowhover_color', 'lz_fitness_header_settings', 'Header Sub Menu Arrow Hover Color', '#d31a3c');

//Set header current sub menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headercurrentsubmenu_color', 'lz_fitness_header_settings', 'Header Current Sub Menu Color', '#000');

//mobail menus colors
lzCustomLable($wp_customize, 'lz_fitness_premium_header_mobilemdisplay', 'lz_fitness_header_settings', 'Header Mobile Menus Colors Setting:');

//Mobile M colors
addColorPalatOption($wp_customize, 'lz_fitness_mobiTogglebg_color', 'lz_fitness_header_settings', 'Header Mobile Toggle Icon Color', '#d3193c');

//Mobile M colors
addColorPalatOption($wp_customize, 'lz_fitness_mobiToggleoverlaybg_color', 'lz_fitness_header_settings', 'Header Mobile Toggle overlay Background Color', '#666');

//Mobile M colors
addColorPalatOption($wp_customize, 'lz_fitness_mobimenubarbg_color', 'lz_fitness_header_settings', 'Header Mobile Menu Bar Background Color', '#20497c');

//Mobile M colors
addColorPalatOption($wp_customize, 'lz_fitness_mobimenu_color', 'lz_fitness_header_settings', 'Header Mobile Menu Color', '#ffffff');


lzCustomLable($wp_customize, 'lz_fitness_premium_header_lblbutton2display', 'lz_fitness_header_settings', 'Header Search Button Display Setting:');
// to show & hide another button
$wp_customize->add_setting( 'search_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'search_button_display', array( 'label' => 'Button Display', 'section' => 'lz_fitness_header_settings', 'settings' => 'search_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button


//Set header Search icon colour
addColorPalatOption($wp_customize, 'lz_fitness_headersearciconcolor', 'lz_fitness_header_settings', 'Header Search Icon Color', '#000');

//Set header Search icon  colour
addColorPalatOption($wp_customize, 'lz_fitness_headersearciconhovcolor', 'lz_fitness_header_settings', 'Header Search Icon Hover Color', '#014282');
//Set header Search colour
addColorPalatOption($wp_customize, 'lz_fitness_headersearchba_color', 'lz_fitness_header_settings', 'Header Search Input Background Color', '#000');
//placeholder color
addColorPalatOption($wp_customize, 'lz_fitness_headersearchbaPlaceholdercolor', 'lz_fitness_header_settings', 'Header Search Placeholder text Color', '#ffffff');





//Set header Search Button hov colour
addColorPalatOption($wp_customize, 'lz_fitness_headersearchbutBghovtexcolor', 'lz_fitness_header_settings', 'Header Search border Color', '#979797');


//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'lz-fitness-premium'),
	'panel' => 'lz_fitness_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'lz_fitness_template_color', 'colors', 'Theme Primary Color', '#014282');
//Inner page title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');
//Inner page background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_bgcolor', 'colors', 'Inner page title background color', '#014282');

//Inner page background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagewidgetstitlecolor', 'colors', 'Sidebar widgets title color', '#000');

//Inner page background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagelinkcolor', 'colors', 'Inner page link color', '#000');

//Inner page background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagehoverlinkcolor', 'colors', 'Inner page link hover color', '#d31a3c');




//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'lz_fitness_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'lz_fitness_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 

// end to show & hide button

$wp_customize->add_setting(
        'lz_fitness_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default'           => __( 'Home', 'unboxthemes' )
        )
    );
    $wp_customize->add_control(
        'lz_fitness_breadcrumbhometxt',
        array(
            'settings'      => 'lz_fitness_breadcrumbhometxt',
            'section'       => 'lz_fitness_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here:', 'unboxthemes' )
        )
    );

//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbtitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox title color', '#000');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title color', '#014282');

//Inner page breadcrumbbox current hover title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlehovercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title hover color', '#d31a3c');

//Inner page breadcrumbbox background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbbgcolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox background color', '#fff');

//Inner page breadcrumbbox border color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbordercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox border color', '#d31a3c');


//Inner page content box heading 1 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh1color', 'colors', 'Heading 1 color', '#333333');

//Inner page content box heading 2 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh2color', 'colors', 'Heading 2 color', '#333333');

//Inner page content box heading 3 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh3color', 'colors', 'Heading 3 color', '#333333');

//Inner page content box heading 4 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh4color', 'colors', 'Heading 4 color', '#333333');

//Inner page content box heading 5 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh5color', 'colors', 'Heading 5 color', '#333333');

//Inner page content box heading 6 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh6color', 'colors', 'Heading 6 color', '#333333');

//Inner page content box list color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistcolor', 'colors', 'Inner page content box list color', '#303030');

//Inner page content box list icon color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlisticoncolor', 'colors', 'Inner page content box list icon color', '#1f4282');

//Inner page content box list number color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistnumbercolor', 'colors', 'Inner page content box list number color', '#fff');

//Inner page content box list number bg color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistnumberbgcolor', 'colors', 'Inner page content box list number background color', '#1f4282');

//Inner page content box links color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlinkcolor', 'colors', 'Inner page content box links color', '#262642');


// //INNER feature PAGE COLOR SETTINGS
// $wp_customize->add_section(
// 	'lz_fitness_feature_page_settings',
// 	array(
// 		'title' => __( 'Inner feature Page Settings', 'lz-fitness-premium' ),
// 		'panel' => 'lz_fitness_general_panel',
// 	)
// );


// // title color
// addColorPalatOption($wp_customize, 'lz_featuredinnertitle_Color', 'lz_fitness_feature_page_settings', 'Title color', '#3a4559');

// // title hover color
// addColorPalatOption($wp_customize, 'lz_featuredinnertitlehover_Color', 'lz_fitness_feature_page_settings', 'Title hover color', '#d0ac62');

// // text color
// addColorPalatOption($wp_customize, 'lz_featuredinnertext_Color', 'lz_fitness_feature_page_settings', 'Text color', '#383838');

// //box bg color
// addColorPalatOption($wp_customize, 'lz_featuredboxinnerbg_Color', 'lz_fitness_feature_page_settings', 'Box background color', '#fff');


// // border color
// addColorPalatOption($wp_customize, 'lz_featuredboxinnerborder_Color', 'lz_fitness_feature_page_settings', 'Border color', '#3a4559');

//INNER FAQS PAGE COLOR SETTINGS
// $wp_customize->add_section(
// 	'lz_fitness_faqs_page_settings',
// 	array(
// 		'title' => __( 'Inner FAQS Page Color Settings', 'lz-fitness-premium' ),
// 		'panel' => 'lz_fitness_general_panel',
// 	)
// );

// //INNER GALLERY PAGE COLOR SETTINGS
// $wp_customize->add_section(
// 	'gallery_page_settings',
// 	array(
// 		'title' => __( 'Inner Gallery Page Settings', 'lz-fitness-premium' ),
// 		'panel' => 'lz_fitness_general_panel',
// 	)
// );

lzCustomLable($wp_customize, 'lz_fitness_template_color8', 'colors', 'Inner Gallery Page Settings');
// img border color
addColorPalatOption($wp_customize, 'galleryinner_imgborderColor', 'colors', 'Image border color', '#1f4282');

// img animated border color
addColorPalatOption($wp_customize, 'galleryinner_imganimatedborderColor', 'colors', 'Image animated border color', '#d31a3c');

lzCustomLable($wp_customize, 'lz_fitness_template_color4', 'colors', 'Inner FAQS Page Color Settings');

//ques border color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_QborderColor', 'colors', 'Faq Box border color', '#1f4282');


//ques text color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_QtextColor', 'colors', 'Question text color', '#000');

//down arrow text color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_QdownarrowColor', 'colors', 'Question indicator arrow color', '#154281');



//ans text color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_AtextColor', 'colors', 'Answer text color', '#ffffff');

//ans bg color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_AbgColor', 'colors', 'Answer background color', '#154281');


//Inner Testimonial Page

lzCustomLable($wp_customize, 'lz_fitness_template_color3', 'colors', 'Inner Testimonial Page Color Settings');

// text color
addColorPalatOption($wp_customize, 'testimonialalsinner_boxborColor', 'colors', 'Testimonial Box Border color', '#b22829');

// text color
addColorPalatOption($wp_customize, 'testimonialinnerp_boxbgColor', 'colors', 'Testimonial Box Background color', '#ffffff');

// text color
addColorPalatOption($wp_customize, 'testimonialinnerp_boxquoteicColor', 'colors', 'Testimonial Box Quote Icon color', '#154281');

// text color
addColorPalatOption($wp_customize, 'testimonialinnerp_boxTextColor', 'colors', 'Testimonial Box Text color', '#000000');

// text color
addColorPalatOption($wp_customize, 'testimoninnerp_boxclientnaColor', 'colors', 'Testimonial Box Client Name  color', '#000000');

// text color
addColorPalatOption($wp_customize, 'testimoninnerp_boxclDesigtionColor', 'colors', 'Testimonial Box Client Designation color', '#154281');

// text color
addColorPalatOption($wp_customize, 'testimoninnerp_boximgborColor', 'colors', 'Testimonial Box Image Border color', '#154281');




lzCustomLable($wp_customize, 'lz_fitness_template_color2', 'colors', 'Inner Team Page Color Setting');

// member name color
addColorPalatOption($wp_customize, 'teaminner_team_teammembernameColor', 'colors', 'Select Team Member Name Text color', '#373737');

addColorPalatOption($wp_customize, 'teaminner_team_teammembernamehvrColor', 'colors', 'Select Team Member Name Text Hover color', '#fff');

addColorPalatOption($wp_customize, 'teaminner_team_teammemberdesignationtxtColor', 'colors', 'Select Team Member Designation Text color', '#6c6c6c');

addColorPalatOption($wp_customize, 'teaminner_team_teammemberdesignationtxthvrColor', 'colors', 'Select Team Member Designation Text Hover color', '#fff');

addColorPalatOption($wp_customize, 'teaminner_team_detailsbxbgssColor', 'colors', 'Select Team Member Details Box Background color', '#fff');

addColorPalatOption($wp_customize, 'teaminner_team_detailsbxbgsshvrColor', 'colors', 'Select Team Member Details Box Hover Background color', '#d31b3d');

addColorPalatOption($wp_customize, 'teaminner_team_detailsbxborColor', 'colors', 'Select Team Member Details Box Border color', '#d9d9d9');

addColorPalatOption($wp_customize, 'teaminner_team_SocialbgbackColor', 'colors', 'Select Social Background color', '#014282');


addColorPalatOption($wp_customize, 'teaminner_team_SocialcolorColor', 'colors', 'Select Social Icon color', '#fff');

addColorPalatOption($wp_customize, 'teaminner_team_SocialiconhvrColor', 'colors', 'Select Social Icon Hover color', '#d31a3c');

addColorPalatOption($wp_customize, 'teaminner_team_MemberImagehobgColor', 'colors', 'Select Member Image Background Hover color', '#014282');





lzCustomLable($wp_customize, 'lz_fitness_template_color1', 'colors', 'Inner Project Page Color Settings');


addColorPalatOption($wp_customize, 'lz_fitness_project_ProjectoverlayinnerbgsColor', 'colors', 'Project Overlay Background color', '#014282');

addColorPalatOption($wp_customize, 'lz_fitness_project_ProjectinnertitleColor', 'colors', 'Project Title color', '#014282');

addColorPalatOption($wp_customize, 'lz_fitness_ProjectinnertextColor', 'colors', 'Project Text color', '#333333');

addColorPalatOption($wp_customize, 'innproject_viewbtnColor', 'colors', 'Button Icon color', '#ffffff');

addColorPalatOption($wp_customize, 'innproject_viewbtnhoverColor', 'colors', 'Button Icon Hover color', '#000');

addColorPalatOption($wp_customize, 'innproject_buttBgColor', 'colors', 'Button Background color', '#d31a3c');

addColorPalatOption($wp_customize, 'innproject_butthoverBgColor', 'colors', 'Button Hover Background color', '#ffffff');


// //INNER logos PAGE COLOR SETTINGS
// $wp_customize->add_section(
// 	'logo_page_settings',
// 	array(
// 		'title' => __( 'Inner Logo Page Color Settings', 'lz-fitness-premium' ),
// 		'panel' => 'lz_fitness_general_panel',
// 	)
// );

lzCustomLable($wp_customize, 'lz_fitness_template_color', 'colors', 'Inner Logo Page Color Settings');


addColorPalatOption($wp_customize, 'innlogo_logobordercolor', 'colors', 'logo border color', '#1f4282');




  
//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'lz_fitness_footer_copyright_settings',
	array(
		'title' => __( 'Footer Copyright Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

$wp_customize->add_setting(
	'lz_fitness_footer_copyrighttext',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Copyright © 2019 Luzuk Business. All Rights Reserved', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_footer_copyrighttext',
	array(
		'settings'      => 'lz_fitness_footer_copyrighttext',
		'section'       => 'lz_fitness_footer_copyright_settings',
		'type'          => 'text',
		'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
	)
);

backgroundManager($wp_customize, 'footer', 'lz_fitness_footer_copyright_settings', $color='#003261', get_template_directory_uri().'/images/default-gray.png', 'img');

//theme Footer title Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_title_color', 'lz_fitness_footer_copyright_settings', 'Footer Title Color', '#fff');



//theme Footer icon Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_icon_color', 'lz_fitness_footer_copyright_settings', 'Footer Icon Color', '#fff');

//theme Footer icon hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_iconhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Icon Hover Color', '#d31a3c');

//theme Footer text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_text_color', 'lz_fitness_footer_copyright_settings', 'Footer Text Color', '#fff');

//theme Footer menu Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menu_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Color', '#fff');

//theme Footer menu hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menuhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Hover Color', '#d21a3d');

//theme Footer menu date Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menudate_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Date Color', '#fff');

//theme Footer menu icon Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_navicon_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Icon Color', '#fff');

//theme Footer menu icon hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menuiconhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Icon Hover Color', '#d21a3d');


//theme Footer social Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_social_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Color', '#fff');

//theme Footer social Hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Hover Color', '#828282');



//theme Footer form Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_form_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Color', '#fff');

//theme Footer form border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formborder_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Border Color', '#fff');

//theme Footer form button Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtn_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Color', '#fff');

//theme Footer Form Button Background Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtnbg_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Background Color', '#666666');

//theme Copyright Footer Border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrightborder_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Border Color', '#1c4973');

//theme Footer Text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrighttext_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Text Color', '#fff');

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'lz_fitness_postpagedate_settings',
	array(
		'title' => __( 'Postpage Date Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'lz_fitness_postpagedate_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Date', 'hide' => 'Hide Post Date', ), ) ); 

// end to show & hide button

//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'lz_fitness_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'lz_fitness_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 