<?php 
/**
 * Createing an about us pannel for customizer
 *
 */
// PROJECT SECTION START HERE 
/*============PROJECT SECTION PANEL============*/
$wp_customize->add_section(
	'project_section',
	array(
		'title'         => __( 'Recent Projects Section', 'luzuk-premium' ),
		'panel'   => 'lz_fitness_premium_home_panel',
	)
);
// ENABLE/DISABLE TEAM SECTION
$wp_customize->add_setting(
	'project_section_disable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'project_section_disable',
		array(
			'settings'      => 'project_section_disable',
			'section'       => 'project_section',
			'label'         => __( 'Disable Section', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk-premium' ),
				'off' => __( 'No', 'luzuk-premium' )
			)   
		)
	)
);
backgroundManager($wp_customize, 'project', 'project_section', $color='#f7f7f7');

$wp_customize->add_setting(
	'project_title_subtitle_heading',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
	)
);
$wp_customize->add_control(
	new lz_fitness_Customize_Heading(
		$wp_customize,
		'project_title_subtitle_heading',
		array(
			'settings'      => 'project_title_subtitle_heading',
			'section'       => 'project_section',
			'label'         => __( 'Section Title & Sub Text', 'luzuk-premium' ),
		)
	)
);
$wp_customize->add_setting(
	'project_title',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Recent Projects', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'project_title',
	array(
		'settings'      => 'project_title',
		'section'       => 'project_section', 
		'type'          => 'text',
		'label'         => __( 'Section Title', 'luzuk-premium' )
	)
);

// title color
addColorPalatOption($wp_customize, 'lz_fitness_project_HeadingColor', 'project_section', 'Section Title color', '#303030');


// title small color
addColorPalatOption($wp_customize, 'lz_fitness_projectsmallHeadingColor', 'project_section', 'Section Title small color', '#303030');

//title border
addColorPalatOption($wp_customize, 'lz_fitness_project_HeadingborderColor', 'project_section', 'Section Title border color', '#d3193e');

//sub text

$wp_customize->add_setting(
	'project_subtexttitle',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded by desire', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'project_subtexttitle',
	array(
		'settings'      => 'project_subtexttitle',
		'section'       => 'project_section', 
		'type'          => 'textarea',
		'label'         => __( 'Sub Text', 'luzuk-premium' )
	)
);

addColorPalatOption($wp_customize, 'project_SubTextColor', 'project_section', 'Section Sub Text color', '#6d6d6d');



$wp_customize->add_setting('project_npp_heading_img', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
$wp_customize->add_control(
	new lz_fitness_Info_Text( 
		$wp_customize,
		'project_npp_heading_img',
		array(
			'settings'		=> 'project_npp_heading_img',
			'section'		=> 'project_section',
			'label'			=> __( 'Note:', 'luzuk business' ),	
			'description'	=> __( 'Add Project images of equal height, recommend image height of size 280px', 'luzuk-premium' ),
		)
	)
);


$wp_customize->add_setting('project_npp_heading',array('sanitize_callback' => 'lz_fitness_sanitize_text'));
$wp_customize->add_control(
	new lz_fitness_Customize_Heading(
		$wp_customize,
		'project_npp_heading',
		array(
			'settings'      => 'project_npp_heading',
			'section'       => 'project_section',
			'label'         => __( 'Number Of project to show', 'luzuk-premium' ),
		)
	)
);    
$wp_customize->add_setting('project_npp_count',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => 5));
$wp_customize->add_control(
	'project_npp_count',
	array(
		'settings'      => 'project_npp_count',
		'section'       => 'project_section',
		'type'          => 'select',
		'label'         => __( 'Number of projects to show', 'luzuk-premium' ),
		'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
	)
);


// PROJECT PAGES
for( $i = 1; $i <= 12; $i++ ){
	$wp_customize->add_setting(
		'project_heading'.$i,
		array(
			'sanitize_callback' => 'lz_fitness_sanitize_text'
		)
	);
	$wp_customize->add_control(
		new lz_fitness_Customize_Heading(
			$wp_customize,
			'project_heading'.$i,
			array(
				'settings'      => 'project_heading'.$i,
				'section'       => 'project_section',
				'label'         => __( 'project', 'luzuk-premium' ).$i,
			)
		)
	);
	if(is_array($lzFitnessProjectSingleChoice)){
		$wp_customize->add_setting(
			'project_page'.$i,
			array(
				'sanitize_callback' => 'absint'
			)
		);
		$wp_customize->add_control(
			'project_page'.$i,
			array(
				'settings'      => 'project_page'.$i,
				'section'       => 'project_section',
				'type'=> 'select',
				'label'         => __( 'Select a Project', 'luzuk-premium' ),
				'choices' => $lzFitnessProjectSingleChoice,
			)
		);
	}else{
		$wp_customize->add_setting('project_section_lbl'.$i, array('sanitize_callback'=>'lz_fitness_sanitize_text'));
		$wp_customize->add_control(
			new lz_fitness_Info_Text( 
				$wp_customize,
				'project_section_lbl'.$i,
				array(
					'settings'		=> 'project_section_lbl'.$i,
					'section'		=> 'project_section',
					'label'			=> __( 'Note:', 'luzuk-premium' ),	
					'description'	=> __( '<strong>Changes will not reflect unless you select the project member.</strong> <br/>Please add the project from "Project menu" and then select project member to show information.', 'luzuk-premium' ),
				)
			)
		);
	}

}

//FEATURED PAGES
for( $i = 1; $i <= 1; $i++ ){

    $wp_customize->add_setting(
        'project_page_header'.$i,
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
//     $wp_customize->add_control(
//         new lz_fitness_Customize_Heading(
//             $wp_customize,
//             'project_page_header'.$i,
//             array(
//                 'settings'      => 'project_page_header'.$i,
//                 'section'       => 'project_section',
//                 'label'         => __( 'Project Overlay Button Text:', 'lz_fitness_premium' )
//             )
//         )
//     );
// $wp_customize->add_setting(
//     'lz_fitness_viewprojectbutton1',
//     array(
//         'sanitize_callback' => 'lz_fitness_sanitize_text',
//         'default'           => __( 'VIEW PROJECT' )
//     )
// );
// $wp_customize->add_control(
//     'lz_fitness_viewprojectbutton1',
//     array(
//         'settings'      => 'lz_fitness_viewprojectbutton1',
//         'section'       => 'project_section',
//         'type'          => 'text',
//         'label'         => __( 'Button Text', 'lz_fitness_premium' )
//     )
// );

}

addColorPalatOption($wp_customize, 'project_ProjecttitleColor', 'project_section', 'Project Title color', '#ffffff');

addColorPalatOption($wp_customize, 'project_ProjecttitlesamllColor', 'project_section', 'Project Small Title color', '#ffffff');

addColorPalatOption($wp_customize, 'project_ProjectoverlaybgsColor', 'project_section', 'Overlay Background color', '#1f4282');

addColorPalatOption($wp_customize, 'project_viewbtnColor', 'project_section', 'Button Icon color', '#ffffff');
addColorPalatOption($wp_customize, 'project_viewbtnhoverColor', 'project_section', 'Button Icon Hover color', '#000');

addColorPalatOption($wp_customize, 'project_buttBgColor', 'project_section', 'Button Background color', '#d31a3c');

addColorPalatOption($wp_customize, 'project_butthoverBgColor', 'project_section', 'Button Hover Background color', '#ffffff');

// lzCustomLable($wp_customize, 'lz_fitness_premium_aboutproject_lblbutton1display', 'project_section', 'Button Display & Text Setting:');
// // to show & hide another button
// $wp_customize->add_setting( 'aboutproject_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'aboutproject_button_display', array( 'label' => 'Button Display', 'section' => 'project_section', 'settings' => 'aboutproject_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button

// $wp_customize->add_setting(
//     'lz_fitness_aboutproject',
//     array(
//         'sanitize_callback' => 'lz_fitness_sanitize_text',
//         'default'           => __( 'All Projects' )
//     )
// );
// $wp_customize->add_control(
//     'lz_fitness_aboutproject',
//     array(
//         'settings'      => 'lz_fitness_aboutproject',
//         'section'       => 'project_section',
//         'type'          => 'text',
//         'label'         => __( 'Button Text', 'lz_fitness_premium' )
//     )
// );
// $wp_customize->add_setting('lz_fitness_header_aboutprojectlink',   array('default'=> 'add Button link here', 'sanitize_callback' => 'esc_url_raw'));
// $wp_customize->add_control('lz_fitness_header_aboutprojectlink',
//     array(
//         'settings'      => 'lz_fitness_header_aboutprojectlink',
//         'section'       => 'project_section',
//         'type'          => 'url',
//         'label'         => __( 'Button Url', 'lz_fitness_premium' )
//     )
// );


// TEAM SECTION END HERE 
// Heading color


// addColorPalatOption($wp_customize, 'project_btntextclrColor', 'project_section', 'Button Text color', '#fff');
// addColorPalatOption($wp_customize, 'project_btntextarrowclrColor', 'project_section', 'Button Arrow color', '#fff');
// addColorPalatOption($wp_customize, 'project_btnbgssclrColor', 'project_section', 'Button Background color', '#1cb9c8');

// addColorPalatOption($wp_customize, 'project_btntexthoverclrColor', 'project_section', 'Button Text Hover color', '#ffffff');
// addColorPalatOption($wp_customize, 'project_btntextarrowhoverclrColor', 'project_section', 'Button Arrow Hover color', '#1cb9c8');
// addColorPalatOption($wp_customize, 'project_btnbgsshoverclrColor', 'project_section', 'Button Background Hover color', '#3a3c3d');


