<?php

$lzFitnessSliderSingleChoice = getFitnessPostsType('slider');

// CREATING A SECTION IN CUSTOMIZER
$wp_customize->add_section(
	'lz_fitness_premium_slider_section',
	array(
		'title' => __( 'Slider Section', 'luzuk-premium' ),
        'panel' => 'lz_fitness_premium_home_panel',
		'priority' =>18
	)
);

// show content in slider
$wp_customize->add_setting(
	'lz_fitness_premium_slider_show_content',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
	)
);
$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_premium_slider_show_content',
		array(
			'settings'      => 'lz_fitness_premium_slider_show_content',
			'section'       => 'lz_fitness_premium_slider_section',
			'label'         => __( 'Hide Title and description on slider', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk-premium' ),
				'off' => __( 'No', 'luzuk-premium' )
			),
		)
	)
);

$wp_customize->add_setting('lz_fitness_premium_slider_section_lbl', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
$wp_customize->add_control(
	new lz_fitness_Info_Text( 
		$wp_customize,
		'lz_fitness_premium_slider_section_lbl',
		array(
			'settings'		=> 'lz_fitness_premium_slider_section_lbl',
			'section'		=> 'lz_fitness_premium_slider_section',
			'label'			=> __( 'Note:', 'luzuk-premium' ),	
			'description'	=> __( 'The Page featured image works as a slider banner and the title & content work as a slider caption. And you can add this from the Slider menu. <br/> Recommended Image Size: 1900X600', 'luzuk-premium' ),
		)
	)
);

// Slider Title color
addColorPalatOption($wp_customize, 'slider_overlaybgColor', 'lz_fitness_premium_slider_section', 'Slider Overlay Background Color', '#2e75b2');


lzCustomLable($wp_customize, 'slidersarea_Overlay', 'lz_fitness_premium_slider_section', 'Set Slider Overlay:');

$wp_customize->add_setting(
    'slider_areaOpacity',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0.2', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'slider_areaOpacity',
    array(
        'settings'      => 'slider_areaOpacity',
        'section'       => 'lz_fitness_premium_slider_section',
        'type'          => 'text',
        'label'         => __( 'Slider Overlay Opacity', 'luzuk-premium' )
    )
);




// Slider Title color
addColorPalatOption($wp_customize, 'slider_TitleColor', 'lz_fitness_premium_slider_section', 'Slider Title Color', '#fff');
// Slider Sub Title color
addColorPalatOption($wp_customize, 'slider_SubtitleColor', 'lz_fitness_premium_slider_section', 'Slider Sub Title Color', '#fff');

// Slider Button Text color
addColorPalatOption($wp_customize, 'slider_buttontextColor', 'lz_fitness_premium_slider_section', 'Slider Button Text Color', '#fff');
// Slider Button border color
addColorPalatOption($wp_customize, 'slider_buttonborderColor', 'lz_fitness_premium_slider_section', 'Slider Button Border Color', '#d31a3c');

addColorPalatOption($wp_customize, 'slider_buttonBgColor', 'lz_fitness_premium_slider_section', 'Slider Button Background Color', '#d31a3c');

// Slider Button Text hover color
addColorPalatOption($wp_customize, 'slider_buttontexthoverColor', 'lz_fitness_premium_slider_section', 'Slider Button Text Hover Color', '#fff');

// Slider Button Background hover color
addColorPalatOption($wp_customize, 'slider_buttonbghoverColor', 'lz_fitness_premium_slider_section', 'Slider Button Background Hover Color', '#1f4282');

// Slider Button border hover color
addColorPalatOption($wp_customize, 'slider_buttonborderhoverColor', 'lz_fitness_premium_slider_section', 'Slider Button Border hover Color', '#1f4282');

// Slider Prev Button border color
addColorPalatOption($wp_customize, 'slider_PrevbuttonborderColor', 'lz_fitness_premium_slider_section', 'Slider Prev / Next Button border Color', '#fff');

// Slider Prev Button border color
addColorPalatOption($wp_customize, 'slider_PrevbuttonborderColor', 'lz_fitness_premium_slider_section', 'Slider Prev / Next Button border Color', '#fff');
