<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">

	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link rel="preconnect" href="https://fonts.gstatic.com">
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

	<link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,600;0,700;0,800;1,300;1,400;1,600;1,700;1,800&display=swap" rel="stylesheet">
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>

	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<?php wp_head(); ?>
	
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'luzuk-premium' ); ?></a>
		<div id="loading-area"><div class="la-anim-10"></div></div>
		<!-- header -->
		<!-- #masthead -->
		<header class="site-header header-transparent header mo-left header-seo">
			<div class="clearfix">
				<div class="top-bar-head">
					<?php
						$facebook = get_theme_mod('luzuk_header_fb', '//facebook.com/');
						$twitter = get_theme_mod('luzuk_header_tw', '//twitter.com/');
						$instagram = get_theme_mod('luzuk_header_insta', '//www.instagram.com/');
						$pinterest = get_theme_mod('luzuk_header_pint', '//www.pinterest.com/');
						$youtube = get_theme_mod('luzuk_header_youtube', '//www.youtube.com/');

						$headr_phone = get_theme_mod('details_phone_no', '+ 124 569 89 09');
						$headr_emailid = get_theme_mod('headr_emailid', 'support@.email.com');

						$headr_middletxt = get_theme_mod('headr_middletxt', 'Just another Wordpress site'); 
						
					?>
					<div class="header-contact">
						<div class="header-contact-inn"></div>
					 	<div class="container">
							<div class="head-inn">
								<div class="col-md-3 col-sm-4 col-xs-12">
									<div class="header-text">
										<div class="heademail">
											<?php if($headr_emailid){ ?>
											<div class="col-md-1 col-sm-1 col-xs-1 pd-0 textcenter">
												<i class="fa fa-envelope"></i>
											</div>
											<div class="col-md-10 col-sm-11 col-xs-11 pd-0">
												<a href="mailto:<?php echo $headr_emailid;?>"><?php echo ($headr_emailid);  ?></a>
											</div>
											<?php } ?>
											<div class="clearfix"></div>
										</div>
									</div>
								</div>
								<div class="col-md-6 col-sm-4 col-xs-12 heaadermiddletxt">
									<?php if($headr_middletxt){ ?>
										<P><?php echo ($headr_middletxt);  ?></P>
									<?php } ?>
								</div>
								<div class="col-md-3 col-sm-4 col-xs-12">
									<div class="socialalign padding0">
										<div class="header-social-links">
											<?php if(!empty($facebook)){ ?>
												<a href="<?php echo $facebook ?>" target="_blank" title="Facebook"><span class="fa fa-facebook"></span></a>
											<?php }?>
											<?php if(!empty($twitter)){ ?>
												<a href="<?php echo $twitter ?>" target="_blank" title="Twitter"><span class="fa fa-twitter"></span></a>
											<?php }?>
											<?php if(!empty($instagram)){ ?>
												<a href="<?php echo $instagram ?>" target="_blank" title="instagram"><span class="fa fa-instagram"></span></a>
											<?php }?>
											<?php if(!empty($pinterest)){ ?>
												<a href="<?php echo $pinterest ?>" target="_blank" title="pinterest"><span class="fa fa-pinterest"></span></a>
											<?php }?>
											<?php if(!empty($youtube)){ ?>
												<a href="<?php echo $youtube ?>" target="_blank" title="youtube"><span class="fa fa-youtube"></span></a>
											<?php }?>
										</div>	
										<div class="clearfix"></div>
									</div>
								</div>
								<div class="clearfix"></div>
							</div>
							<div class="clearfix"></div>
						</div> 
						<div class="clearfix"></div>
					</div>
					<div class="clearfix"></div>
				<div class="bottom-header ">
					<div class="row row-eq-height ">
						<div class="container">
						  <div class="header-b row">
							<div class="header-left col-md-3 col-sm-6 col-xs-9 logo">
								<div class="inside-full-height">
									<?php 
								
									if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
										$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
									}
									if( get_theme_mod('pages_logoTpadding',true) ) {
										$pages_logoTpadding = 'padding-top:'.esc_attr(get_theme_mod('pages_logoTpadding')).';';
									}
									if( get_theme_mod('pages_logoBpadding',true) ) {
										$pages_logoBpadding = 'padding-bottom:'.esc_attr(get_theme_mod('pages_logoBpadding')).';';
									}
									if( get_theme_mod('pages_logoLpadding',true) ) {
										$pages_logoLpadding = 'padding-left:'.esc_attr(get_theme_mod('pages_logoLpadding')).';';
									}
									if( get_theme_mod('pages_logoRpadding',true) ) {
										$pages_logoRpadding = 'padding-right:'.esc_attr(get_theme_mod('pages_logoRpadding')).';';
									}

								?>
					<!-- website logo -->
								<div class="logo-header mostion">
									<?php 
									if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
										the_custom_logo();
								else : 
									if ( is_front_page() ) : ?>
										<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php else : ?>
											<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php endif; ?>
									<?php endif; ?>
								</div> 
								 
					<!-- nav toggle button -->
								<div class="resp_header_logo">
									<?php 
									if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
										the_custom_logo();
								else : 
									if ( is_front_page() ) : ?>
										<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php else : ?>
											<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php endif; ?>
										<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
									<?php endif; ?>
								</div>
							</div>
						</div>

						<div class="header-right col-md-7 col-sm-6 col-xs-3">
							<!-- <div class="header-right-inn"></div> -->
							<div class="hd-b-area ">
								<div class="row ">
									<div class="inner-nav-clip pd-0">	
									 <div class="head-menu">
									  <div class="inside-full-height">
										<div class="site-navigation ">
					                        <div class="hamburger-menus">
					                            <span></span>
					                            <span></span>
					                            <span></span>
					                            <span></span>
					                            <span></span>
					                            <span></span>
					                            <span></span>
					                            <span></span>
					                            <span></span>
					                        </div>
							                <nav class="navigation">
						                        <div class="overlaybg"></div>
						                        <div class="menu-wrapper">
						                            <div class="menu-content">
						                                <?php
						                                    if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
						                                        wp_nav_menu ( array(
						                                            'menu_class' => 'mainmenu ht-clearfix',
						                                            'container'=> 'ul',
						                                            'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
						                                            'theme_location' => 'primary',  
						                                        )); 
						                                    } else {
						                                        wp_nav_menu ( array(
						                                            'menu_class' => 'mainmenu ht-clearfix',
						                                            'container'=> 'ul',
						                                            'theme_location' => 'primary',  
						                                        )); 
						                                    }
						                                ?>
						                            </div> <!-- /.hours-content-->
												<div class="clearfix"></div>
						                        </div>
						                        <div class="headenquiry">

													<?php
														$headerinquirytitle = get_theme_mod('luzuk_headermain_headerinquirytitle', 'Get a Quote'); 
														$headerinquiry = get_theme_mod('luzuk_header_headerinquiry', 'add link here');
														?>
														<?php if(!empty($headerinquiry)){ ?>
															<a href="<?php echo $headerinquiry ?>" title="headerinquiry"><?php echo ($headerinquirytitle);  ?><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
															<span></span>
													<?php }?> 
												</div>
												<div class="clearfix"></div>
						                    </nav>
			   							 	<div class="clearfix"></div>
											</div><!--  /.site-navigation -->
										</div>
									 </div>
									</div>
									<div class="clearfix"></div>
								</div>
								<div class="clearfix"></div>
							</div>
							<div class="clearfix"></div>	
						</div>
						<div class="col-md-2 col-sm-2 col-xs-12 pd-0 mobnone">
							<?php if( get_theme_mod('cds_button_display','show' ) == 'show') :?>
							<div class="headenquiry">
							<?php
								$headerinquirytitle = get_theme_mod('luzuk_headermain_headerinquirytitle', 'Get a Quote'); 
								$headerinquiry = get_theme_mod('luzuk_header_headerinquiry', 'add link here');
								?>
								<?php if(!empty($headerinquiry)){ ?>
									<a href="<?php echo $headerinquiry ?>" title="headerinquiry"><?php echo ($headerinquirytitle);  ?><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
								<?php }?> 
							</div>
						<?php endif ?>
						</div>
						<div class="clearfix"></div>
					</div>
					</div>
						<div class="clearfix"></div>
				  	</div>
					<div class="clearfix"></div>
			</div>
				</div>
				<div class="clearfix"></div>
			</div>			
			<div class="clearfix"></div>
		</header>
	</div>
