<?php 
    $wp_customize->add_section(
        'about_section',
        array(
            'title' => __( 'About Section', 'Luzuk' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'about_section_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'about_section_disable',
            array(
                'settings'      => 'about_section_disable',
                'section'       => 'about_section',
                'label'         => __( 'Disable Section', 'Luzuk' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'Luzuk' ),
                    'off' => __( 'No', 'Luzuk' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'about', 'about_section', $color='#fff', get_template_directory_uri().'/images/abtbg.jpg', 'color');


lzCustomLable($wp_customize, 'AboutDoctorSectionPadding', 'about_section', 'Section Padding');

$wp_customize->add_setting(
    'aboutTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'aboutTpadding',
    array(
        'settings'      => 'aboutTpadding',
        'section'       => 'about_section',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'Luzuk' )
    )
);
$wp_customize->add_setting(
    'aboutBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'aboutBpadding',
    array(
        'settings'      => 'aboutBpadding',
        'section'       => 'about_section',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'Luzuk' )
    )
);

lzCustomLable($wp_customize, 'AboutSectiontitle', 'about_section', 'Section Heading');

$wp_customize->add_setting(
        'about_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'About Movie Studio', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'about_title',
        array(
            'settings'      => 'about_title',
            'section'       => 'about_section',
            'type'          => 'text',
            'label'         => __( 'Section Heading', 'Luzuk' )
        )
    );
addColorPalatOption($wp_customize, 'about_TitleColor', 'about_section', 'Section Heading Color', '#2e3d62');

addColorPalatOption($wp_customize, 'about_headbrd', 'about_section', 'Section Heading Border Color', '#fd8455');

$wp_customize->add_setting(
        'about_content',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat.', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'about_content',
        array(
            'settings'      => 'about_content',
            'section'       => 'about_section',
            'type'          => 'textarea',
            'label'         => __( 'Section Content', 'Luzuk' )
        )
    );

addColorPalatOption($wp_customize, 'about_ContentColor', 'about_section', 'Section Content Color', '#666e82');

//=============================iconBox=====================================
$wp_customize->add_setting('about_npp_heading1',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_npp_heading1',
        array(
            'settings'      => 'about_npp_heading1',
            'section'       => 'about_section',
            'label'         => __( 'Number Of About Plans', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('aboutus_npp_icncount',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 2));
$wp_customize->add_control(
    'aboutus_npp_icncount',
    array(
        'settings'      => 'aboutus_npp_icncount',
        'section'       => 'about_section',
        'type'          => 'select',
        'label'         => __( 'Number of About plan to show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6)
    )
);

//ABOUT PAGES
for( $i = 1; $i <= 6; $i++ ){
    $wp_customize->add_setting(
        'aboutus_header1'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'aboutus_header1'.$i,
            array(
                'settings'      => 'aboutus_header1'.$i,
                'section'       => 'about_section',
                'label'         => __( 'About Page Icon  ', 'luzuk-premium' ).$i
            )
        )
    );

     $wp_customize->add_setting(
        'about_page_icon1'.$i,
        array(
            'default'           => 'fa fa-diamond',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'about_page_icon1'.$i,
            array(
                'settings'      => 'about_page_icon1'.$i,
                'section'       => 'about_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );

lzAddElement($wp_customize, 'about_page_title1'.$i, 'about_section', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Business Strategy');  
}

// ============================textbox===================================

$wp_customize->add_setting('aboutus_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'aboutus_npp_heading',
        array(
            'settings'      => 'aboutus_npp_heading',
            'section'       => 'about_section',
            'label'         => __( 'Number Of About Plans', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('aboutus_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 1));
$wp_customize->add_control(
    'aboutus_npp_count',
    array(
        'settings'      => 'aboutus_npp_count',
        'section'       => 'about_section',
        'type'          => 'select',
        'label'         => __( 'Number of About plan to show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

//ABOUT PAGES
for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'aboutus_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'aboutus_header'.$i,
            array(
                'settings'      => 'aboutus_header'.$i,
                'section'       => 'about_section',
                'label'         => __( 'About Page Text ', 'luzuk-premium' ).$i
            )
        )
    );

     $wp_customize->add_setting(
        'aboutus_page_icon'.$i,
        array(
            'default'           => 'fa fa-check',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'aboutus_page_icon'.$i,
            array(
                'settings'      => 'aboutus_page_icon'.$i,
                'section'       => 'about_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );

lzAddElement($wp_customize, 'aboutus_page_title'.$i, 'about_section', $type = 'textarea', $label="Title", $callback ='luzuk_sanitize_text', $default='Refreshing to get such a perstional touch.');  
}

addColorPalatOption($wp_customize, 'about_iconclr', 'about_section', 'Section Icon Color', '#fd8455');
addColorPalatOption($wp_customize, 'about_icontxtclr', 'about_section', 'Section Icon Text Color', '#2e3d62');
addColorPalatOption($wp_customize, 'about_iconhvclr', 'about_section', 'Section Icon Hover Color', '#000');
addColorPalatOption($wp_customize, 'about_icontxthvclr', 'about_section', 'Section Icon Text Hover Color', '#fd8455');

lzCustomLable($wp_customize, 'buttontextsettings', 'about_section', 'Button Text, Button Link & Its Colors:');

// button
$wp_customize->add_setting( 'about_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'about_button_display', array( 'label' => 'About Button Display', 'section' => 'about_section', 'settings' => 'about_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) );

$wp_customize->add_setting(
        'about_button1',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Explore All', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'about_button1',
        array(
            'settings'      => 'about_button1',
            'section'       => 'about_section',
            'type'          => 'text',
            'label'         => __( 'Add Button Text Here', 'Luzuk' )
        )
    );
$wp_customize->add_setting('about_link',   array('default'=> 'add Button link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('about_link',
    array(
        'settings'      => 'about_link',
        'section'       => 'about_section',
        'type'          => 'url',
        'label'         => __( 'Add Link For Button:', 'Luzuk' )
    )
);    

addColorPalatOption($wp_customize, 'about_ButtonTextColor', 'about_section', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'about_ButtonTexthvColor', 'about_section', 'Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'about_ButtonbgColor', 'about_section', 'Button Background Color', '#fd8455');

addColorPalatOption($wp_customize, 'about_ButtonbghvColor', 'about_section', 'Button Background Hover Color', '#2e3d62');

// end to show & hide button


//section Image

$wp_customize->add_setting(
        'about_image5_heading',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_image5_heading',
        array(
            'settings'      => 'about_image5_heading',
            'section'       => 'about_section',
            'label'         => __( 'About Section Right Image', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'about_image5',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_image5',
        array(
            'section' => 'about_section',
            'settings' => 'about_image5',
            'description' => __('Recommended Image Size: 600X725px', 'luzuk-premium')
        )
    )
);

addColorPalatOption($wp_customize, 'ab_imgbhvcolor', 'about_section', 'Section Image Hover Color', '#fd8455');

$wp_customize->add_setting(
    'abicntxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'For any queriey & services', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'abicntxt',
    array(
        'settings'      => 'abicntxt',
        'section'       => 'about_section',
        'type'          => 'textarea',
        'label'         => __( 'Section Icon Text', 'Luzuk' )
    )
);
addColorPalatOption($wp_customize, 'abicntxtcolor', 'about_section', 'Section Icon Text Color', '#fff');

$wp_customize->add_setting(
    'abimgbxtxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+123 456 7890', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'abimgbxtxt',
    array(
        'settings'      => 'abimgbxtxt',
        'section'       => 'about_section',
        'type'          => 'text',
        'label'         => __( 'Section Image Box Phone', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'abimgbxbgcolor', 'about_section', 'Section Image Box Background Color', '#fd8455');

addColorPalatOption($wp_customize, 'abimgbxtxtcolor', 'about_section', 'Section Image Box Phone Color', '#fff');

addColorPalatOption($wp_customize, 'abicncolor', 'about_section', 'Section Image Box Icon Color', '#fff');

addColorPalatOption($wp_customize, 'abicnhvcolor', 'about_section', 'Section Image Box Icon Hover Color', '#2e3d62');

addColorPalatOption($wp_customize, 'ab_icnbgcolor', 'about_section', 'Section Image Box Icon Background Color', '#2e3d62');

addColorPalatOption($wp_customize, 'ab_icnbghvcolor', 'about_section', 'Section Image Box Icon Background Color', '#fff');

