<?php 
/**
 * Createing an newvideo pannel for customizer
 *
 */

$categories = get_categories(array('hide_empty' => 0));
foreach ($categories as $category) {
    $cat[$category->term_id] = $category->cat_name;
}
//newvideo START HERE 
/*============newvideo PANEL============*/
$wp_customize->add_section(
	'newvideo_area',
	array(
		'title'         => __( 'Newest Video Section', 'luzuk' ),
		'panel'   => 'luzuk_premium_home_panel',
	)
);
// ENABLE/DISABLE newvideo SECTION
$wp_customize->add_setting(
	'newvideo_area_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'newvideo_area_disable',
		array(
			'settings'      => 'newvideo_area_disable',
			'section'       => 'newvideo_area',
			'label'         => __( 'Disable Section', 'luzuk' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk' ),
				'off' => __( 'No', 'luzuk' )
			)   
		)
	)
);


backgroundManager($wp_customize, 'newvideo', 'newvideo_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'newvideo_padding_lbl', 'newvideo_area', 'Section Padding');

$wp_customize->add_setting(
    'sec_newvideosectionTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'sec_newvideosectionTpadding',
    array(
        'settings'      => 'sec_newvideosectionTpadding',
        'section'       => 'newvideo_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'Luzuk' )
    )
);
$wp_customize->add_setting(
    'sec_newvideosectionBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '9em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'sec_newvideosectionBpadding',
    array(
        'settings'      => 'sec_newvideosectionBpadding',
        'section'       => 'newvideo_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'Luzuk' )
    )
);


$wp_customize->add_setting(
    'newvideo_title_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'newvideo_title_subtitle_heading',
        array(
            'settings'      => 'newvideo_title_subtitle_heading',
            'section'       => 'newvideo_area',
            'label'         => __( 'Section Title & Text', 'luzuk-premium' ),
        )
    )
);
   

$wp_customize->add_setting(
        'luzuk_newvideo_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Newest Videos', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'luzuk_newvideo_title',
        array(
            'settings'      => 'luzuk_newvideo_title',
            'section'       => 'newvideo_area',
            'type'          => 'text',
            'label'         => __( 'Section Heading', 'Luzuk' )
        )
    );
addColorPalatOption($wp_customize, 'newvideoarea_sectitle_color', 'newvideo_area', 'Heading Color ', '#2e3d62');
addColorPalatOption($wp_customize, 'newvideoarea_sectitleborder_color', 'newvideo_area', 'Heading Border Color ', '#fd8455');
$wp_customize->add_setting(
        'newvideo_subtitle',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has industrys. Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'newvideo_subtitle',
        array(
            'settings'      => 'newvideo_subtitle',
            'section'       => 'newvideo_area',
            'type'          => 'textarea',
            'label'         => __( 'Section Text', 'Luzuk' )
        )
    );

addColorPalatOption($wp_customize, 'newvideoarea_subtext_clr', 'newvideo_area', 'Section Text Color ', '#838a9b');


lzCustomLable($wp_customize, 'newvideo_sec', 'newvideo_area', 'Newest Videos:');

addColorPalatOption($wp_customize, 'newvideoarea_contentboxbg_clr', 'newvideo_area', 'Section Content Box Background Color ', '#2f3d62');
addColorPalatOption($wp_customize, 'newvideoarea_playiconbg_clr', 'newvideo_area', 'Section Play Icon Background Color ', '#fff');
addColorPalatOption($wp_customize, 'newvideoarea_playicon_clr', 'newvideo_area', 'Section Play Icon Color ', '#2b3a65');
addColorPalatOption($wp_customize, 'newvideoarea_wishiconbg_clr', 'newvideo_area', 'Section Wish Icon Background Color ', '#fff');
addColorPalatOption($wp_customize, 'newvideoarea_wishicon_clr', 'newvideo_area', 'Section Wish Icon Color ', '#f27f2d');
addColorPalatOption($wp_customize, 'newvideoarea_videotitle_clr', 'newvideo_area', 'Section Title Color ', '#f9fefd');
addColorPalatOption($wp_customize, 'newvideoarea_othervideotitle_clr', 'newvideo_area', 'Section Other Videos Title Color ', '#2f3d62');

addColorPalatOption($wp_customize, 'newvideoarea_videocategory_clr', 'newvideo_area', 'Section Category Color ', '#e8f3f7');

addColorPalatOption($wp_customize, 'newvideoarea_sliderarrow_clr', 'newvideo_area', 'Slider Arrow Color ', '#090709');
addColorPalatOption($wp_customize, 'newvideoarea_sliderarrowbg_clr', 'newvideo_area', 'Slider Arrow Background Color ', '#fff');

addColorPalatOption($wp_customize, 'newvideoarea_sliderarrowhover_clr', 'newvideo_area', 'Slider Arrow Hover Color ', '#fff');
addColorPalatOption($wp_customize, 'newvideoarea_sliderarrowbghover_clr', 'newvideo_area', 'Slider Arrow Background Hover Color ', '#2f3d61');

lzCustomLable($wp_customize, 'featuredareapost_category', 'newvideo_area', 'Post Video Category Setting');

// // ADDING THE CATEGORY TO SELECT
$choices = getPostCategories($isObject = false, $id=0, $isParents = 0);

lzCheckBoxElement($wp_customize, 'post_videonew_categories', 'newvideo_area', $choices, $default=0, $label=__('Please select the Categories to show', 'luzuk-premium'));

addColorPalatOption($wp_customize, 'newvideoarea_imghovericon_clr', 'newvideo_area', 'Video Image Hover Icon Color ', '#f27f2d');


lzCustomLable($wp_customize, 'newvideo_tpbutton', 'newvideo_area', 'Button For Section');
// Top button
$wp_customize->add_setting( 'newvideo_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'newvideo_button_display', array( 'label' => 'Section Button Display', 'section' => 'newvideo_area', 'settings' => 'newvideo_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) );

$wp_customize->add_setting(
        'newvideo_button1',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Explore All', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'newvideo_button1',
        array(
            'settings'      => 'newvideo_button1',
            'section'       => 'newvideo_area',
            'type'          => 'text',
            'label'         => __( 'Add Button Text Here', 'Luzuk' )
        )
    );
$wp_customize->add_setting('newvideo_link',   array('default'=> 'add Button link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('newvideo_link',
    array(
        'settings'      => 'newvideo_link',
        'section'       => 'newvideo_area',
        'type'          => 'url',
        'label'         => __( 'Add Link For Button:', 'Luzuk' )
    )
);    
addColorPalatOption($wp_customize, 'newvideopg_btnbgClr', 'newvideo_area', 'Section Button Background Color ', '#fd8455');

addColorPalatOption($wp_customize, 'newvideopg_btnbghvClr', 'newvideo_area', 'Section Button Background Hover Color ', '#2e3d62');

addColorPalatOption($wp_customize, 'newvideopg_btntxtClr', 'newvideo_area', 'Section Button Text & Icon Color ', '#fff');

addColorPalatOption($wp_customize, 'newvideopg_btntxthvClr', 'newvideo_area', 'Section Button Text & Icon Hover Color ', '#fff');

