<?php  

$luzukSliderSingleChoice = getFitnessPostsType('slider');
$wp_customize->add_section(
	'slider_section',
	array(
		'title' => __( 'Slider Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel',
		'priority' =>18
	)
);
$wp_customize->add_setting(
	'slider_section_show_content',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'slider_section_show_content',
		array(
			'settings'      => 'slider_section_show_content',
			'section'       => 'slider_section',
			'label'         => __( 'Hide Title and description on Slider', 'Luzuk' ),
			'on_off_label'  => array(
				'on' => __( 'No', 'Luzuk' ),
				'off' => __( 'Yes', 'Luzuk' )
			),
		)
	)
);
$wp_customize->add_setting('slider_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Info_Text( 
		$wp_customize,
		'slider_section_lbl',
		array(
			'settings'		=> 'slider_section_lbl',
			'section'		=> 'slider_section',
			'label'			=> __( 'Note:', 'Luzuk' ),	
			'description'	=> __( 'The page featured image works as a banner and the title & content work as a slider caption. You can add this from the Slider menu. <br/> Recommended Image Size: 1140X768', 'Luzuk' ),
		)
	)
);

lzCustomLable($wp_customize, 'slidersarea_Overlay', 'slider_section', 'Set Overlay:');

$wp_customize->add_setting(
    'slider_areaOpacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.2', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'slider_areaOpacity',
    array(
        'settings'      => 'slider_areaOpacity',
        'section'       => 'slider_section',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'slider_bg_color', 'slider_section', 'Slider Overlay Color', '#000');

lzCustomLable($wp_customize, 'luzuk_sliderotherclrs', 'slider_section', 'Slider Colors:');


addColorPalatOption($wp_customize, 'slider_titleColor', 'slider_section', 'Slider Title Color', '#fff');

addColorPalatOption($wp_customize, 'slider_titlebColor', 'slider_section', 'Slider Sub Title Color', '#fff');

addColorPalatOption($wp_customize, 'slider_SubtitleColor', 'slider_section', 'Slider Text Color', '#fff');

// ======================btn one=========================================

addColorPalatOption($wp_customize, 'slider_1btnclr', 'slider_section', 'Slider Button One Background Color', '#fd8455');

addColorPalatOption($wp_customize, 'slider_1btnhvclr', 'slider_section', 'Slider Button One Background Hover Color', '#2e3d62');

addColorPalatOption($wp_customize, 'slider_1btntxtclr', 'slider_section', 'Slider Button One Text & icon Color', '#fff');

addColorPalatOption($wp_customize, 'slider_1btntxthvclr', 'slider_section', 'Slider Button One Text & icon Hover Color', '#fd8455');

// ======================btn second=========================================

addColorPalatOption($wp_customize, 'slider_2brdclr', 'slider_section', 'Slider Second Button Border Color', '#fff');

addColorPalatOption($wp_customize, 'slider_2btnhvclr', 'slider_section', 'Slider Second Button Background Hover Color', '#fd8455');

addColorPalatOption($wp_customize, 'slider_2btnTxtclr', 'slider_section', 'Slider Second Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'slider_2btnTxthvclr', 'slider_section', 'Slider Second Button Text Hover Color', '#2e3d62');

addColorPalatOption($wp_customize, 'slider_slidebtnicnclr', 'slider_section', 'sliding Button Icon Color', '#000');

addColorPalatOption($wp_customize, 'slider_slidebtnicnhvclr', 'slider_section', 'sliding Button Icon Hover Color', '#fff');

addColorPalatOption($wp_customize, 'slider_slidebtnbgclr', 'slider_section', 'sliding Button Background Color', '#fff');

addColorPalatOption($wp_customize, 'slider_slidebtnbghvclr', 'slider_section', 'sliding Button Background Hover Color', '#fd8455');