<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package LZ Fitness Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css?family=Roboto:700" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Roboto+Condensed:300,300i,400,400i,700,700i" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i,800,800i" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Playfair+Display:400,400i,700,700i,900,900i&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Lobster&amp;subset=cyrillic,cyrillic-ext,latin-ext,vietnamese" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Dancing+Script" rel="stylesheet">
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>

	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	  <script type="text/javascript">
	$(document).ready(function(){
		$("#formButton").click(function(){
			$("#form1").toggle();
		});
	});
 </script>

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <div class="main-container">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'luzuk-premium' ); ?></a>
		<header id="ht-masthead" class="ht-site-header">
			<div class="maintop-header">
				<div class="container">
					<div class="col-md-5 col-sm-6 col-xs-6 padding0">
						<?php 
							$phone = get_theme_mod('headermain_phone', '012 345 6789');
							$email = get_theme_mod('headermain_email', 'info@youremailhere.com');	

						?>
						<ul>
						<li class="headicon mailto">
							<?php if($email){ ?>
							<i class="fa fa-envelope" aria-hidden="true"></i>
							<a href="mailto:<?php echo $email;?>"><?php echo $email ;?></a>
							<?php } ?>
						</li>
						<li class="headicon">
							<?php if($phone){ ?>
							<i class="fa fa-phone" aria-hidden="true"></i><?php echo ($phone); ?>
							<?php } ?>
						</li>
						<div class="clearfix"></div>
					</ul>
						
					</div>
					<div class="col-md-7 col-sm-6 col-xs-6 padding0">
						
						<?php

								$facebook = get_theme_mod('header_fb', '//facebook.com/');
								$twitter = get_theme_mod('header_tw', '//twitter.com/');
								$linkedIn = get_theme_mod('header_in', '//linkedin.com/');
								$googlePlus = get_theme_mod('header_it', '//plus.google.com/');
								$youtube = get_theme_mod('header_yt', '//www.youtube.com/');
						?>
							<?php if($facebook || $twitter || $linkedIn || $googlePlus || $youtube ){ ?>

							<div class="header-social-links">
									<?php if(!empty($facebook)){ ?>
										<a href="<?php echo $facebook ?>" target="_blank" title="Facebook"><span class="fa fa-facebook"></span></a>
									<?php }?>
									<?php if(!empty($twitter)){ ?>
										<a href="<?php echo $twitter ?>" target="_blank" title="Twitter"><span class="fa fa-twitter"></span></a>
									<?php }?>
									<?php if(!empty($googlePlus)){ ?>
									<a href="<?php echo $googlePlus ?>" target="_blank" title="Google Plus"><span class="fa fa-google-plus"></span></a>
									<?php }?>
									<?php if(!empty($linkedIn)){ ?>
										<a href="<?php echo $linkedIn ?>" target="_blank" title="Linked In"><span class="fa fa-linkedin"></span></a>
									<?php }?>
									
								<?php if(!empty($youtube)){ ?>
									<a href="<?php echo $youtube ?>" target="_blank" title="youtube"><span class="fa fa-youtube"></span></a>
								<?php }?>
									
								</div>
						<?php }?>

					</div>
				</div>
					<div class="clearfix"></div>
			</div>
			<div class="clearfix"></div>
			<div class="top-header">
				<div class="container">
				<div class="row">
					

					<div class="col-md-4 col-sm-12 logomainboxx">
						<?php 
							if( get_theme_mod('pages_logoTmargin',true) ) {
				                $pages_logoTmargin = 'margin-top:'.esc_attr(get_theme_mod('pages_logoTmargin')).';';
				            }
				            if( get_theme_mod('pages_logoBmargin',true) ) {
				                $pages_logoBmargin = 'margin-bottom:'.esc_attr(get_theme_mod('pages_logoBmargin')).';';
				            }
				            if( get_theme_mod('pages_logoLmargin',true) ) {
				                $pages_logoLmargin = 'margin-left:'.esc_attr(get_theme_mod('pages_logoLmargin')).';';
				            }
				            if( get_theme_mod('pages_logoRmargin',true) ) {
				                $pages_logoRmargin = 'margin-right:'.esc_attr(get_theme_mod('pages_logoRmargin')).';';
				            }
	 					?>
						<div class="logobox"  style="<?php echo esc_attr($pages_logoTmargin); ?>" "<?php echo esc_attr($pages_logoBmargin); ?>" "<?php echo esc_attr($pages_logoLmargin); ?>" "<?php echo esc_attr($pages_logoRmargin); ?>">
						<?php 
						if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
							the_custom_logo();
					else : 
						if ( is_front_page() ) : ?>
							<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php else : ?>
								<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
							<?php endif; ?>
							<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
						<?php endif; ?>
						<!-- .site-branding -->
					</div>
					<div class="clearfix"></div>
					</div>


					<div class="col-md-8 col-sm-12 padding0">
							<div class="nav-upper col-md-12 col-sm-12 padding0">
									<nav id="ht-site-navigation" class="ht-main-navigation">
										<div class="clearfix">
											<div class="toggle-bar"><span><i class="fa fa-bars" aria-hidden="true"></i></span></div>
											<?php 
											wp_nav_menu( array( 
												'theme_location' => 'primary', 
												'container_class' => 'ht-menu clearfix' ,
												'menu_class' => 'ht-clearfix',
												'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
											) ); 
											?>
										</div>

									</nav><!-- #ht-site-navigation -->
								<div class="clearfix"></div>
							</div>
					</div>
		</div>
	</div>
</div>
		<div class="clearfix"></div>

			</header><!-- #masthead -->
	</div>
