<?php

/**
 * Liting the feature details 
 * @param : int $pageId default is null
 * @param : boolean $isCustomizer default is false, if set to true will get the data stored with customizer
 * @param : int $i default is null, it will used as a iteration for data with customizer, this will be used only if the $isCustomizer is set to true.
 * @return: Text $text
 */
function featuredShortCode($pageId = null, $isCustomizer = false, $i = null) {
    ob_start();

    $args = array('post_type' => 'our-services');
    if (!empty($pageId)) {
        $args['page_id'] = absint($pageId);
    }
    $args['posts_per_page'] = -1;
    $colCls = '';
    // if($isCustomizer == true){
    $cols = get_theme_mod('services_npp_count', 1);
    $cols++;
    switch($cols){
        case 1:
            $colCls = 'col-md-12 col-sm-12 col-xs-12';
            break;
        case 2:
            $colCls = 'col-md-6 col-sm-6 col-xs-12';
            break;
            break;
        default:
            $colCls = 'col-md-6 col-sm-6 col-xs-12';
            break;
    }
                
    // }
    $text = '';
    $query = new WP_Query($args);
    if ($query->have_posts()):
        $postN = 0;

        while ($query->have_posts()) : $query->the_post();
            $lz_fitness_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'total-features-thumb');

            

            if ($isCustomizer === true) {
                $feature_designation = get_theme_mod('feature_designation' . $i);
            }
            $post = get_post();
            //designation
            $designation = get_post_meta($post->ID, 'designation', false);
            $feature_designation = !empty($designation[0]) ? $designation[0] : '';
           
            ?> 
            <div class="row">
            <div class="<?php echo $colCls; ?> fpost">
                        
                <div class="featured-post-box wow fadeInLeft">
                   
                   
                       <a class="secondry-bg" href="<?php echo esc_url(get_permalink()); ?>">
                         <div class="featured-img">
                            <div class="blankbox"></div>
                            <div class="highlightbox"></div>
                            <?php
                            if (has_post_thumbnail()) {
                                $image_url = $lz_fitness_image[0];
                            } else {
                                $image_url = get_template_directory_uri() . '/images/team-thumb.png';
                            }
                            ?>                  
                            <img class="secondry-bg img-responsive" src="<?php echo esc_url($image_url); ?>" alt="<?php the_title(); ?>" />
                            
                        </div>
                        </a>
                             
                        <div class="featured-post">
                        <div class="featuredcontent-data">
                               <h5 class="text"><?php the_title(); ?></h5> 
                                <div class="clearfix"></div> 
                                <p>
                                    <?php

                                    if(has_excerpt()){
                                      echo get_the_excerpt();
                                     }else{
                                      echo lz_fitness_excerpt( get_the_content() , 100 );
                                     } 
                                    ?>
                                </p>

                                 <?php if( get_theme_mod('features_button_display','show' ) == 'show') :
                                    ?>
                                    <div class="features-button"> 
                                        <?php
                                        $servicebutton = get_theme_mod('servicebutton', 'READ MORE');
                                        ?>
                                        <a href="<?php echo esc_url(get_permalink()); ?>" class="serbtn servicesbtn"> 
                                            <?php echo $servicebutton; ?><i class="fa fa-plus" aria-hidden="true"></i>
                                        </a>   

                                    </div>
                                <?php endif ?>
                                <div class="clearfix"></div> 
                        </div>
                </div> 
                           
                <div class="clearfix"></div>          
            </div>
            <script>
  jQuery.noConflict();
  $(function(){
    function featuredpostboxHeight(){
      var ht = 0;
      $('#innerpage-box .featured-post-box').each(function(i){
        var tHt = $(this).height();
        if(ht<tHt){
          ht=tHt;
        }
      });
      $('#innerpage-box .featured-post-box').height(ht+'px');
    }
    featuredpostboxHeight();
  });
  $( window ).resize(function(){
    featuredpostboxHeight();
  });
</script>
        </div>
        <?php
    endwhile;
    $text = ob_get_contents();
    ob_clean();
endif;
wp_reset_postdata();
return $text;
}

    add_shortcode('SERVICES', 'featuredShortCode');


    