<?php

$wp_customize->add_panel(
	'lz_fitness_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'luzuk-premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'luzuk-premium' ),
	'panel' => 'lz_fitness_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'luzuk-premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'luzuk-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );


//HEADER LOGO MARGIN SETTINGS
$wp_customize->add_section(
	'lz_fitness_headerlogo_settings',
	array(
		'title' => __( 'Header Logo Margin Settings', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_headerlogo_margin', 'lz_fitness_headerlogo_settings', ' Site Header Logo Margin:');


$wp_customize->add_setting(
	'pages_logoTmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '10px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoTmargin',
	array(
		'settings'      => 'pages_logoTmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Top Margin', 'luzuk-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoBmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '10px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoBmargin',
	array(
		'settings'      => 'pages_logoBmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Bottom Margin', 'luzuk-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoLmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoLmargin',
	array(
		'settings'      => 'pages_logoLmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Left Margin', 'luzuk-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoRmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoRmargin',
	array(
		'settings'      => 'pages_logoRmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Right Margin', 'luzuk-premium' )
	)
);


//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image', 'luzuk-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'luzuk-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );



//HEADER SETTINGS
$wp_customize->add_section(
	'header_settings',
	array(
		'title' => __( 'Header Settings', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

	//ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
	'lz_fitness_sticky_header_enable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);

$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_sticky_header_enable',
		array(
			'settings'		=> 'lz_fitness_sticky_header_enable',
			'section'		=> 'header_settings',
			'label'			=> __( 'Sticky Header', 'luzuk-premium' ),
			'on_off_label' 	=> array(
				'on' => __( 'Enable', 'luzuk-premium' ),
				'off' => __( 'Disable', 'luzuk-premium' )
			)	
		)
	)
);

$sectionHeader = 'header_settings';


lzCustomLable($wp_customize, 'header_clrlblbgTxt', 'header_settings', 'Set Header Background Colors:');

//Set top header colour
addColorPalatOption($wp_customize, 'topheader_color', 'header_settings', 'Top Header Color', '#191919');

//Set midle header colour
addColorPalatOption($wp_customize, 'midleheader_color', 'header_settings', 'Midle Header Color', '#fff');

$wp_customize->add_setting(
	'headermain_email',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'info@youremailhere.com', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'headermain_email',
	array(
		'settings'      => 'headermain_email',
		'section'       => 'header_settings',
		'type'          => 'text',
		'label'         => __( 'Email', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'headermain_phone',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '012 345 6789', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'headermain_phone',
	array(
		'settings'      => 'headermain_phone',
		'section'       => 'header_settings',
		'type'          => 'text',
		'label'         => __( 'Phone Number', 'luzuk-premium' )
	)
);

//Set header Contact email phone icon  colour
addColorPalatOption($wp_customize, 'header_contactemailphoneiconColor', 'header_settings', 'Header Contact Email Phone Icon Color', '#fff');

//Set header Contact email phone icon  text colour
addColorPalatOption($wp_customize, 'header_contactemailphoneColor', 'header_settings', 'Header Contact Email Phone Text Color', '#fff');


//Set header Contact email hover colour
addColorPalatOption($wp_customize, 'header_contactemailhoverColor', 'header_settings', 'Header Contact Email Hover Color', '#fecb00');


// Adding the Label
lzCustomLable($wp_customize, 'lz_fitness_reservation_lblImgTxt', $sectionHeader, 'Social media icons');


// FACEBOOK 
$wp_customize->add_setting('header_fb',	array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_fb',
	array(
		'settings'      => 'header_fb',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Facebook Url', 'luzuk-premium' )
	)
);
// TWITTER
$wp_customize->add_setting('header_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_tw',
	array(
		'settings'      => 'header_tw',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Twitter Url', 'luzuk-premium' )
	)
);

// GOOGLE PLUS
$wp_customize->add_setting('header_it', array('default' => 'https://plus.google.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_it',
	array(
		'settings'      => 'header_it',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Google Plus Url', 'lz-fitness-premium' )
	)
);

// LINKED IN
$wp_customize->add_setting('header_in',array('default'=> 'https://linkedin.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_in',
	array(
		'settings'      => 'header_in',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Linkedin Url', 'luzuk-premium' )
	)
);


// Youtube IN
$wp_customize->add_setting('header_yt',array('default'=> 'https://www.youtube.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_yt',
	array(
		'settings'      => 'header_yt',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Youtube Url', 'Luzuk Premium' )
	)
);


//Set header social colour
addColorPalatOption($wp_customize, 'header_socialiconColor', 'header_settings', 'Header Social Color', '#fff');

//Set header social hover colour
addColorPalatOption($wp_customize, 'header_socialiconhoverColor', 'header_settings', 'Header Social Hover Color', '#fecb00');

lzCustomLable($wp_customize, 'header_clrlblImgTxt', 'header_settings', 'Set Header Menu Colors:');

//Set header menu colour
addColorPalatOption($wp_customize, 'headermenu_color', 'header_settings', 'Header Menu Color', '#282626');

//Set header current menu colour
addColorPalatOption($wp_customize, 'headercurrentmenu_color', 'header_settings', 'Header Current Menu Color', '#282626');

//Set header current menu bg colour
addColorPalatOption($wp_customize, 'headercurrentmenubg_color', 'header_settings', 'Header Current Menu Background Color', '#fecb00');

//Set header menu hover colour
addColorPalatOption($wp_customize, 'headermenuhover_color', 'header_settings', 'Header Menu Hover Color', '#282626');

//Set header menu bg hover colour
addColorPalatOption($wp_customize, 'headermenuhoverbg_color', 'header_settings', 'Header Menu Hover background Color', '#fecb00');

//Set header sub menu colour
addColorPalatOption($wp_customize, 'headersubmenu_color', 'header_settings', 'Header Sub Menu Color', '#fff');

//Set header dropdown Background colour
addColorPalatOption($wp_customize, 'headerdropdownbg_color', 'header_settings', 'Header dropdown Background Color', '#171717');

//Set header dropdown border colour
addColorPalatOption($wp_customize, 'headerdropdownborder_color', 'header_settings', 'Header dropdown Border Color', '#fecb00');


//Set header sub menu hover colour
addColorPalatOption($wp_customize, 'headersubmenuhover_color', 'header_settings', 'Header Sub Menu Hover Color', '#fecb00');

//Set header sub menu arrow hover colour
addColorPalatOption($wp_customize, 'headersubmenuarrowhover_color', 'header_settings', 'Header Sub Menu Arrow Hover Color', '#fecb00');

//Set header sub menu border hover colour
addColorPalatOption($wp_customize, 'headersubmenuborderhover_color', 'header_settings', 'Header Sub Menu Border Hover Color', '#fecb00');


//Set header current sub menu colour
addColorPalatOption($wp_customize, 'headercurrentsubmenu_color', 'header_settings', 'Header Current Sub Menu Color', '#fff');

//Set header current sub menu bg colour
addColorPalatOption($wp_customize, 'headercurrentsubmenubg_color', 'header_settings', 'Header Current Sub Menu background Color', '#fecb00');

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'luzuk-premium'),
	'panel' => 'lz_fitness_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'template_primary_color', 'colors', 'Theme Primary Color', '#fecb00');
//Inner page title color
addColorPalatOption($wp_customize, 'template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');
//Inner page background color
addColorPalatOption($wp_customize, 'template_innerpage_bgcolor', 'colors', 'Inner page title background color', '#fecb00');
// touggle bar color
addColorPalatOption($wp_customize, 'template_togglebar_color', 'colors', 'Toggle bar color', '#fecb00');

// Nav bar color
addColorPalatOption($wp_customize, 'template_navbar_color', 'colors', 'Navigation bar color', '#fff');

//Inner page content box heading 1 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh1color', 'colors', 'Heading 1 color', '#333333');

//Inner page content box heading 2 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh2color', 'colors', 'Heading 2 color', '#333333');

//Inner page content box heading 3 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh3color', 'colors', 'Heading 3 color', '#333333');

//Inner page content box heading 4 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh4color', 'colors', 'Heading 4 color', '#333333');

//Inner page content box heading 5 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh5color', 'colors', 'Heading 5 color', '#333333');

//Inner page content box heading 6 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh6color', 'colors', 'Heading 6 color', '#333333');

//Inner page content box text color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtextcolor', 'colors', 'Inner page content box text color', '#303030');

//Inner page content box list color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistcolor', 'colors', 'Inner page content box list color', '#303030');

//Inner page content box list icon color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlisticoncolor', 'colors', 'Inner page content box list icon color', '#fecb00');

//Inner page content box list number color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistnumbercolor', 'colors', 'Inner page content box list number color', '#fff');

//Inner page content box list number bg color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistnumberbgcolor', 'colors', 'Inner page content box list number background color', '#fecb00');

//Inner page content box links color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlinkcolor', 'colors', 'Inner page content box links color', '#fe7200');

//INNER PAGE HEADING FONT SIZE SETTINGS
$wp_customize->add_section(
	'innerheadingfontsize_settings',
	array(
		'title' => __( 'Inner Page Heading Font Size Settings', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_headerlogo_margin', 'innerheadingfontsize_settings', ' Inner Page Heading Font Size:');


$wp_customize->add_setting(
	'pages_h1font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '28px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h1font',
	array(
		'settings'      => 'pages_h1font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 1 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h2font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '26px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h2font',
	array(
		'settings'      => 'pages_h2font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 2 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h3font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '24px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h3font',
	array(
		'settings'      => 'pages_h3font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 3 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h4font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '22px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h4font',
	array(
		'settings'      => 'pages_h4font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 4 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h5font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '20px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h5font',
	array(
		'settings'      => 'pages_h5font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 5 Font Size', 'luzuk-premium' )
	)
);


$wp_customize->add_setting(
	'pages_h6font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '18px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h6font',
	array(
		'settings'      => 'pages_h6font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 6 Font Size', 'luzuk-premium' )
	)
);



//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'lz_fitness_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'lz_fitness_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 

// end to show & hide button

$wp_customize->add_setting(
        'lz_fitness_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default'           => __( 'Home', 'unboxthemes' )
        )
    );
    $wp_customize->add_control(
        'lz_fitness_breadcrumbhometxt',
        array(
            'settings'      => 'lz_fitness_breadcrumbhometxt',
            'section'       => 'lz_fitness_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here:', 'unboxthemes' )
        )
    );


//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'template_innerpage_breadcrumbtitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox title color', '#222222');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'template_innerpage_breadcrumbcurrenttitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title color', '#fecb00');

//Inner page breadcrumbbox current hover title color
addColorPalatOption($wp_customize, 'template_innerpage_breadcrumbcurrenttitlehovercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title hover color', '#222222');

//Inner page breadcrumbbox background color
addColorPalatOption($wp_customize, 'template_innerpage_breadcrumbbgcolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox background color', '#fff');

//Inner page breadcrumbbox border color
addColorPalatOption($wp_customize, 'template_innerpage_breadcrumbordercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox border color', '#222222');


//INNER SHORTCODE PAGE COLOR SETTINGS
$wp_customize->add_section(
	'shortcode_page_settings',
	array(
		'title' => __( 'Shortcode Page Settings', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'servicesshortcode', 'shortcode_page_settings', ' Services shortcode Page colors:');


// Highlight box color
addColorPalatOption($wp_customize, 'innerfeaturedhighlightbox_Color', 'shortcode_page_settings', 'Highlight box color', '#d9f6fe');

// Highlight box hover color
addColorPalatOption($wp_customize, 'innerfeaturedhighlightboxhover_Color', 'shortcode_page_settings', 'Highlight box hover color', '#fff4cc');

// title color
addColorPalatOption($wp_customize, 'innerfeaturedtitle_Color', 'shortcode_page_settings', 'Title color', '#141414');

// text color
addColorPalatOption($wp_customize, 'innerfeaturedtext_Color', 'shortcode_page_settings', 'Text color', '#9d9d9d');

// button text  color
addColorPalatOption($wp_customize, 'innerfeaturedbtntext_Color', 'shortcode_page_settings', 'Box button text color', '#000');

// button bg color
addColorPalatOption($wp_customize, 'innerfeaturedbtnbg_Color', 'shortcode_page_settings', 'Box button background color', '#fecb00');

// button text hover color
addColorPalatOption($wp_customize, 'innerfeaturedbtntexthover_Color', 'shortcode_page_settings', 'Box button text hover color', '#f00');

// button hover bg hightlight color
addColorPalatOption($wp_customize, 'innerfeaturedbtnhoverbghighlight_Color', 'shortcode_page_settings', 'Box button hover background highlight color', '#eabb00');

// box color
addColorPalatOption($wp_customize, 'innerfeaturedbox_Color', 'shortcode_page_settings', 'Box color', '#fff');

// box border color
addColorPalatOption($wp_customize, 'innerfeaturedboxborder_Color', 'shortcode_page_settings', 'Box border color', '#fff');

// box hover border color
addColorPalatOption($wp_customize, 'innerfeaturedboxhoverborder_Color', 'shortcode_page_settings', 'Box hover border color', '#fecb00');



lzCustomLable($wp_customize, 'galleryshortcode', 'shortcode_page_settings', ' Gallery shortcode Page colors:');

// Img border color
addColorPalatOption($wp_customize, 'galleryinner_borderColor', 'shortcode_page_settings', 'Image border color', '#fecb00');

// Img overlay color
addColorPalatOption($wp_customize, 'galleryinner_imgoverayColor', 'shortcode_page_settings', 'Image overlay color', '#191919');

lzCustomLable($wp_customize, 'teamshortcode', 'shortcode_page_settings', ' Team shortcode Page colors:');

$wp_customize->add_setting('teaminner_section_lbl', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
$wp_customize->add_control(
	new lz_fitness_Info_Text( 
		$wp_customize,
		'teaminner_section_lbl',
		array(
			'settings'		=> 'teaminner_section_lbl',
			'section'		=> 'shortcode_page_settings',
			'label'			=> __( 'Note:', 'luzuk-premium' ),	
			'description'	=> __( 'Kindly add the same size of the height image. Recommended image height size should be at least 250px .', 'luzuk-premium' ),
		)
	)
);

// title color
addColorPalatOption($wp_customize, 'teaminner_TitleColor', 'shortcode_page_settings', 'Title color', '#1a1a1a');


// desg color
addColorPalatOption($wp_customize, 'teaminner_DesColor', 'shortcode_page_settings', 'Designation color', '#fecb00');


// social color
addColorPalatOption($wp_customize, 'teaminner_SocialColor', 'shortcode_page_settings', 'Social color', '#fff');

// social box color
addColorPalatOption($wp_customize, 'teaminner_SocialboxColor', 'shortcode_page_settings', 'Social background color', '#fecb00');

// social hover color
addColorPalatOption($wp_customize, 'teaminner_SocialhoverColor', 'shortcode_page_settings', 'Social hover color', '#fecb00');

// social box hover color
addColorPalatOption($wp_customize, 'teaminner_SocialboxhoverColor', 'shortcode_page_settings', 'Social background hover color', '#fff');

// content box color
addColorPalatOption($wp_customize, 'teaminner_boxColor', 'shortcode_page_settings', 'Content box color', '#fff');


lzCustomLable($wp_customize, 'testimonialsshortcode', 'shortcode_page_settings', ' Testimonial shortcode Page colors:');


// image border hover color
addColorPalatOption($wp_customize, 'testimonialalsinner_imgborderhoverColor', 'shortcode_page_settings', 'Image hover border color', '#fecb00');


// text color
addColorPalatOption($wp_customize, 'testimonialalsinner_TextColor', 'shortcode_page_settings', 'Testimonial color', '#fff');

// title color
addColorPalatOption($wp_customize, 'testimonialalsinner_TitleColor', 'shortcode_page_settings', 'Title color', '#fff');

// title hover color
addColorPalatOption($wp_customize, 'testimonialalsinner_TitlehoverColor', 'shortcode_page_settings', 'Title hover color', '#fecb00');


// desg color
addColorPalatOption($wp_customize, 'testimonialalsinner_desgColor', 'shortcode_page_settings', 'Designation color', '#fff');

// Box border color
addColorPalatOption($wp_customize, 'testimonialalsinner_borderColor', 'shortcode_page_settings', 'Box border color', '#fecb00');

// Box color
addColorPalatOption($wp_customize, 'testimonialalsinner_bgColor', 'shortcode_page_settings', 'Box color', '#292929');


lzCustomLable($wp_customize, 'faqshortcode', 'shortcode_page_settings', ' FAQS shortcode Page colors:');

// number  color
    addColorPalatOption($wp_customize, 'innerfaq_numColor', 'shortcode_page_settings' , 'Number color', '#484848');

// number bg color
    addColorPalatOption($wp_customize, 'innerfaq_numbgColor', 'shortcode_page_settings', 'Number background color', '#f7f7f7');

// number border color
    addColorPalatOption($wp_customize, 'innerfaq_numborderColor', 'shortcode_page_settings', 'Number border color', '#e8e8e8');

// Quest  color
    addColorPalatOption($wp_customize, 'innerfaq_QColor', 'shortcode_page_settings', 'Question color', '#979797');

// Quest bg color
    addColorPalatOption($wp_customize, 'innerfaq_QbgColor', 'shortcode_page_settings', 'Question background color', '#fff');

// border color
    addColorPalatOption($wp_customize, 'innerfaq_borderColor', 'shortcode_page_settings', 'Border color', '#e8e8e8');

// anw text color
    addColorPalatOption($wp_customize, 'innerfaq_AColor', 'shortcode_page_settings', 'Answer color', '#979797');

// anw bg color
    addColorPalatOption($wp_customize, 'inneraq_AbgColor', 'shortcode_page_settings', 'Answer background color', '#fff');

// dropdown arrow color
    addColorPalatOption($wp_customize, 'innerfaq_dropdownarrowColor', 'shortcode_page_settings', 'Dropdown arrow color', '#c2c2c2');
  
//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'footer_copyright_settings',
	array(
		'title' => __( 'Footer Copyright Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

$wp_customize->add_setting(
	'footer_copyrighttext',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Copyright © 2019 Washing Center. All Rights Reserved', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'footer_copyrighttext',
	array(
		'settings'      => 'footer_copyrighttext',
		'section'       => 'footer_copyright_settings',
		'type'          => 'text',
		'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
	)
);

backgroundManager($wp_customize, 'footer', 'footer_copyright_settings', $color='#fff', get_template_directory_uri().'/images/footer.jpg', 'color');

// Adding the Label
lzCustomLable($wp_customize, 'lz_fitness_reservation_lblImgTxt', $sectionHeader, 'Social media icons');


// FACEBOOK 
$wp_customize->add_setting('footer_fb',	array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('footer_fb',
	array(
		'settings'      => 'footer_fb',
		'section'       => 'footer_copyright_settings',
		'type'          => 'url',
		'label'         => __( 'Facebook Url', 'luzuk-premium' )
	)
);
// TWITTER
$wp_customize->add_setting('footer_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('footer_tw',
	array(
		'settings'      => 'footer_tw',
		'section'       => 'footer_copyright_settings',
		'type'          => 'url',
		'label'         => __( 'Twitter Url', 'luzuk-premium' )
	)
);

// GOOGLE PLUS
$wp_customize->add_setting('footer_it', array('default' => 'https://plus.google.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('footer_it',
	array(
		'settings'      => 'footer_it',
		'section'       => 'footer_copyright_settings',
		'type'          => 'url',
		'label'         => __( 'Google Plus Url', 'lz-fitness-premium' )
	)
);

// LINKED IN
$wp_customize->add_setting('footer_in',array('default'=> 'https://linkedin.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('footer_in',
	array(
		'settings'      => 'footer_in',
		'section'       => 'footer_copyright_settings',
		'type'          => 'url',
		'label'         => __( 'Linkedin Url', 'luzuk-premium' )
	)
);


// Youtube IN
$wp_customize->add_setting('footer_yt',array('default'=> 'https://www.youtube.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('footer_yt',
	array(
		'settings'      => 'footer_yt',
		'section'       => 'footer_copyright_settings',
		'type'          => 'url',
		'label'         => __( 'Youtube Url', 'Luzuk Premium' )
	)
);


//theme Footer title Color
addColorPalatOption($wp_customize, 'footer_title_color', 'footer_copyright_settings', 'Footer Title Color', '#fff');

//theme Footer title border Color
addColorPalatOption($wp_customize, 'footer_titleborder_color', 'footer_copyright_settings', 'Footer Title Border Color', '#303030');

//theme Footer title border hover Color
addColorPalatOption($wp_customize, 'footer_titleborderhover_color', 'footer_copyright_settings', 'Footer Title Border hover Color', '#fecb00');

//theme Footer icon Color
addColorPalatOption($wp_customize, 'footer_icon_color', 'footer_copyright_settings', 'Footer Icon Color', '#fecb00');

//theme Footer icon hover Color
addColorPalatOption($wp_customize, 'footer_iconhover_color', 'footer_copyright_settings', 'Footer Icon Hover Color', '#fff');

//theme Footer text Color
addColorPalatOption($wp_customize, 'footer_text_color', 'footer_copyright_settings', 'Footer Text Color', '#838383');

//theme Footer menu Color
addColorPalatOption($wp_customize, 'footer_menu_color', 'footer_copyright_settings', 'Footer Menu Color', '#838383');

//theme Footer menu hover Color
addColorPalatOption($wp_customize, 'footer_menuhover_color', 'footer_copyright_settings', 'Footer Menu Hover Color', '#fff');

//theme Footer menu date Color
addColorPalatOption($wp_customize, 'footer_menudate_color', 'footer_copyright_settings', 'Footer Menu Date Color', '#515151');

//theme Footer menu date icon Color
addColorPalatOption($wp_customize, 'footer_menudateicon_color', 'footer_copyright_settings', 'Footer Menu Date ICon Color', '#363636');

//theme Footer menu date border Color
addColorPalatOption($wp_customize, 'footer_menudateborder_color', 'footer_copyright_settings', 'Footer Menu Date Border Color', '#303030');

//theme Footer social Color
addColorPalatOption($wp_customize, 'footer_social_color', 'footer_copyright_settings', 'Footer Social Color', '#939393');

//theme Footer social Hover Color
addColorPalatOption($wp_customize, 'footer_socialhover_color', 'footer_copyright_settings', 'Footer Social Hover Color', '#fecb00');

//theme Footer form Color
addColorPalatOption($wp_customize, 'footer_form_color', 'footer_copyright_settings', 'Footer Form Color', '#838383');

//theme Footer form border Color
addColorPalatOption($wp_customize, 'footer_formborder_color', 'footer_copyright_settings', 'Footer Form Border Color', '#303030');

//theme Footer form button Color
addColorPalatOption($wp_customize, 'footer_formbtn_color', 'footer_copyright_settings', 'Footer Form Button Color', '#fecb00');


//theme Footer form button border Color
addColorPalatOption($wp_customize, 'footer_formbtnborder_color', 'footer_copyright_settings', 'Footer Form Button Border Color', '#fecb00');


//theme Footer form button hover Color
addColorPalatOption($wp_customize, 'footer_formbtnhover_color', 'footer_copyright_settings', 'Footer Form Button Color', '#000');

//theme Footer form button border hover Color
addColorPalatOption($wp_customize, 'footer_formbtnhoverborder_color', 'footer_copyright_settings', 'Footer Form Button Border Color', '#000');

//theme Footer Form Button hover Background Color
addColorPalatOption($wp_customize, 'footer_formbtnhoverbg_color', 'footer_copyright_settings', 'Footer Form Button hover Background Color', '#fecb00');

//theme Footer copyright Text Color
addColorPalatOption($wp_customize, 'footer_copyrighttext_color', 'footer_copyright_settings', 'Copyright Footer Text Color', '#fff');

//theme Footer table border Color
addColorPalatOption($wp_customize, 'footer_tableborder_color', 'footer_copyright_settings', 'Footer Table Border Color', '#303030');

//theme Footer copyright border Color
addColorPalatOption($wp_customize, 'footer_copyrightborder_color', 'footer_copyright_settings', 'Copyright Footer Border Color', '#303030');

//theme Footer copyright text Color
addColorPalatOption($wp_customize, 'footer_copyrighttext_color', 'footer_copyright_settings', 'Copyright Footer text Color', '#828282');

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'lz_fitness_postpagedate_settings',
	array(
		'title' => __( 'Postpage Date Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'lz_fitness_postpagedate_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Date', 'hide' => 'Hide Post Date', ), ) ); 

// end to show & hide button

//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'lz_fitness_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'lz_fitness_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 