<?php
/**
 * Createing an about us pannel for customizer
 */

// START ABOUT SECTION 
    $wp_customize->add_section(
        'premium_aboutus_section',
        array(
            'title' => __( 'About Us Section', 'luzuk-premium' ),
            'panel' => 'lz_fitness_premium_home_panel'
        )
    );
    // ENABLE/DISABLE FEATURED SECTION
    $wp_customize->add_setting(
        'premium_aboutus_section_disable',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Switch_Control(
            $wp_customize,
            'premium_aboutus_section_disable',
            array(
                'settings'      => 'premium_aboutus_section_disable',
                'section'       => 'premium_aboutus_section',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    );

    backgroundManager($wp_customize, 'about', 'premium_aboutus_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

      $wp_customize->add_setting(
        'aboutus_title_heading',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'aboutus_title_heading',
            array(
                'settings'      => 'aboutus_title_heading',
                'section'       => 'premium_aboutus_section',
                'label'         => __( 'About Title & Text', 'luzuk-premium' ),
            )
        )
    ); 

    $wp_customize->add_setting(
        'aboutus_subtitle',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default'           => __( 'HEADING HERE', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'aboutus_subtitle',
        array(
            'settings'      => 'aboutus_subtitle',
            'section'       => 'premium_aboutus_section',
            'type'          => 'text',
            'label'         => __( 'Sub Title for section', 'luzuk-premium' )
        )
    );


     // Sub Heading color
    addColorPalatOption($wp_customize, 'aboutus_page_subHeadingColor', 'premium_aboutus_section', 'Section Sub Heading color', '#fecb00');

    $wp_customize->add_setting(
        'aboutus_title',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default'           => __( 'ABOUT US', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'aboutus_title',
        array(
            'settings'      => 'aboutus_title',
            'section'       => 'premium_aboutus_section',
            'type'          => 'text',
            'label'         => __( 'Title for section', 'luzuk-premium' )
        )
    );

     // Heading color
    addColorPalatOption($wp_customize, 'aboutus_page_HeadingColor', 'premium_aboutus_section', 'Section Heading color', '#191919');

    // Heading border color
    addColorPalatOption($wp_customize, 'aboutus_HeadingborderColor', 'premium_aboutus_section', 'Section Heading border color', '#fecb00');



$wp_customize->add_setting(
        'about_image_heading',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'about_image_heading',
            array(
                'settings'      => 'about_image_heading',
                'section'       => 'premium_aboutus_section',
                'label'         => __( 'Left Image', 'luzuk-premium' ),
            )
        )
    );

      $wp_customize->add_setting(
        'about_image',
        array(
            'sanitize_callback' => 'esc_url_raw'
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'about_image',
            array(
                'section' => 'premium_aboutus_section',
                'settings' => 'about_image',
                'description' => __('Recommended Image Size: 500X600px', 'luzuk-premium')
            )
        )
    );

     // image border color
    addColorPalatOption($wp_customize, 'aboutus_page_imgborderColor', 'premium_aboutus_section', 'Image border color', '#fecb00');

     // image bg color
    addColorPalatOption($wp_customize, 'aboutus_page_imgbgColor', 'premium_aboutus_section', 'Image background color', '#fff');

     // image hover border color
    addColorPalatOption($wp_customize, 'aboutus_page_imghoverborderColor', 'premium_aboutus_section', 'Image hover border color', '#fecb00');

    

      $wp_customize->add_setting(
        'aboutus_subText',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default'           => __( 'Clean Home Bringing Excellence in Residential', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'aboutus_subText',
        array(
            'settings'      => 'aboutus_subText',
            'section'       => 'premium_aboutus_section',
            'type'          => 'textarea',
            'label'         => __( 'About content Title', 'luzuk-premium' )
        )
    );

     // content title color
    addColorPalatOption($wp_customize, 'aboutus_page_contenttitleColor', 'premium_aboutus_section', 'Content title color', '#141414');

    $wp_customize->add_setting(
        'aboutus_text',
        array(
            'sanitize_callback'=>'lz_fitness_sanitize_text',
            'default'=> __('There are many variations of passages of Lorem Ipsum available, but majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything.', 'luzuk-premium')
        )
    );
    $wp_customize->add_control(
        'aboutus_text',
        array(
            'settings' =>'aboutus_text',
            'section' => 'premium_aboutus_section',
            'type'=> 'textarea',
            'label'=> __('Content for the section', 'luzuk-premium')
        )
    );

    $wp_customize->add_setting(
        'aboutus_text1',
        array(
            'sanitize_callback'=>'lz_fitness_sanitize_text',
            'default'=> __('There are many variations of passages of Lorem Ipsum available, but majority have suffered alteration in some form, by injected humour.', 'luzuk-premium')
        )
    );
    $wp_customize->add_control(
        'aboutus_text1',
        array(
            'settings' =>'aboutus_text1',
            'section' => 'premium_aboutus_section',
            'type'=> 'textarea',
            'label'=> __('Content for the section', 'luzuk-premium')
        )
    );


       // Text color
    addColorPalatOption($wp_customize, 'aboutus_page_TextColor', 'premium_aboutus_section', 'Text color', '#9d9d9d');

    // Text highlight color
    addColorPalatOption($wp_customize, 'aboutus_page_TexthighlightColor', 'premium_aboutus_section', 'Text highlight color', '#fecb00');


$wp_customize->add_setting('aboutus_npp_heading',array('sanitize_callback' => 'lz_fitness_sanitize_text'));
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'aboutus_npp_heading',
        array(
            'settings'      => 'aboutus_npp_heading',
            'section'       => 'premium_aboutus_section',
            'label'         => __( 'Number Of About Plans', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('aboutus_npp_count',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => 1));
$wp_customize->add_control(
    'aboutus_npp_count',
    array(
        'settings'      => 'aboutus_npp_count',
        'section'       => 'premium_aboutus_section',
        'type'          => 'select',
        'label'         => __( 'Number of About plan to show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

//ABOUT PAGES
for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'aboutus_header'.$i,
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'aboutus_header'.$i,
            array(
                'settings'      => 'aboutus_header'.$i,
                'section'       => 'premium_aboutus_section',
                'label'         => __( 'About Page ', 'luzuk-premium' ).$i
            )
        )
    );

     $wp_customize->add_setting(
        'aboutus_page_icon'.$i,
        array(
            'default'           => 'fa fa-clock-o',
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new lz_fitness_Fontawesome_Icon_Chooser(
            $wp_customize,
            'aboutus_page_icon'.$i,
            array(
                'settings'      => 'aboutus_page_icon'.$i,
                'section'       => 'premium_aboutus_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );

lzAddElement($wp_customize, 'aboutus_page_title'.$i, 'premium_aboutus_section', $type = 'text', $label="Title", $callback ='lz_fitness_sanitize_text', $default='Delivery On Time');

lzAddElement($wp_customize, 'aboutus_page_description'.$i, 'premium_aboutus_section', $type = 'textarea', $label="Description", $callback ='lz_fitness_sanitize_text', $default='Contrary to popular belief, Lorem Ipsum.');
    
}

     // icon color
    addColorPalatOption($wp_customize, 'aboutus_iconColor', 'premium_aboutus_section', 'Icon color', '#000');

    // icon hover color
    addColorPalatOption($wp_customize, 'aboutus_iconhoverColor', 'premium_aboutus_section', 'Icon hover color', '#fecb00');

 // title color
    addColorPalatOption($wp_customize, 'aboutus_titleColor', 'premium_aboutus_section', 'Title color', '#141414');

 // description color
    addColorPalatOption($wp_customize, 'aboutus_descriptionColor', 'premium_aboutus_section', 'Description color', '#9d9d9d');




    


    // END ABOUT SECTION 