<?php 
/**
 * Customiser section for featured
 **/
// Services Section
$wp_customize->add_section(
    'services_section',
    array(
        'title'         => __( 'Services Section', 'luzuk-premium' ),
        'panel'   => 'lz_fitness_premium_home_panel',
    )
);
// ENABLE/DISABLE SERVICES SECTION
$wp_customize->add_setting(
    'services_section_disable',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new lz_fitness_Switch_Control(
        $wp_customize,
        'services_section_disable',
        array(
            'settings'      => 'services_section_disable',
            'section'       => 'services_section',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'featured', 'services_section', $color='#f4f4f4', get_template_directory_uri().'/images/default-gray.png', 'img');


$wp_customize->add_setting(
    'services_title_sub_title_heading',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
    )
);
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'services_title_sub_title_heading',
        array(
            'settings'      => 'services_title_sub_title_heading',
            'section'       => 'services_section',
            'label'         => __( 'Section Title', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'services_subtitle',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'HEADING HERE', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'services_subtitle',
    array(
        'settings'      => 'services_subtitle',
        'section'       => 'services_section',
        'type'          => 'text',
        'label'         => __( 'Sub Heading', 'luzuk-premium' )
    )
);


// Sub Heading color
addColorPalatOption($wp_customize, 'lz_featured_subHeadingColor', 'services_section', 'Sub Heading color','#fecb00');

$wp_customize->add_setting(
    'services_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'OUR SERVICES', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'services_title',
    array(
        'settings'      => 'services_title',
        'section'       => 'services_section',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);

// Heading color
addColorPalatOption($wp_customize, 'lz_featured_HeadingColor', 'services_section', 'Heading color','#191919');

// border color
addColorPalatOption($wp_customize, 'lz_featured_HeadingborderColor', 'services_section', 'Heading Border color', '#fecb00');


$wp_customize->add_setting(
    'services_titletext',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'There are many variations of passages of Lorem Ipsum available, but majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'services_titletext',
    array(
        'settings'      => 'services_titletext',
        'section'       => 'services_section',
        'type'          => 'text',
        'label'         => __( 'Section Text ', 'luzuk-premium' )
    )
);

// sec text color
addColorPalatOption($wp_customize, 'lz_featured_sectextColor', 'services_section', 'Section Text color','#9d9d9d');

$wp_customize->add_setting('lz_featured_sectionnote_lbl', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
$wp_customize->add_control(
    new lz_fitness_Info_Text( 
        $wp_customize,
        'lz_featured_sectionnote_lbl',
        array(
            'settings'      => 'lz_featured_sectionnote_lbl',
            'section'       => 'services_section',
            'label'         => __( 'Note:', 'luzuk' ),    
            'description'   => __( 'Just place the shortcode "[SERVICES]" to list all services in page', 'luzuk' ),
        )
    )
);

$wp_customize->add_setting('lz_featured_sectionnote1_lbl', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
$wp_customize->add_control(
    new lz_fitness_Info_Text( 
        $wp_customize,
        'lz_featured_sectionnote1_lbl',
        array(
            'settings'      => 'lz_featured_sectionnote1_lbl',
            'section'       => 'services_section',
            'label'         => __( 'Note:', 'luzuk' ),    
            'description'   => __( 'Kindly add 225px of height for services image', 'luzuk' ),
        )
    )
);

$wp_customize->add_setting('services_npp_heading',array('sanitize_callback' => 'lz_fitness_sanitize_text'));
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'services_npp_heading',
        array(
            'settings'      => 'services_npp_heading',
            'section'       => 'services_section',
            'label'         => __( 'Number Of services to show', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('services_npp_count',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => 1));
$wp_customize->add_control(
    'services_npp_count',
    array(
        'settings'      => 'services_npp_count',
        'section'       => 'services_section',
        'type'          => 'select',
        'label'         => __( 'Number of services to show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

// TEAM PAGES
for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'services_heading'.$i,
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'services_heading'.$i,
            array(
                'settings'      => 'services_heading'.$i,
                'section'       => 'services_section',
                'label'         => __( 'Services ', 'luzuk-premium' ).$i,
            )
        )
    );

    if(is_array($featuresSingleChoice)){
        $wp_customize->add_setting(
            'services_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'services_page'.$i,
            array(
                'settings'      => 'services_page'.$i,
                'section'       => 'services_section',
                'type'=> 'select',
                'label'         => __( 'Select a service', 'luzuk-premium' ),
                'choices' => $featuresSingleChoice,
            )
        );
  


    }else{
        $wp_customize->add_setting('lz_fitness_Service_section_lbl'.$i, array('sanitize_callback'=>'lz_fitness_sanitize_text'));
        $wp_customize->add_control(
            new lz_fitness_Info_Text( 
                $wp_customize,
                'lz_fitness_Service_section_lbl'.$i,
                array(
                    'settings'      => 'lz_fitness_Service_section_lbl'.$i,
                    'section'       => 'services_section',
                    'label'         => __( 'Note:', 'luzuk-premium' ), 
                    'description'   => __( '<strong>Changes will not reflect unless you select a service.</strong> <br/>Please add the service from "Service menu" and then select service to show information.', 'luzuk-premium' ),
                )
            )
        );
    }
}




//FEATURED PAGES
for( $i = 1; $i <= 1; $i++ ){
lzCustomLable($wp_customize, 'featured_lblbutton1display', 'services_section', 'Button Display & Text Setting:');
// to show & hide another button
$wp_customize->add_setting( 'features_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'features_button_display', array( 'label' => 'Button Display', 'section' => 'services_section', 'settings' => 'features_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button
    $wp_customize->add_setting(
        'servicebutton_header'.$i,
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'servicebutton_header'.$i,
            array(
                'settings'      => 'servicebutton_header'.$i,
                'section'       => 'services_section',
                'label'         => __( 'Services Button Text:', 'InsideTours' )
            )
        )
    );
$wp_customize->add_setting(
    'servicebutton',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'READ MORE' )
    )
);
$wp_customize->add_control(
    'servicebutton',
    array(
        'settings'      => 'servicebutton',
        'section'       => 'services_section',
        'type'          => 'text',
        'label'         => __( 'Add Button Text Here:', 'luzuk' )
    )
);
}
// Highlight box color
addColorPalatOption($wp_customize, 'lz_featuredhighlightbox_Color', 'services_section', 'Highlight box color', '#d9f6fe');

// Highlight box hover color
addColorPalatOption($wp_customize, 'lz_featuredhighlightboxhover_Color', 'services_section', 'Highlight box hover color', '#fff4cc');

// title color
addColorPalatOption($wp_customize, 'lz_featuredtitle_Color', 'services_section', 'Title color', '#141414');

// text color
addColorPalatOption($wp_customize, 'lz_featuredtext_Color', 'services_section', 'Text color', '#9d9d9d');

// button text  color
addColorPalatOption($wp_customize, 'lz_featuredbtntext_Color', 'services_section', 'Box button text color', '#000');

// button bg color
addColorPalatOption($wp_customize, 'lz_featuredbtnbg_Color', 'services_section', 'Box button background color', '#fecb00');

// button text hover color
addColorPalatOption($wp_customize, 'lz_featuredbtntexthover_Color', 'services_section', 'Box button text hover color', '#f00');

// button hover bg hightlight color
addColorPalatOption($wp_customize, 'lz_featuredbtnhoverbghighlight_Color', 'services_section', 'Box button hover background highlight color', '#eabb00');

// box color
addColorPalatOption($wp_customize, 'lz_featuredbox_Color', 'services_section', 'Box color', '#fff');

// box border color
addColorPalatOption($wp_customize, 'lz_featuredboxborder_Color', 'services_section', 'Box border color', '#fff');

// box hover border color
addColorPalatOption($wp_customize, 'lz_featuredboxhoverborder_Color', 'services_section', 'Box hover border color', '#fecb00');
