<?php 
/**
 * Createing an about us pannel for customizer
 *
 */
// TEAM SECTION START HERE 
/*============TEAM SECTION PANEL============*/
$wp_customize->add_section(
	'gallery_section',
	array(
		'title'         => __( 'Gallery Section', 'luzuk-premium' ),
		'panel'   => 'lz_fitness_premium_home_panel',
	)
);
// ENABLE/DISABLE TEAM SECTION
$wp_customize->add_setting(
	'gallery_section_disable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'gallery_section_disable',
		array(
			'settings'      => 'gallery_section_disable',
			'section'       => 'gallery_section',
			'label'         => __( 'Disable Section', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk-premium' ),
				'off' => __( 'No', 'luzuk-premium' )
			)   
		)
	)
);


backgroundManager($wp_customize, 'gallery', 'gallery_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

$wp_customize->add_setting(
	'gallery_title_subtitle_heading',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
	)
);
$wp_customize->add_control(
	new lz_fitness_Customize_Heading(
		$wp_customize,
		'gallery_title_subtitle_heading',
		array(
			'settings'      => 'gallery_title_subtitle_heading',
			'section'       => 'gallery_section',
			'label'         => __( 'Section Title', 'luzuk-premium' ),
		)
	)
);
$wp_customize->add_setting(
	'gallery_title',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'PHOTO GALLERY', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'gallery_title',
	array(
		'settings'      => 'gallery_title',
		'section'       => 'gallery_section',
		'type'          => 'text',
		'label'         => __( 'Title', 'luzuk-premium' )
	)
);


// Heading color
addColorPalatOption($wp_customize, 'gallery_HeadingColor', 'gallery_section', 'Heading color', '#303030');

// Heading border color
addColorPalatOption($wp_customize, 'gallery_HeadingborderColor', 'gallery_section', 'Heading border color', '#fecb00');

// GALLERY PAGES
for( $i = 1; $i <= 8; $i++ ){
	$wp_customize->add_setting(
		'gallery_heading'.$i,
		array(
			'sanitize_callback' => 'lz_fitness_sanitize_text'
		)
	);
	$wp_customize->add_control(
		new lz_fitness_Customize_Heading(
			$wp_customize,
			'gallery_heading'.$i,
			array(
				'settings'      => 'gallery_heading'.$i,
				'section'       => 'gallery_section',
				'label'         => __( ' Image ', 'luzuk-premium' ).$i, 
			)
		)
	);
	if(is_array($GallerySingleChoice)){
		$wp_customize->add_setting(
			'gallery_page'.$i,
			array(
				'sanitize_callback' => 'absint'
			)
		);
		$wp_customize->add_control(
			'gallery_page'.$i,
			array(
				'settings'      => 'gallery_page'.$i,
				'section'       => 'gallery_section',
				'type'=> 'select',
				'label'         => __( 'Select a Gallary Image', 'luzuk-premium' ),
				'choices' => $GallerySingleChoice,
			)
		);
	}else{
		$wp_customize->add_setting('gallery_section_lbl'.$i, array('sanitize_callback'=>'lz_fitness_sanitize_text'));
		$wp_customize->add_control(
			new lz_fitness_Info_Text( 
				$wp_customize,
				'gallery_section_lbl'.$i,
				array(
					'settings'		=> 'gallery_section_lbl'.$i,
					'section'		=> 'gallery_section',
					'label'			=> __( 'Note:', 'luzuk-premium' ),	
					'description'	=> __( '<strong>Changes will not reflect unless you select the gallery Image.</strong> <br/>Please add the gallary team from "Gallary menu" and then select gallary Image to show information.', 'luzuk-premium' ),
				)
			)
		);
	}
}

// gallery image overlay color
addColorPalatOption($wp_customize, 'gallery_imgoverlayColor', 'gallery_section', 'Gallery image overlay color', '#fecb00');

// TEAM SECTION END HERE 