<?php   
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */
?>
<?php 

	if( get_theme_mod('sec_footerseTmargin',true) ) {
		$sec_footerseTmargin = 'padding-top:'.esc_attr(get_theme_mod('sec_footerseTmargin')).';';
	}
	if( get_theme_mod('sec_footersebottommargin',true) ) {
		$sec_footersebottommargin = 'padding-bottom:'.esc_attr(get_theme_mod('sec_footersebottommargin')).';';
	}
	if( get_theme_mod('sec_footersecopacity',true) ) {
		$sec_footersecopacity = 'opacity:'.esc_attr(get_theme_mod('sec_footersecopacity')).';';
	}

?>		
<footer class="footer-area" style="<?php echo esc_attr($sec_footerseTmargin); ?>" "<?php echo esc_attr($sec_footersebottommargin); ?>" "<?php echo esc_attr($sec_footersecopacity); ?>" id="footer">
		<?php if(is_active_sidebar('luzuk-footer1') || is_active_sidebar('luzuk-footer2') || is_active_sidebar('luzuk-footer3') ){ ?>
		
		<div class="top-area">
			<div class="container">
				<div class="footer-block">
					<div class="s-footer col-lg-4 col-md-4 col-sm-7 single-footer-1">
						<div class="single-footer wow bounceInUp" data-wow-duration="1s" >
							<?php if(is_active_sidebar('luzuk-footer1')): 
								dynamic_sidebar('luzuk-footer1');
							endif;
							?>	
						</div>
						<div class="clearfix"></div>
					</div>
					<div class="s-footer col-lg-2 col-md-2 col-sm-5 single-footer-2">
						<div class="single-footer wow bounceInUp" data-wow-duration="1.5s" >
							<?php if(is_active_sidebar('luzuk-footer2')): 
								dynamic_sidebar('luzuk-footer2');
							endif;
							?>	
						</div>
						<div class="clearfix"></div>
					</div>
					<div class="s-footer col-lg-3 col-md-3 col-sm-7 single-footer-3">
						<div class="single-footer wow bounceInUp"  data-wow-duration="2s" >
							<?php if(is_active_sidebar('luzuk-footer3')): 
								dynamic_sidebar('luzuk-footer3');
							endif;
							?>	
						</div>
						<div class="clearfix"></div>
					</div>
					<div class="s-footer col-lg-3 col-md-3 col-sm-5 single-footer-4">
						<div class="single-footer wow bounceInUp"  data-wow-duration="2s" >
							<?php if(is_active_sidebar('luzuk-footer4')): 
								dynamic_sidebar('luzuk-footer4');
							endif;
							?>	
						</div>
						<div class="clearfix"></div>
					</div>
					<div class="clearfix"></div>
				</div>
				<?php
					$footer_address = get_theme_mod('footer_address', 'Collins Street Victoria 8007');
					$footer_email = get_theme_mod('footer_email', 'info@watersports.com');
					$footer_phno = get_theme_mod('footer_phno', '1800-123-456789');
				?>
				<?php if($footer_address || $footer_email || $footer_phno) { ?>
				<div class="footer-contact wow bounceInUp">

					<?php if($footer_address ) { ?>
					<div class="col-md-4 col-sm-12 col-xs-12 footer-contact-inn">
						<div class="col-md-1 col-sm-1 col-xs-1 con-icon pd-0"><i class="fa fa-map-marker"></i></div>
						<div class="col-md-11 col-sm-11 col-xs-11 con-text"><?php echo ($footer_address);  ?></div>
					</div>
					<?php }?>

					<?php if($footer_email ) { ?>
					<div class="col-md-4 col-sm-12 col-xs-12 footer-contact-inn">
						<div class="col-md-1 col-sm-1 col-xs-1 con-icon pd-0"><i class="fa fa-envelope"></i></div>
						<div class="col-md-11 col-sm-11 col-xs-11 con-text"  href="#"><a href="#"><?php echo ($footer_email);  ?></a></div>
					</div>
					<?php }?>

					<?php if($footer_phno ) { ?>
					<div class="col-md-4 col-sm-12 col-xs-12 footer-contact-inn">
						<div class="col-md-1 col-sm-1 col-xs-1 con-icon pd-0"><i class="fa fa-phone"></i></div>
						<div class="col-md-11 col-sm-11 col-xs-11 con-text"  href="#"><?php echo ($footer_phno);  ?></div>
					</div>
					<?php }?>
					<div class="clearfix"></div>

				</div>
				<?php }?>
			</div>	
		<div class="clearfix"></div>
		</div>
		
	<?php } ?>

	<div class="clearfix"></div>
		<?php
			$footercopyright1 = get_theme_mod('footercopyright1', 'Terms & Condition');
			$footercopyright2 = get_theme_mod('footercopyright2', 'Privacy Policy');

			$FooterTermsNdCon = get_theme_mod('footer_termsndondition', '#');
			$FooterPrivacyText = get_theme_mod('footer_privacytext', '#');
		?>


		<?php 
		if( get_theme_mod('sec_bottomareaTmargin',true) ) {
			$sec_bottomareaTmargin = 'padding-top:'.esc_attr(get_theme_mod('sec_bottomareaTmargin')).';';
		}
		if( get_theme_mod('sec_bottomareabottommargin',true) ) {
			$sec_bottomareabottommargin = 'padding-bottom:'.esc_attr(get_theme_mod('sec_bottomareabottommargin')).';';
		}
		
		?>	

		<?php 
		if ( ! defined( 'ABSPATH' ) ) {
			exit; 
		}

		$footercopyright = '';
		if (function_exists('custom_theme_copyright')) {
			$footercopyright = custom_theme_copyright();
		}
 
	?>	
		<div class="bottom-area wow bounceInUp textcenter" style="<?php echo esc_attr($sec_bottomareaTmargin); ?>" "<?php echo esc_attr($sec_bottomareabottommargin); ?>">
			<div class="container">
			<div class="footer-block">
				<div class="col-md-12 col-sm-12 col-xs-12 pd-0">
					<div class="footer-text col-md-12">
						
						<?php if($footercopyright){ ?>
							<?php echo $footercopyright;?>
						<?php } ?>
						
					</div>

				<!-- 	<div class="footer-text1 col-md-6">
						<?php if($footercopyright1 || $footercopyright2){ ?>
						<li>
							<?php if($FooterTermsNdCon){ ?>
							<a class="footer-term" href="<?php echo $FooterTermsNdCon ?>">
								<?php echo $footercopyright1;?>
							</a>
							<?php } ?>	

							<?php if($footercopyright2){ ?>
							<a href="<?php echo $FooterPrivacyText ?>">
								<?php echo $footercopyright2;?>	
							</a>
							<?php } ?>
						</li>
					</div>
					<?php } ?> -->
				</div>
			</div>
		</div>
	</div>
</footer><!-- #colophon -->
<script type="text/javascript">
	if(jQuery(window).width() >= 1170){
		new WOW().init();
	}
</script>
<script>
	$(window).scroll(function() {
		var height = $(window).scrollTop();
		if (height > 100) {
			$('#back2Top').fadeIn();
		} else {
			$('#back2Top').fadeOut();
		}
	});
	$(document).ready(function() {
		$("#back2Top").click(function(event) {
			event.preventDefault();
			$("html, body").animate({ scrollTop: 0 }, "slow");
			return false;
		});

	});
</script>


<?php wp_footer(); ?>
<a id="back2Top" title="Back to top" href="#"> &#10148; </a>
</body>
</html>
