<?php

$wp_customize->add_panel(
	'luzuk_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'Luzuk Premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'Luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

addColorPalatOption($wp_customize, 'header_SiteTaglineColor', 'title_tagline', 'Tagline Color', '#fff');

//addColorPalatOption($wp_customize, 'header_logobgColor', 'title_tagline', 'Logo Background Color', '#fff');

lzCustomLable($wp_customize, 'pageslogosetmaxwidthl', 'title_tagline', 'Add Logo Max Width:');

$wp_customize->add_setting(
    'pages_logoTopsetmaxwidth',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '100', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoTopsetmaxwidth',
    array(
        'settings'      => 'pages_logoTopsetmaxwidth',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Max Width', 'luzuk-premium' )
    )
);


lzCustomLable($wp_customize, 'pageslogopaddingl', 'title_tagline', 'Add Logo Padding:');

$wp_customize->add_setting(
    'pages_logoTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoTpadding',
    array(
        'settings'      => 'pages_logoTpadding',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Top Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'pages_logoBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoBpadding',
    array(
        'settings'      => 'pages_logoBpadding',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Bottom Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'pages_logoLpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoLpadding',
    array(
        'settings'      => 'pages_logoLpadding',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Left Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'pages_logoRpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoRpadding',
    array(
        'settings'      => 'pages_logoRpadding',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Right Padding', 'luzuk-premium' )
    )
);



//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );


//HEADER SETTINGS
$wp_customize->add_section(
	'header_settings',
	array(
		'title' => __( 'Header Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'stickyheader_view', 'header_settings', 'Sticky Header Settings');
    //ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
    'luzuk_sticky_header_enable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'lz_sticky_header_enable',
        array(
            'settings'      => 'luzuk_sticky_header_enable',
            'section'       => 'header_settings',
            'label'         => __( 'Sticky Header', 'Luzuk Themethemes Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Enable', 'luzuk-premium' ),
                'off' => __( 'Disable', 'luzuk-premium' )
            )   
        )
    )
);

$sectionHeader = 'header_settings';

lzCustomLable($wp_customize, 'header_bgColorssettings', $sectionHeader, 'Header Background Colors');


addColorPalatOption($wp_customize, 'header_bgColor', 'header_settings', 'Top Header Background Color', '#000');
lzCustomLable($wp_customize, 'header_socialicon', 'header_settings', 'Header Social Media Setting');

 $wp_customize->add_setting(
        'haersocialtext',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Fallow Us:', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'haersocialtext',
        array(
            'settings'      => 'haersocialtext',
            'section'       => 'header_settings',
            'type'          => 'text',
            'label'         => __( 'Header Social Media Text', 'Luzuk' )
        )
    );

// FACEBOOK 
$wp_customize->add_setting('luzuk_header_fb',  array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('luzuk_header_fb',
    array(
        'settings'      => 'luzuk_header_fb',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Facebook Url', 'Luzuk-premium' )
    )
);
// TWITTER
$wp_customize->add_setting('luzuk_header_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('luzuk_header_tw',
    array(
        'settings'      => 'luzuk_header_tw',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Twitter Url', 'Luzuk-premium' )
    )
);

// Instagram
$wp_customize->add_setting('luzuk_header_insta', array('default' => 'https://www.instagram.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('luzuk_header_insta',
    array(
        'settings'      => 'luzuk_header_insta',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Instagram Url', 'Luzuk-premium' )
    )
); 

// pinterest
$wp_customize->add_setting('luzuk_header_pint', array('default' => 'https://www.pinterest.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('luzuk_header_pint',
    array(
        'settings'      => 'luzuk_header_pint',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Pinterest Url', 'Luzuk-premium' )
    )
); 

// youtube
$wp_customize->add_setting('luzuk_header_youtube', array('default' => 'https://www.youtube.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('luzuk_header_youtube',
    array(
        'settings'      => 'luzuk_header_youtube',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'You tube Url', 'Luzuk-premium' )
    )
); 

addColorPalatOption($wp_customize, 'header_topsocltxt', 'header_settings', 'Header Social Text Color', '#fff');

addColorPalatOption($wp_customize, 'header_topsoclicn', 'header_settings', 'Header Social Icon Color', '#fff');

addColorPalatOption($wp_customize, 'header_topsoclicnhv', 'header_settings', 'Header Social Icon Hover Color', '#000');

addColorPalatOption($wp_customize, 'header_topsoclicnbghv', 'header_settings', 'Header Social Icon Background Hover Color', '#0de9df');

lzCustomLable($wp_customize, 'header_email_phontext', $sectionHeader, 'Top Header Email & Phone Text Settings');

$wp_customize->add_setting(
        'headr_emailid',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'info@watersports.com', 'Luzuk' )
        )
    );
$wp_customize->add_control(
    'headr_emailid',
    array(
        'settings'      => 'headr_emailid',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Header Email Id', 'Luzuk' )
    )
);

$wp_customize->add_setting(
        'details_phone_no',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( '1800-123-456789', 'Luzuk' )
        )
    );
$wp_customize->add_control(
    'details_phone_no',
    array(
        'settings'      => 'details_phone_no',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Phone Number', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'header_iconcolor', 'header_settings', 'Header Icon Color', '#fff');

addColorPalatOption($wp_customize, 'header_emilcolor', 'header_settings', 'Header Email Id & Phone Number Text Color', '#fff');

addColorPalatOption($wp_customize, 'header_emilhvcolor', 'header_settings', 'Header Email Text Hover Color', '#0de9df');


//addColorPalatOption($wp_customize, 'header_mhaerbgColor', 'header_settings', 'Header Background Color', '#030710ba');

lzCustomLable($wp_customize, 'header_MenuColorssettings', $sectionHeader, 'Navigation Colors');

//addColorPalatOption($wp_customize, 'header_navbgColor', 'header_settings', 'Header Navigation Background color', '#fff');

addColorPalatOption($wp_customize, 'header_topmenusColor', 'header_settings', 'Menus color', '#fff');
addColorPalatOption($wp_customize, 'header_topmenushoverColor', 'header_settings', 'Menus Hover Color', '#000');

addColorPalatOption($wp_customize, 'header_topmenusactiveColor', 'header_settings', 'Active Menus Color', '#000');


//addColorPalatOption($wp_customize, 'header_topsubmenushvrColor', 'header_settings', 'All Menus Hover & Active Menus Background color', '#fff');

addColorPalatOption($wp_customize, 'header_topmenusarrowColor', 'header_settings', 'Menus Dropdown Arrow Color', '#fff');

addColorPalatOption($wp_customize, 'header_topsubmenusColor', 'header_settings', 'Header Sub Menus Color', '#ffffff');

addColorPalatOption($wp_customize, 'header_topsubmenushvColor', 'header_settings', 'Header Sub Menus Hover Color', '#000');

addColorPalatOption($wp_customize, 'header_topsubmenuscurr', 'header_settings', 'Header Sub Current Menus Color', '#000');

addColorPalatOption($wp_customize, 'header_topsubmenushvrbgColor', 'header_settings', 'Sub Menus Hover & Sub Menu Active Background Color', '#0de9df');

addColorPalatOption($wp_customize, 'header_submenusbgsscColor', 'header_settings', 'Dropdown Background Color', '#131313');

lzCustomLable($wp_customize, 'header_SearchButton', $sectionHeader, 'Header Search Button Color');

addColorPalatOption($wp_customize, 'header_serchbtnbg', 'header_settings', 'Search Icon Background Color', '#fff');

addColorPalatOption($wp_customize, 'header_serchbtnicn', 'header_settings', 'Search Icon Color', '#1a70b1');

addColorPalatOption($wp_customize, 'header_serchbtnbx', 'header_settings', 'Search Box Background Color', '#0de9df');

addColorPalatOption($wp_customize, 'header_serchbtntxtbx', 'header_settings', 'Search Text Box Background Color', '#fff');

addColorPalatOption($wp_customize, 'header_serchbtntxtbxbrd', 'header_settings', 'Search Text Box Border Color', '#fff');

addColorPalatOption($wp_customize, 'header_serchbtntxt', 'header_settings', 'Search Box Text Color', '#000');

addColorPalatOption($wp_customize, 'header_serchbtnbxbtnbg', 'header_settings', 'Search Box Button Background Color', '#000');

addColorPalatOption($wp_customize, 'header_serchbtnbxbtntxt', 'header_settings', 'Search Box Button Text Color', '#fff');


lzCustomLable($wp_customize, 'header_colorsfortabandmobview', $sectionHeader, 'Responsive Header Settings');

addColorPalatOption($wp_customize, 'header_subgColor', 'header_settings', 'Header Background Color', '#000');

addColorPalatOption($wp_customize, 'header_topsubgColor', 'header_settings', 'Top Header Background Color', '#242424');

addColorPalatOption($wp_customize, 'header_respnavtoggbarbgssColor', 'header_settings', 'Toggle Bar Color', '#fff');

addColorPalatOption($wp_customize, 'header_respnavbsbgssColor', 'header_settings', ' Navigation Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'header_navigationrespnavbrssColor', 'header_settings', 'Menus Title Color', '#000');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenuttlbgColor', 'header_settings', 'Menus Title BG Color', '#d5d5d5');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenuColor', 'header_settings', 'Menus Color', '#fff');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenubgColor', 'header_settings', 'Menus BG Color', '#000');

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'Luzuk Premium'),
	'panel' => 'luzuk_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'luzuk_template_color', 'colors', 'Theme Primary Color', '#0de9df');
//theme Secondary color
addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#c1babe');

lzCustomLable($wp_customize, 'luzuk_allinnerpagesec_colordisplaysettdisplay', 'colors', 'Color Setting For Innerpage Colors:');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_titlecolor', 'colors', 'Inner Page Title Color', '#fff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_bgcolor1', 'colors', 'Inner Page Title Background Color One', '#0de9df'); 
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_bgcolor2', 'colors', 'Inner Page Title Background Color Two', '#81e3f2'); 

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionbox_color', 'colors', 'Inner Page Box Background color', '#ffffff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading1_color', 'colors', 'Heading 1 Color', '#121a36');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading2_color', 'colors', 'Heading 2 Color', '#121a36');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading3_color', 'colors', 'Heading 3 Color', '#121a36');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading4_color', 'colors', 'Heading 4 Color', '#121a36');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading5_color', 'colors', 'Heading 5 Color', '#121a36');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading6_color', 'colors', 'Heading 6 Color', '#121a36');

addColorPalatOption($wp_customize, 'innerpagemainsectioninnerpagemainsectionboxheadingborderc1', 'colors', 'Heading Border color One', '#000');

addColorPalatOption($wp_customize, 'template_innerpage_contentboxsidebartitlecolor', 'colors', 'Inner Page Sidebar Heading', '#676767');

addColorPalatOption($wp_customize, 'template_innerpage_contentboxsidebartitlebordercolor', 'colors', 'Inner Page Sidebar Heading Border & Product Button Background Color', '#000');


addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtext_color', 'colors', 'Inner Page Text Color', '#666');

addColorPalatOption($wp_customize, 'template_innerpage_productpageboldtextcolor', 'colors', 'Inner Product Page Bold Text Color', '#000');

addColorPalatOption($wp_customize, 'template_innerpage_cartpageproducttitlecolor', 'colors', 'Inner  Cart Page Product Title Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpageproductprice_color', 'colors', 'Inner Page Product Selling Price Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpageproductpricedel_color', 'colors', 'Inner Page Product Price Color', '#7c8491');

addColorPalatOption($wp_customize, 'luzuk_template_innerpageallothrtheadtextcolcolor_color', 'colors', 'Other Text Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpageallothrtheadtextbgsscolcolor_color', 'colors', 'Other Fields Background Color', '#fff');



addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinks_color', 'colors', 'Inner Page Links Color', '#4f4c4c');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinkshvrs_color', 'colors', 'Inner Page Links Hover Color', '#131313');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinksicon_color', 'colors', 'Inner Page Icons, list number Color', '#0de9df');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinksiconbgssclr_color', 'colors', 'Inner Page list number Background Color', '#c1babe');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionsidebarborderrs_color', 'colors', 'Inner Page Sidebar & text field Border Color', '#e9e7e7');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagesidebardaytxt_color', 'colors', 'Inner Page Sidebar Calender Widgets Day Text Color', '#ffffff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagesidebardaybgsstxt_color', 'colors', 'Inner Page Sidebar Calender Widgets Day Text Background color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagesblockquote_color', 'colors', 'Inner Page blockquote Background Color', '#f2f2f2');


lzCustomLable($wp_customize, 'luzuk_allinnerpagesec_pagination', 'colors', 'Color Setting For Pagination:');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepagination_color', 'colors', 'Inner Page Pagination Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationbg_color', 'colors', 'Inner Page Pagination Background Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationborder_color', 'colors', 'Inner Page Pagination Border Color', '#eaeaea');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationactive_color', 'colors', 'Inner Page Pagination Hover & Active Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationbgactive_color', 'colors', 'Inner Page Pagination Background Hover & Active Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationborderactive_color', 'colors', 'Inner Page Pagination Border Hover & Active Color', '#000');

lzCustomLable($wp_customize, 'luzuk_allinnerpagesec_colordisplaysettnavbackttoarrdisplay', 'colors', 'Color Setting For Navigation Back to top arrow:');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_backttoparrcbgcolor', 'colors', 'Site Navigation Arrow Color', '#ccc');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_backttoparrcbg11color', 'colors', 'Site Navigation Arrow Background Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_backttoparrcbghvrcolor', 'colors', 'Site Navigation Arrow Hover Color', '#131313');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_backttoparrcbg11hvrcolor', 'colors', 'Site Navigation Arrow Background Hover Color', '#ccc');


//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'luzuk_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'luzuk_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Hide Breadcrumb', 'hide' => 'Show Breadcrumb', ), ) ); 

$wp_customize->add_setting(
        'luzuk_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Home', 'luzuk' )
        )
    );
    $wp_customize->add_control(
        'luzuk_breadcrumbhometxt',
        array(
            'settings'      => 'luzuk_breadcrumbhometxt',
            'section'       => 'luzuk_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here:', 'luzuk' )
        )
    );

//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbtitlecolor', 'luzuk_breadcrumb_settings', 'Inner page breadcrumb box title color', '#fff');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlecolor', 'luzuk_breadcrumb_settings', 'Inner page breadcrumb box current title color', '#fff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlehovercolor', 'luzuk_breadcrumb_settings', 'Inner page breadcrumb box current title hover color', '#121212');
// end to show & hide button

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'luzuk_blogpage_settings',
	array(
		'title' => __( 'Blog Page Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'allblog_heading2label', 'luzuk_blogpage_settings', 'Post Heading Font Size Setting:');

$wp_customize->add_setting(
    'blogpages_innerpageheading2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '23px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blogpages_innerpageheading2',
    array(
        'settings'      => 'blogpages_innerpageheading2',
        'section'       => 'luzuk_blogpage_settings',
        'type'          => 'text',
        'label'         => __( 'Post Heading Font Size', 'luzuk-premium' )
    )
);




lzCustomLable($wp_customize, 'allblog_lblbuttonabtdisplay', 'luzuk_blogpage_settings', 'Post Date & Admin Display Setting:');

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'luzuk_blogpage_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Date & Admin', 'hide' => 'Hide Post Date & Admin', ), ) ); 

// end to show & hide button


lzCustomLable($wp_customize, 'singleblog_lblbuttonabtdisplay', 'luzuk_blogpage_settings', 'Post social Icons Display Setting:');


//for POSTPAGEsocialsshare to show & hide button

$wp_customize->add_setting( 'postsocialsshare_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postsocialsshare_button_display', array( 'label' => 'Post social Icons Display', 'section' => 'luzuk_blogpage_settings', 'settings' => 'postsocialsshare_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Social Icons', 'hide' => 'Hide Social Icons', ), ) ); 

// end to show & hide button

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogimgoverlaycolor1', 'luzuk_blogpage_settings', 'Blog Page Image Hover Overlay Color One', '#0de9df');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogimgoverlaycolor2', 'luzuk_blogpage_settings', 'Blog Page Image Hover Overlay Color Two', '#8d91a2');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbuttoniconcolor', 'luzuk_blogpage_settings', 'Blog Page Image Hover Icon Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbuttoniconbgcolor', 'luzuk_blogpage_settings', 'Blog Page Image Hover Icon Background Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbuttoniconhovercolor', 'luzuk_blogpage_settings', 'Blog Page Image Hover Icon Hover Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbuttoniconbghovercolor', 'luzuk_blogpage_settings', 'Blog Page Image Hover Icon Background Hover Color', '#000');

//Blog page title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogtitlecolor', 'luzuk_blogpage_settings', 'Blog Page Title Color', '#0de9df');
//Blog page title hover color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogtitlehovercolor', 'luzuk_blogpage_settings', 'Blog Page Title Hover Color', '#000');

//Blog page social color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialcolor', 'luzuk_blogpage_settings', 'Blog Page Social Color', '#fff');
//Blog page social color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialbgcolor', 'luzuk_blogpage_settings', 'Blog Page Social Background Color', '#0de9df');
//Blog page social hover color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialhovercolor', 'luzuk_blogpage_settings', 'Blog Page Social Hover Color', '#fff');
//Blog page social color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialbghovercolor', 'luzuk_blogpage_settings', 'Blog Page Social Background Hover Color', '#000');


//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'footer_area',
	array(
		'title' => __( 'Footer Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

backgroundManager($wp_customize, 'footer', 'footer_area', $color='#000', get_template_directory_uri().'/images/footer-bg .jpg', 'color');

lzCustomLable($wp_customize, 'footer_areaPadding', 'footer_area', 'Set Top Footer Padding');

$wp_customize->add_setting(
    'sec_footerseTmargin', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footerseTmargin',
    array(
        'settings'      => 'sec_footerseTmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'sec_footersebottommargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footersebottommargin',
    array(
        'settings'      => 'sec_footersebottommargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'footer_areabottomfPadding', 'footer_area', 'Set Bottom Footer Padding:');
$wp_customize->add_setting(
    'sec_bottomareaTmargin', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.8em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_bottomareaTmargin',
    array(
        'settings'      => 'sec_bottomareaTmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'sec_bottomareabottommargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.8em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_bottomareabottommargin',
    array(
        'settings'      => 'sec_bottomareabottommargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'footer_address',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Collins Street Victoria 8007', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'footer_address',
    array(
        'settings'      => 'footer_address',
        'section'       => 'footer_area',
        'type'          => 'textarea',
        'label'         => __( 'Footer Address', 'Luzuk Premium' )
    )
);

$wp_customize->add_setting(
    'footer_email',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'info@watersports.com', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'footer_email',
    array(
        'settings'      => 'footer_email',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Footer Email', 'Luzuk Premium' )
    )
);

$wp_customize->add_setting(
    'footer_phno',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1800-123-456789', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'footer_phno',
    array(
        'settings'      => 'footer_phno',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Footer Phone No.', 'Luzuk Premium' )
    )
);


lzCustomLable($wp_customize, 'footer_copytext', 'footer_area', 'Footer Copyright Text:');

$wp_customize->add_setting(
    'footer_area_copyrighttext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Copyright © 2020 - Water Sports', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'footer_area_copyrighttext',
    array(
        'settings'      => 'footer_area_copyrighttext',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Footer Left Copyright Text', 'Luzuk Premium' )
    )
);

$wp_customize->add_setting(
    'footercopyright1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Terms & Condition', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'footercopyright1',
    array(
        'settings'      => 'footercopyright1',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Footer Terms Text', 'Luzuk Premium' )
    )
);
$wp_customize->add_setting('footer_termsndondition',    array('default'=> 'add url link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('footer_termsndondition',
    array(
        'settings'      => 'footer_termsndondition',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Add Url Here', 'Luzuk' )
    )
);



$wp_customize->add_setting(
    'footercopyright2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Privacy Policy', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'footercopyright2',
    array(
        'settings'      => 'footercopyright2',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Footer Policy Text', 'Luzuk Premium' )
    )
);

$wp_customize->add_setting('footer_privacytext',    array('default'=> 'add url link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('footer_privacytext',
    array(
        'settings'      => 'footer_privacytext',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Add Url Here', 'Luzuk' )
    )
);


//theme Footer Color Setting

addColorPalatOption($wp_customize, 'footerarea_copyright_color', 'footer_area', 'Footer Copyright Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_title_color', 'footer_area', 'Footer Title Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_text_color', 'footer_area', 'Footer Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_emait_color', 'footer_area', 'Footer Email OR Link Hover Color', '#0de9df');

addColorPalatOption($wp_customize, 'footerarea_hglightsctext_color', 'footer_area', 'Footer Hightlight Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_icon_color', 'footer_area', 'Footer Icon Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_sicon_color', 'footer_area', 'Footer Social Icon Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_siconhover_color', 'footer_area', 'Footer Social Icon Hover Color', '#0de9df');

addColorPalatOption($wp_customize, 'footerarea_siconbghover_color', 'footer_area', 'Footer Social Icon Background Hover Color', '#000');

addColorPalatOption($wp_customize, 'footerarea_menu_color', 'footer_area', 'Footer Menu Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_menuhover_color', 'footer_area', 'Footer Menu Hover Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_activemenu_color', 'footer_area', 'Footer Active Menu Color', '#0de9df');

addColorPalatOption($wp_customize, 'footerarea_datext_color', 'footer_area', 'Date Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_tableborder_color', 'footer_area', 'Border Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_formtextlabel_color', 'footer_area', 'Footer Form Label Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_formtext_color', 'footer_area', 'Form Text & Placeholder Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerareabutton_bg_color', 'footer_area', 'Footer Button Background Color', '#000');

addColorPalatOption($wp_customize, 'footerareabutton_bghover_color', 'footer_area', 'Footer Button Background Hover Color', '#fff');

addColorPalatOption($wp_customize, 'footerareabutton_text_color', 'footer_area', 'Footer Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerareabutton_textHv_color', 'footer_area', 'Footer Button Text Hover Color', '#000');

addColorPalatOption($wp_customize, 'footerarea_otherfbgs_color', 'footer_area', 'Other Fields Background Color', '#2a2a2a');

addColorPalatOption($wp_customize, 'footerarea_cpyrightbg', 'footer_area', 'Copyright Fields Background Color', '#141414');


//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'luzuk_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'luzuk_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 
// end to show & hide button

$wp_customize->add_setting(
    'productpages_productheading2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '20px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'productpages_productheading2',
    array(
        'settings'      => 'productpages_productheading2',
        'section'       => 'luzuk_shopsidebar_settings',
        'type'          => 'text',
        'label'         => __( 'Product Heading Font Size', 'luzuk-premium' )
    )
);


$wp_customize->add_section(
	'luzuk_innerpageshortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);


// Our Courses Inner pages Color

lzCustomLable($wp_customize, 'luzuk_servicepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Our Courses Shortcode Page Colors:'); 

lzCustomLable($wp_customize, 'luzuk_servicepagelable', 'luzuk_innerpageshortcode_page_settings', 'Note: Set Our Courses page images of equal height.');

addColorPalatOption($wp_customize, 'servicearea_Innerimghoverbg_color_one', 'luzuk_innerpageshortcode_page_settings', 'Select Image Hover Color', '#0de9df');

addColorPalatOption($wp_customize, 'luzuk_InnerServiceTitleColor', 'luzuk_innerpageshortcode_page_settings', 'Select Name Color', '#0de9df');

addColorPalatOption($wp_customize, 'luzuk_InnerServiceTitlehvColor', 'luzuk_innerpageshortcode_page_settings', 'Select Name Hover Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_InnerServiceTextColor', 'luzuk_innerpageshortcode_page_settings', 'Select Text Color', '#000');

// We Provied Inner pages Color

lzCustomLable($wp_customize, 'luzuk_packageinnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set We Provied Shortcode Page Colors:');

lzCustomLable($wp_customize, 'luzuk_packageinnerpagegallresclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Note: Kindly Use We Provied image of same resolution.');

addColorPalatOption($wp_customize, 'pages_innepkgimghv', 'luzuk_innerpageshortcode_page_settings', 'Select Image Hover Color ', '#0de9df');

addColorPalatOption($wp_customize, 'pages_innepkgttl', 'luzuk_innerpageshortcode_page_settings', 'Select Title Color ', '#000');

addColorPalatOption($wp_customize, 'pages_innepkgttxt', 'luzuk_innerpageshortcode_page_settings', 'Select Text Color ', '#6b6b6b');

addColorPalatOption($wp_customize, 'pages_innepkgtbtn', 'luzuk_innerpageshortcode_page_settings', 'Select Button Text Color ', '#fff');

addColorPalatOption($wp_customize, 'pages_innepkgtbtnhv', 'luzuk_innerpageshortcode_page_settings', 'Select Button Text Hover Color ', '#000');

addColorPalatOption($wp_customize, 'pages_innepkgtbtnbg', 'luzuk_innerpageshortcode_page_settings', 'Select Button Background Color ', '#000');

addColorPalatOption($wp_customize, 'pages_innepkgtbtnbghv', 'luzuk_innerpageshortcode_page_settings', 'Select Button Background Hover Color ', '#0de9df');


// Gallery Inner pages Color

lzCustomLable($wp_customize, 'luzuk_galleryinnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Gallery Shortcode Page Colors');

lzCustomLable($wp_customize, 'luzuk_galleryinnerpagegallresclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Note: Kindly Use Gallery image of same resolution.');

addColorPalatOption($wp_customize, 'pages_innerimghoveroverlayColor1', 'luzuk_innerpageshortcode_page_settings', 'Select Image Border Color', '#0de9df');

addColorPalatOption($wp_customize, 'pages_innerimghoveroverlayColor2', 'luzuk_innerpageshortcode_page_settings', 'Select Image Hover Overlay Color', '#0de9df');

// Team Inner pages Color

lzCustomLable($wp_customize, 'luzuk_teaminnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Team Shortcode Page Colors:');

lzCustomLable($wp_customize, 'luzuk_teampagelable', 'luzuk_innerpageshortcode_page_settings', 'Note: Set team member images of equal height.');

addColorPalatOption($wp_customize, 'pages_InnerTeamimghv1', 'luzuk_innerpageshortcode_page_settings', 'Team Member Image Hover Color One', '#000');

addColorPalatOption($wp_customize, 'pages_InnerTeamimghv2', 'luzuk_innerpageshortcode_page_settings', 'Team Member Image Hover Color Two', '#0de9df');

addColorPalatOption($wp_customize, 'pages_InnerTeamNameCColor', 'luzuk_innerpageshortcode_page_settings', 'Team Member Name Color', '#0de9df');

addColorPalatOption($wp_customize, 'pages_InnerTeamNamehoverCColor', 'luzuk_innerpageshortcode_page_settings', 'Team Member Name Hover Color', '#000');

addColorPalatOption($wp_customize, 'pages_InnerTeamDesignationCColor', 'luzuk_innerpageshortcode_page_settings', 'Team Designation Color', '#000');

addColorPalatOption($wp_customize, 'pages_InnerTeamDesignationhvCColor', 'luzuk_innerpageshortcode_page_settings', 'Team Designation Hover Color', '#0de9df');
 
addColorPalatOption($wp_customize, 'pages_InnerTeamtextCColor', 'luzuk_innerpageshortcode_page_settings', 'Team Text Color', '#000');

addColorPalatOption($wp_customize, 'pages_InnerTeamsocialsColor', 'luzuk_innerpageshortcode_page_settings', 'Team Socials Color', '#131313');

addColorPalatOption($wp_customize, 'pages_TeamsocialshvrsColor', 'luzuk_innerpageshortcode_page_settings', 'Team Socials Hover Color', '#0de9df');

 addColorPalatOption($wp_customize, 'pages_InnerTeamsocialsborderColor', 'luzuk_innerpageshortcode_page_settings', 'Team Socials Border Color', '#131313');

addColorPalatOption($wp_customize, 'pages_InnerTeamsocialsborderhvrsColor', 'luzuk_innerpageshortcode_page_settings', 'Team Socials Border Hover Color', '#0de9df');

addColorPalatOption($wp_customize, 'Innerteamarea_Highlightbox_color_one', 'luzuk_innerpageshortcode_page_settings', 'Team Box Color', '#fff');

// Testimonial Inner pages Color

lzCustomLable($wp_customize, 'luzuk_testimonialinnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Testimonial Shortcode Page Colors:');

//addColorPalatOption($wp_customize, 'luzuk_innertestimonials_boxcolor', 'luzuk_innerpageshortcode_page_settings', 'Select Box Background Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_boxhvcolor', 'luzuk_innerpageshortcode_page_settings', 'Select Box Border Color', '#0de9df');

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_Namecolor', 'luzuk_innerpageshortcode_page_settings', 'Select Client Name Color', '#0de9df');

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_Namehv', 'luzuk_innerpageshortcode_page_settings', 'Select Client Name Hover Color', '#000');
 
addColorPalatOption($wp_customize, 'luzuk_innertestimonials_textcolor', 'luzuk_innerpageshortcode_page_settings', 'Select Testimonial Content Color', '#131313');


// Faq Inner pages Color

lzCustomLable($wp_customize, 'luzuk_faqinnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Faq Shortcode Page Colors:');

 addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleIconColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Question Icon Color', '#0de9df');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Question Text Color', '#131313');
addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleboxborderColor', 'luzuk_innerpageshortcode_page_settings', 'Select Question Box Border Color', '#000');
addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleboxbgColor', 'luzuk_innerpageshortcode_page_settings', 'Select Question Box Background Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetextcColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Text Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetextcbrdColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Box Border Color', '#0de9df');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpageansbg1Color', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Box Background Color One', '#f3f3f3');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpageansbg2Color', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Box Background Color Two', '#fff');

//addColorPalatOption($wp_customize, 'luzuk_faqinnerpageansborderColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Box Border Color', '#fff');

$wp_customize->add_section(
	'luzuk_innerpagefont_settings',
	array(
		'title' => __( 'Inner Page Settings', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpage_titlepaddset', 'luzuk_innerpagefont_settings', ' Set Header Title Box Padding:');


$wp_customize->add_setting(
    'inner_headertitleboxTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '12em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'inner_headertitleboxTpadding',
    array(
        'settings'      => 'inner_headertitleboxTpadding',
        'section'       => 'luzuk_innerpagefont_settings',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'inner_headertitleboxBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'inner_headertitleboxBpadding',
    array(
        'settings'      => 'inner_headertitleboxBpadding',
        'section'       => 'luzuk_innerpagefont_settings',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);



lzCustomLable($wp_customize, 'luzuk_innerpageh1_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 1:');


$wp_customize->add_setting(
	'pages_innerpageheading',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '35px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading',
	array(
		'settings'      => 'pages_innerpageheading',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 1 Font Size', 'luzuk-premium' )
	)
);


lzCustomLable($wp_customize, 'luzuk_innerpageh2_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 2:');


$wp_customize->add_setting(
	'pages_innerpageheading2',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '24px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading2',
	array(
		'settings'      => 'pages_innerpageheading2',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 2 Font Size', 'luzuk-premium' )
	)
);
 

lzCustomLable($wp_customize, 'luzuk_innerpageh3_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 3:');


$wp_customize->add_setting(
	'pages_innerpageheading3',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '20px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading3',
	array(
		'settings'      => 'pages_innerpageheading3',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 3 Font Size', 'luzuk-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh4_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 4:');


$wp_customize->add_setting(
	'pages_innerpageheading4',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '18px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading4',
	array(
		'settings'      => 'pages_innerpageheading4',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 4 Font Size', 'luzuk-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh5_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 5:');


$wp_customize->add_setting(
	'pages_innerpageheading5',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '17px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading5',
	array(
		'settings'      => 'pages_innerpageheading5',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 5 Font Size', 'luzuk-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh6_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 6:');


$wp_customize->add_setting(
	'pages_innerpageheading6',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '16px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading6',
	array(
		'settings'      => 'pages_innerpageheading6',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 6 Font Size', 'luzuk-premium' )
	)
);