<?php 
    $wp_customize->add_section(
        'about_section',
        array(
            'title' => __( 'About Section', 'Luzuk' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'about_section_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'about_section_disable',
            array(
                'settings'      => 'about_section_disable',
                'section'       => 'about_section',
                'label'         => __( 'Disable Section', 'Luzuk' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'Luzuk' ),
                    'off' => __( 'No', 'Luzuk' )
                ),
            )
        )
    );

backgroundManager($wp_customize, 'about', 'about_section', $color='#fff', get_template_directory_uri().'/images/water-bg.jpg', 'color');

addColorPalatOption($wp_customize, 'about_overlaycolor', 'about_section', 'Section Overlay Color', '#09e3e8');

addColorPalatOption($wp_customize, 'about_headwave', 'about_section', 'Section Top Wave Color', '#fff');

// lzCustomLable($wp_customize, 'AboutDoctorSectionPadding', 'about_section', 'Section Padding');

// $wp_customize->add_setting(
//     'aboutTpadding', 
//     array(
//         'sanitize_callback' => 'luzuk_sanitize_text',
//         'default'           => __( '0em', 'Luzuk' )
//     )
// );
// $wp_customize->add_control(
//     'aboutTpadding',
//     array(
//         'settings'      => 'aboutTpadding',
//         'section'       => 'about_section',
//         'type'          => 'text',
//         'label'         => __( 'Top Padding', 'Luzuk' )
//     )
// );
// $wp_customize->add_setting(
//     'aboutBpadding',
//     array(
//         'sanitize_callback' => 'luzuk_sanitize_text',
//         'default'           => __( '0em', 'Luzuk' )
//     )
// );
// $wp_customize->add_control(
//     'aboutBpadding',
//     array(
//         'settings'      => 'aboutBpadding',
//         'section'       => 'about_section',
//         'type'          => 'text',
//         'label'         => __( 'Bottom Padding', 'Luzuk' )
//     )
// );


lzCustomLable($wp_customize, 'abutheadsettings', 'about_section', 'Section Heading Setting');

$wp_customize->add_setting(
    'about_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'About <span>Us</span>', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'about_maintitle',
    array(
        'settings'      => 'about_maintitle',
        'section'       => 'about_section',
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'about_headColor', 'about_section', 'Section Heading Color', '#131313');

addColorPalatOption($wp_customize, 'about_headbrd', 'about_section', 'Section Heading Highlight Color', '#fff');


lzCustomLable($wp_customize, 'abtsec_heading', 'about_section', 'Section Heading Border Image');

$wp_customize->add_setting(
    'about_image5',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_image5',
        array(
            'section' => 'about_section',
            'settings' => 'about_image5',
            'description' => __('Recommended Image Size: 65X17px', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting(
        'aboutdoctor_title_heading',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'aboutdoctor_title_heading',
        array(
            'settings'      => 'aboutdoctor_title_heading',
            'section'       => 'about_section',
            'label'         => __( 'About Details', 'Luzuk' ),
        )
    )
);   

$wp_customize->add_setting(
    'about_content',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Viva-mus eu pharetra ex. Etiam eget diam ligula. Sed at blandit ante. Vivamus feugiat, lacus eu suscipit mattis, tortor mi aliquam leo, quis laoreet ante sem sed sapien.', 'Luzuk' )
    )
);

$wp_customize->add_control(
    'about_content',
    array(
        'settings'      => 'about_content',
        'section'       => 'about_section',
        'type'          => 'textarea',
        'label'         => __( 'Section Content', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'about_ContentColor', 'about_section', 'Section Content Color', '#131313');

lzCustomLable($wp_customize, 'buttontextsettings', 'about_section', 'Button Text, Button Link & Its Colors:');


// button
$wp_customize->add_setting( 'about_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'about_button_display', array( 'label' => 'About Button Display', 'section' => 'about_section', 'settings' => 'about_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) );

$wp_customize->add_setting(
        'about_button1',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'READ MORE', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'about_button1',
        array(
            'settings'      => 'about_button1',
            'section'       => 'about_section',
            'type'          => 'text',
            'label'         => __( 'Add Button Text Here', 'Luzuk' )
        )
    );
$wp_customize->add_setting('about_link',   array('default'=> 'add Button link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('about_link',
    array(
        'settings'      => 'about_link',
        'section'       => 'about_section',
        'type'          => 'url',
        'label'         => __( 'Add Link For Button:', 'Luzuk' )
    )
);    

addColorPalatOption($wp_customize, 'about_ButtonTextColor', 'about_section', 'Button Text Color', '#000');

addColorPalatOption($wp_customize, 'about_ButtonTexthvColor', 'about_section', 'Button Text Hover Color', '#0de9df');

addColorPalatOption($wp_customize, 'about_ButtonbgColor', 'about_section', 'Button Background Color', '#fff');

addColorPalatOption($wp_customize, 'about_ButtonbghvColor', 'about_section', 'Button Background Hover Color', '#000');

// end to show & hide button


//sectionRight Side Image

$wp_customize->add_setting(
    'about_image5_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);

$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_image5_heading',
        array(
            'settings'      => 'about_image5_heading',
            'section'       => 'about_section',
            'label'         => __( 'About Section Right Image', 'luzuk-premium' ),
        )
    )
);

backgroundManager($wp_customize, 'about-right', 'about_section', $color='#fff', get_template_directory_uri().'/images/abtstudio.jpg', 'color');

addColorPalatOption($wp_customize, 'abimgphneicncolor', 'about_section', 'Section Image Box Phone Icon Color', '#0de9df');

addColorPalatOption($wp_customize, 'abimgphneicnbg', 'about_section', 'Section Image Box Phone Icon Background Color', '#fff');


$wp_customize->add_setting(
    'abimgphnetxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Call Now', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'abimgphnetxt',
    array(
        'settings'      => 'abimgphnetxt',
        'section'       => 'about_section',
        'type'          => 'text',
        'label'         => __( 'Section Image Box Text', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'abimgtxt', 'about_section', 'Section Image Box Text Color', '#000');

addColorPalatOption($wp_customize, 'abimgtxtbg', 'about_section', 'Section Image Box Text Background Color', '#fff');

addColorPalatOption($wp_customize, 'abimgtxtbrd', 'about_section', 'Section Image Box Text Border Color', '#0de9df');

$wp_customize->add_setting(
    'abimgphnenumber',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1800-123-4567', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'abimgphnenumber',
    array(
        'settings'      => 'abimgphnenumber',
        'section'       => 'about_section',
        'type'          => 'text',
        'label'         => __( 'Section Image Box Phone Number', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'abimgtponenum', 'about_section', 'Section Image Box Phone Number Color', '#fff');

addColorPalatOption($wp_customize, 'abimgtponenumbg', 'about_section', 'Section Image Box Phone Number Background Color', '#000');