<?php 
    $wp_customize->add_section(
        'banner_area',
        array(
            'title' => __( 'Banner Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'banner_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'banner_area_disable',
            array(
                'settings'      => 'banner_area_disable',
                'section'       => 'banner_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 
    
backgroundManager($wp_customize, 'banner', 'banner_area', $color='#fff', get_template_directory_uri().'/images/bannerbg.jpg', 'color');

addColorPalatOption($wp_customize, 'bnnrimgbgorly', 'banner_area', 'Section Overlay Color ', '#000');

lzCustomLable($wp_customize, 'bannerarea_padding', 'banner_area', 'Section Padding:');

$wp_customize->add_setting(
    'banner_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'banner_areaTpadding',
    array(
        'settings'      => 'banner_areaTpadding',
        'section'       => 'banner_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'banner_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'banner_areaBpadding',
    array(
        'settings'      => 'banner_areaBpadding',
        'section'       => 'banner_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'banner_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'banner_title_heading',
        array(
            'settings'      => 'banner_title_heading',
            'section'       => 'banner_area',
            'label'         => __( 'Section Heading, Sub Heading Text', 'luzuk-premium' ),
        )
    )
);    

$wp_customize->add_setting(
    'banner_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'CALL US NOW FOR ANY QUERIES', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'banner_text',
    array(
        'settings'      => 'banner_text',
        'section'       => 'banner_area',
        'type'          => 'textarea',
        'label'         => __( 'Section Sub Title', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'bnrara_txt', 'banner_area', 'Section Sub Color ', '#fff');

$wp_customize->add_setting(
    'banner_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+1800 123 456 7890', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'banner_title',
    array(
        'settings'      => 'banner_title',
        'section'       => 'banner_area',
        'type'          => 'text',
        'label'         => __( 'Section Contact Number', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'bnrara_title', 'banner_area', 'Section Contact Number Color ', '#fff');

addColorPalatOption($wp_customize, 'bnrara_bxbrd', 'banner_area', 'Section Border Color ', '#fff');

lzCustomLable($wp_customize, 'bannerarea_button_display', 'banner_area', 'Button Display & Text Setting:');
// to show & hide another button
$wp_customize->add_setting( 'bannerarea_button' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'bannerarea_button', array( 'label' => 'Button Display', 'section' => 'banner_area', 'settings' => 'bannerarea_button', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button

$wp_customize->add_setting(
    'bannerareabutton',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'CONTACT US' )
    )
);
$wp_customize->add_control(
    'bannerareabutton',
    array(
        'settings'      => 'bannerareabutton',
        'section'       => 'banner_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'Luzuk Theme' )
    )
);
$wp_customize->add_setting('bannerareabuttonlink',   array('default'=> 'add Button link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('bannerareabuttonlink',
    array(
        'settings'      => 'bannerareabuttonlink',
        'section'       => 'banner_area',
        'type'          => 'url',
        'label'         => __( 'Button Url', 'Luzuk Theme' )
    )
);

addColorPalatOption($wp_customize, 'bnrara_btntxt', 'banner_area', 'Section Button Text & Icon Color ', '#fff');

addColorPalatOption($wp_customize, 'bnrara_btntxthv', 'banner_area', 'Section Button Text & Icon Hover Color ', '#000');

addColorPalatOption($wp_customize, 'bnrara_btnbghv', 'banner_area', 'Section Button Background Hover Color ', '#fff');

addColorPalatOption($wp_customize, 'bnrara_phbxicn', 'banner_area', 'Section Phone Box Icon Color ', '#000');

addColorPalatOption($wp_customize, 'bnrara_phbxicnbg', 'banner_area', 'Section Phone Box Background Color ', '#fff');

addColorPalatOption($wp_customize, 'bnrara_phbxicnbrd', 'banner_area', 'Section Phone Box Border Color ', '#867d7d');