<?php  

$luzukSliderSingleChoice = getFitnessPostsType('slider');
$wp_customize->add_section(
	'slider_section',
	array(
		'title' => __( 'Slider Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel',
		'priority' =>18
	)
);
$wp_customize->add_setting(
	'slider_section_show_content',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'slider_section_show_content',
		array(
			'settings'      => 'slider_section_show_content',
			'section'       => 'slider_section',
			'label'         => __( 'Hide Title and description on Slider', 'Luzuk' ),
			'on_off_label'  => array(
				'on' => __( 'No', 'Luzuk' ),
				'off' => __( 'Yes', 'Luzuk' )
			),
		)
	)
);
$wp_customize->add_setting('slider_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Info_Text( 
		$wp_customize,
		'slider_section_lbl',
		array(
			'settings'		=> 'slider_section_lbl',
			'section'		=> 'slider_section',
			'label'			=> __( 'Note:', 'Luzuk' ),	
			'description'	=> __( 'The page featured image works as a banner and the title & content work as a slider caption. You can add this from the Slider menu. <br/> Recommended Image Size: 1140X666', 'Luzuk' ),
		)
	)
);

lzCustomLable($wp_customize, 'slidersarea_Overlay', 'slider_section', 'Set Overlay:');

$wp_customize->add_setting(
    'slider_areaOpacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.0', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'slider_areaOpacity',
    array(
        'settings'      => 'slider_areaOpacity',
        'section'       => 'slider_section',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);



addColorPalatOption($wp_customize, 'slider_bg_color', 'slider_section', 'Slider Overlay Color', '#fff');

lzCustomLable($wp_customize, 'luzuk_sliderotherclrs', 'slider_section', 'Slider Colors Setting');

addColorPalatOption($wp_customize, 'slider_titleColor', 'slider_section', 'Slider Title Color', '#fff');

addColorPalatOption($wp_customize, 'slider_subtitleColor', 'slider_section', 'Slider Sub Title Color', '#fff');

addColorPalatOption($wp_customize, 'slider_mbtn', 'slider_section', 'Slider Button Color', '#000');
addColorPalatOption($wp_customize, 'slider_mbtnhv', 'slider_section', 'Slider Button Hover Color', '#000');
addColorPalatOption($wp_customize, 'slider_mbtnbg', 'slider_section', 'Slider Button Background Color', '#fff');
addColorPalatOption($wp_customize, 'slider_mbtnbghv', 'slider_section', 'Slider Button Background Hover Color', '#0de9df');

addColorPalatOption($wp_customize, 'slider_leftrighticonbg', 'slider_section', 'Slider Next & Prev Button Background Color', '#fff');

addColorPalatOption($wp_customize, 'slider_leftrighticonbghv', 'slider_section', 'Slider Next & Prev Button Background Hover Color', '#0de9df');

addColorPalatOption($wp_customize, 'slider_lcurvcolor', 'slider_section', 'Slider Curve Background Color', '#fff');