<?php 
    $wp_customize->add_section(
        'about_area',
        array(
            'title' => __( 'About Us Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'about_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'about_area_disable',
            array(
                'settings'      => 'about_area_disable',
                'section'       => 'about_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'aboutus', 'about_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'aboutarea_padding', 'about_area', 'Section Padding');

$wp_customize->add_setting(
    'about_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaTpadding',
    array(
        'settings'      => 'about_areaTpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'about_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaBpadding',
    array(
        'settings'      => 'about_areaBpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);



lzCustomLable($wp_customize, 'aboutarea_rightclr', 'about_area', 'Section Left Side');

$wp_customize->add_setting(
    'about_image_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_image_heading',
        array(
            'settings'      => 'about_image_heading',
            'section'       => 'about_area',
            'label'         => __( 'Section Image', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'about_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_image',
        array(
            'section' => 'about_area',
            'settings' => 'about_image',
            'description' => __('Recommended Image Size: 594X511', 'luzuk-premium')
        )
    )
);

lzCustomLable($wp_customize, 'aboutarea_Overlay', 'about_area' , 'Image Overlay');

$wp_customize->add_setting(
    'abt_secOpacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.3', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'abt_secOpacity',
    array(
        'settings'      => 'abt_secOpacity',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_Overlay', 'about_area', 'Image Overlay Color', '#000');

lzCustomLable($wp_customize, 'aboutarea_imgtitle', 'about_area' , 'Image Title');

$wp_customize->add_setting(
    'imgtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'About Us', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'imgtitle',
    array(
        'settings'      => 'imgtitle',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Image Title', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_imgtitle', 'about_area', 'Image Title Color', '#FDAF1B');

$wp_customize->add_setting(
    'about_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_title_heading',
        array(
            'settings'      => 'about_title_heading',
            'section'       => 'about_area',
            'label'         => __( ' Section Right Side', 'luzuk-premium' ),
        )
    )
);    


$wp_customize->add_setting(
    'about_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'About Us', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_subtitle',
    array(
        'settings'      => 'about_subtitle',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Sub Title', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_secsubtitle_clr', 'about_area', 'Sub Title Color ', '#FDAF1B');


$wp_customize->add_setting(
    'about_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Enhancing Your Home is Functionality and Comfort', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_title',
    array(
        'settings'      => 'about_title',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( 'Title', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_sectitle_clr', 'about_area', 'Title Color ', '#292B2A');

$wp_customize->add_setting(
    'about_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Maecenas venenatis sapien nec libero tempus, sed pretium justo scelerisque. Morbi nulla enim, iaculis non tempor vel, fermentum eu mi. Nam malesuada eros a nulla mattis, ut sollicitudin magna elementum. Etiam porttitor non lacus pellentesque ullamcorper.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_text',
    array(
        'settings'      => 'about_text',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( 'Section Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_text', 'about_area', 'Text Color', '#707070');

$wp_customize->add_setting('aboutus_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'aboutus_npp_heading',
        array(
            'settings'      => 'aboutus_npp_heading',
            'section'       => 'about_area',
            'label'         => __( 'Number Of About Plans', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('aboutus_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 5));
$wp_customize->add_control(
    'aboutus_npp_count',
    array(
        'settings'      => 'aboutus_npp_count',
        'section'       => 'about_area',
        'type'          => 'select',
        'label'         => __( 'Number Of About Plan To Show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6)
    )
);

//ABOUT PAGES
for( $i = 1; $i <= 6; $i++ ){
    $wp_customize->add_setting(
        'aboutus_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'aboutus_header'.$i,
            array(
                'settings'      => 'aboutus_header'.$i,
                'section'       => 'about_area',
                'label'         => __( 'About Plan ', 'luzuk-premium' ).$i
            )
        )
    );

//lzAddImageElement($wp_customize, 'aboutus_page_icon'.$i, 'about_area', $label="Recommended Image Size: 150X150px");

     $wp_customize->add_setting(
        'aboutus_page_icon'.$i,
        array(
            'default'           => 'fa fa-stumbleupon',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'aboutus_page_icon'.$i,
            array(
                'settings'      => 'aboutus_page_icon'.$i,
                'section'       => 'about_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );

lzAddElement($wp_customize, 'aboutus_page_title'.$i, 'about_area', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Plumbing and Electrical Repairs');

//lzAddElement($wp_customize, 'aboutus_page_txt'.$i, 'about_area', $type = 'textarea', $label="Text", $callback ='luzuk_sanitize_text', $default='Nunc porta pellentesque nunc vitae dictum. Donec non orci id tellus.');

}

lzCustomLable($wp_customize, 'Sec_abt1stclor', 'about_area' , 'Section Color');

addColorPalatOption($wp_customize, 'about_bx1icn', 'about_area', 'Icon Color', '#000');

addColorPalatOption($wp_customize, 'about_bx1icnbg', 'about_area', 'Icon BG Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'about_bx1icntitle', 'about_area', 'Icon Title Color', '#000');


lzCustomLable($wp_customize, 'abtSec_btnclr', 'about_area' , 'Section Button');

$wp_customize->add_setting(
    'abtbtn_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Read More', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'abtbtn_text',
    array(
        'settings'      => 'abtbtn_text',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

$wp_customize->add_setting('abtbtnlink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('abtbtnlink',
    array(
        'settings'      => 'abtbtnlink',
        'section'       => 'about_area',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);



addColorPalatOption($wp_customize, 'abtdec_btntxtclr', 'about_area', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'abtdec_btntxthvclr', 'about_area', 'Button Text Hover Color', '#000');

addColorPalatOption($wp_customize, 'abtdec_btnBGclr', 'about_area', 'Button BG Color', '#292B2A');

addColorPalatOption($wp_customize, 'abtdec_btnicnBGclr', 'about_area', 'Button Icon BG Color', '#FDAF1B');

