<?php
// START CONTACT SECTION 
$wp_customize->add_section(
	'appoi_section',
	array(
		'title'         => __( 'Appointment Section', 'Luzuk Premium' ), 
		'panel'   => 'luzuk_premium_home_panel',
	)
);
    //ENABLE/DISABLE CONTACT SECTION
$wp_customize->add_setting(
	'appoi_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'appoi_disable',
		array(
			'settings'      => 'appoi_disable',
			'section'       => 'appoi_section',
			'label'         => __( 'Disable Section', 'Luzuk Premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'Luzuk Premium' ),
				'off' => __( 'No', 'Luzuk Premium' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'appointment', 'appoi_section', $color='#fff', get_template_directory_uri().'/images/app_bg1.jpg', 'color');


lzCustomLable($wp_customize, 'app_imgoly', 'appoi_section', 'Section Image Overlay Opacity ');

$wp_customize->add_setting(
    'app_secOpacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.62', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'app_secOpacity',
    array(
        'settings'      => 'app_secOpacity',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'app_secolyclr', 'appoi_section', 'Section Image Overlay Color', '#000');

lzCustomLable($wp_customize, 'appoi_sectionnpadding', 'appoi_section', 'Section Padding ');

$wp_customize->add_setting(
    'appoinmentsection_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'appoinmentsection_toppadding',
    array(
        'settings'      => 'appoinmentsection_toppadding',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Top ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'appoinmentsection_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'appoinmentsection_bottompadding',
    array(
        'settings'      => 'appoinmentsection_bottompadding',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Bottom ', 'luzuk-premium' )
    )
);


lzCustomLable($wp_customize, 'app_detailbg', 'appoi_section', 'Section Detail Box');

$wp_customize->add_setting(
    'detailbxtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Contact Info' )
    )
);
$wp_customize->add_control(
    'detailbxtitle',
    array(
        'settings'      => 'detailbxtitle',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Detail Box Title', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'inquiry_Detaibxtltclr', 'appoi_section', 'Detail Box Tilte Color', '#000');

addColorPalatOption($wp_customize, 'inquiry_Detaibxtltbrdclr', 'appoi_section', 'Detail Box Tilte Border Color', '#000');

addColorPalatOption($wp_customize, 'inquiry_Detaibxtltbgclr', 'appoi_section', 'Detail Box Tilte BG Color', '#9F9F9F');


lzCustomLable($wp_customize, 'app_detailbgimg', 'appoi_section', 'Detail Box BG Image ');

$wp_customize->add_setting(
    'app_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'app_image',
        array(
            'section' => 'appoi_section',
            'settings' => 'app_image',
            'description' => __('Recommended Image Size: 262*262', 'luzuk-premium')
        )
    )
);

addColorPalatOption($wp_customize, 'inquiry_Detaibximgbg1clr', 'appoi_section', 'Detail Box Image BG Color 1', '#FE931F');

addColorPalatOption($wp_customize, 'inquiry_Detaibximgbg2clr', 'appoi_section', 'Detail Box Image BG Color 2', '#FDAF1B');

addColorPalatOption($wp_customize, 'inquiry_Detaibximgbrdclr', 'appoi_section', 'Detail Box Image Border Color', '#FDAF1B');


$wp_customize->add_setting(
    'infphtxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+1 234 5678 090' )
    )
);
$wp_customize->add_control(
    'infphtxt',
    array(
        'settings'      => 'infphtxt',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Phone Number', 'Luzuk' )
    )
);


$wp_customize->add_setting(
    'infemiltxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'info@yourmail.com' )
    )
);
$wp_customize->add_control(
    'infemiltxt',
    array(
        'settings'      => 'infemiltxt',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Email Id', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'inftxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2400 Meacham Blvd' )
    )
);
$wp_customize->add_control(
    'inftxt',
    array(
        'settings'      => 'inftxt',
        'section'       => 'appoi_section',
        'type'          => 'textarea',
        'label'         => __( 'Address Text', 'Luzuk' )
    )
);


lzCustomLable($wp_customize, 'app_dlhsphclr', 'appoi_section', 'Detail Box Color');

addColorPalatOption($wp_customize, 'inquiry_icnbgclr', 'appoi_section', 'Icon BG Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_icnbrdclr', 'appoi_section', 'Icon Border Color', '#000');

addColorPalatOption($wp_customize, 'inquiry_icnclr', 'appoi_section', 'Icon Color', '#000');

addColorPalatOption($wp_customize, 'inquiry_icntxtclr', 'appoi_section', 'Address , Email , Phone Number Color', '#000');

addColorPalatOption($wp_customize, 'inquiry_icntxthvclr', 'appoi_section', 'Phone Number , Email Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_icntxtbgclr1', 'appoi_section', 'Icon Text BG Color 1', '#FE931F');

addColorPalatOption($wp_customize, 'inquiry_icntxtbgclr2', 'appoi_section', 'Icon Text BG Color 2', '#FDAF1B');

// ===========Form Section ==========//

lzCustomLable($wp_customize, 'contactf', 'appoi_section', 'Form Section');

lzCustomLable($wp_customize, 'app-secheading', 'appoi_section', 'Section Heading');

$wp_customize->add_setting(
    'appform_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Contact Us', 'luzuk' )
    )
);
$wp_customize->add_control(
    'appform_maintitle',
    array(
        'settings'      => 'appform_maintitle',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Form Title', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'app_secheadingclr', 'appoi_section', 'Form Title Color', '#000');

lzCustomLable($wp_customize, 'appointmentright_Form_label', 'appoi_section', 'Contact Inquiry Form Shortcode');

lzAddElement($wp_customize, 'luzuk_inquiry_shortcode', 'appoi_section', 'textarea', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');

addColorPalatOption($wp_customize, 'inquiry_formtitlebgClr1', 'appoi_section', 'Form Title BG Color 1', '#FE931F');

addColorPalatOption($wp_customize, 'inquiry_formtitlebgClr2', 'appoi_section', 'Form Title BG Color 2', '#FDAF1B');

addColorPalatOption($wp_customize, 'inquiry_formbgClr', 'appoi_section', 'Form BG Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_forminputtxtClr', 'appoi_section', 'Form Input Text / Placeholder Color', '#9F9F9F');

addColorPalatOption($wp_customize, 'inquiry_forminputbgClr', 'appoi_section', 'Form Input BG Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_forminputbrdClr', 'appoi_section', 'Form Input Border Color', '#9F9F9F');

addColorPalatOption($wp_customize, 'inquiry_formlabelColor', 'appoi_section', 'Form Label Color', '#9F9F9F');

addColorPalatOption($wp_customize, 'inquiry_formbuttontextColor', 'appoi_section', 'Form Button Text Color', '#000');

addColorPalatOption($wp_customize, 'inquiry_formbuttontexthoverColor', 'appoi_section', 'Form Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_formbuttonbgClr1', 'appoi_section', 'Form Button BG Color 1', '#FE931F');

addColorPalatOption($wp_customize, 'inquiry_formbuttonbgClr2', 'appoi_section', 'Form Button BG Color 2', '#FDAF1B');
