<?php
/**
 * Createing a bog pannel for customizer
 *
 *
 */
$categories = get_categories(array('hide_empty' => 0));
foreach ($categories as $category) {
	$cat[$category->term_id] = $category->cat_name;
}
/****************************/
// START BLOG SECTION FOR HOME PAGE
/*============BLOG PANEL============*/
$wp_customize->add_section(
	'blog_area',
	array(
		'title' => __( 'Blog Section', 'luzuk-premium' ),
		'panel' => 'luzuk_premium_home_panel',
     	//'priority' => '50',
	)
);
//ENABLE/DISABLE BLOG SECTION
$wp_customize->add_setting(
	'blog_section_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'blog_section_disable',
		array(
			'settings'      => 'blog_section_disable',
			'section'       => 'blog_area',
			'label'         => __( 'Disable Section', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk-premium' ),
				'off' => __( 'No', 'luzuk-premium' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'blog', 'blog_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'blog_area_blogsectionpadding', 'blog_area', 'Section Padding');

$wp_customize->add_setting(
    'blog_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_areaTpadding',
    array(
        'settings'      => 'blog_areaTpadding',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Top ', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'blog_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_areaBpadding',
    array(
        'settings'      => 'blog_areaBpadding',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
	'blog_title_subtitle_heading',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text'
	)
);
$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'blog_title_subtitle_heading',
		array(
			'settings'		=> 'blog_title_subtitle_heading',
			'section'       => 'blog_area',
			'label'         => __( 'Section Heading', 'luzuk-premium' ),
		)
	)
);


$wp_customize->add_setting(
	'blog_title',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'OUR', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'blog_title',
	array(
		'settings'      => 'blog_title',
		'section'       => 'blog_area',
		'type'          => 'text',
		'label'         => __( 'Section Heading 1', 'luzuk-premium' )
	)
);

addColorPalatOption($wp_customize, 'blog_Heading1', 'blog_area', 'Heading 1 Text Color', '#000');

addColorPalatOption($wp_customize, 'blog_Heading1brd', 'blog_area', 'Heading 1 Border Color', '#FFD800');

addColorPalatOption($wp_customize, 'blog_Heading1bg', 'blog_area', 'Heading 1 BG Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'blog_Heading1bgcor', 'blog_area', 'Heading 1 BG Corner Color', '#F9880D');


$wp_customize->add_setting(
	'blog_title2',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Blog', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'blog_title2',
	array(
		'settings'      => 'blog_title2',
		'section'       => 'blog_area',
		'type'          => 'text',
		'label'         => __( 'Section Heading 2', 'luzuk-premium' )
	)
);

addColorPalatOption($wp_customize, 'blog_Heading2', 'blog_area', 'Heading 2 Text Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'blog_Heading2bg', 'blog_area', 'Heading 2 BG Color', '#6B6B6B');

addColorPalatOption($wp_customize, 'blog_Heading2bgbrd1', 'blog_area', 'Heading 2 Border Color', '#9F9F9F');
addColorPalatOption($wp_customize, 'blog_Heading2bxbrd', 'blog_area', 'Heading 2 Box Border Color', '#292B2A');


lzCustomLable($wp_customize, 'blog_area_blogspost', 'blog_area', 'Number Of Post ');
//BLOG SETTINGS
$wp_customize->add_setting(
	'blog_post_count',
	array(
		'default'           => '3',
		'sanitize_callback' => 'luzuk_sanitize_choices'
	)
);
$wp_customize->add_control(
	new luzuk_Dropdown_Chooser(
		$wp_customize,
		'blog_post_count',
		array(
			'settings'      => 'blog_post_count',
			'section'       => 'blog_area',
			'label'         => __( 'Number Of Post To Show', 'luzuk-premium' ),
			'choices'       => $luzuk_post_count_choice
		)
	)
);

// $wp_customize->add_setting(
// 	'blog_cat_exclude',
// 	array(
// 		'sanitize_callback' => 'luzuk_sanitize_text'
// 	)
// );
// $wp_customize->add_control(
// 	new luzuk_Customize_Checkbox_Multiple(
// 		$wp_customize,
// 		'blog_cat_exclude',
// 		array(
// 			'label' => __('Exclude Category from Blog Posts', 'luzuk-premium'),
// 			'section' => 'blog_area',
// 			'settings' => 'blog_cat_exclude',
// 			'choices' => $luzuk_cat
// 		)
// 	)
// );
// END BLOG SECTION FOR HOME PAGE
/****************************/


// CREATING A BLOG SECTION IN CUSTOMIZER FOR BLOG PAGES
$wp_customize->add_section(
	'premium_blog_area',
	array(
		'title' => __( 'Blog Page Settings', 'luzuk-premium' ),
        // 'panel' => 'luzuk_premium_home_panel'
		'priority' =>19
	)
);

$wp_customize->add_setting('blog_categories_settings', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control('blog_categories_settings', array(
    'settings' => 'blog_categories_settings',
    'label'    => __('Posts on Blog Page', 'luzuk-premium'),
    'section'  => 'lpremium_blog_area',
    'type'     => 'radio',
    'choices'  => array(
        '0' => __('Excerpts','luzuk-premium'),
        '1' => __('Full Posts','luzuk-premium'),
    ),
));
// ADDING THE CATEGORY TO SELECT
$wp_customize->add_setting('luzuk_blog_categories', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Checkbox_Multiple(
		$wp_customize,
		'luzuk_blog_categories',
		array(
			'label' => __('Exclude Category From Blog Posts', 'luzuk-premium'),
			'section' => 'premium_blog_area',
			'settings' => 'luzuk_blog_categories',
			'choices' => $luzuk_cat
		)
	)
);

lzCustomLable($wp_customize, 'blog_area_color', 'blog_area', 'Blog Section Color');

addColorPalatOption($wp_customize, 'blogarea_imghvclr', 'blog_area', 'Image Hover Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_Title_color', 'blog_area', 'Title Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_Titlehv_clr', 'blog_area', 'Title Hover Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'blogarea_text_color', 'blog_area', 'Text Color', '#707070');

addColorPalatOption($wp_customize, 'blogarea_datebxbgclr', 'blog_area', 'Date BG Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'blogarea_datebxicnclr', 'blog_area', 'Date Box Icon Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_datebxtxtclr', 'blog_area', 'Date Box Text Color', '#000');


lzCustomLable($wp_customize, 'abtSec_btnclor', 'blog_area' , 'Section Button');

$wp_customize->add_setting(
    'blogbtn_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Read More', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'blogbtn_text',
    array(
        'settings'      => 'blogbtn_text',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'blogarea_btnarroclr', 'blog_area', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'blogarea_btnhvclr', 'blog_area', 'Button Text Hover Color', '#292B2A');

addColorPalatOption($wp_customize, 'blogarea_btnbgclr', 'blog_area', 'Button BG Color', '#292B2A');

addColorPalatOption($wp_customize, 'blogarea_btnbghvclr', 'blog_area', 'Button BG Hover Color', '#FDAF1B');
