<?php  

$wp_customize->add_section(
    'feature_area',
    array(
        'title' => __('Feature Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
  // ENABLE/DISABLE FEATURED SECTION
    $wp_customize->add_setting(
        'feature_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'feature_area_disable',
            array(
                'settings'      => 'feature_area_disable',
                'section'       => 'feature_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    );

backgroundManager($wp_customize, 'feature', 'feature_area', $color='#292B2A', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'featuresection_padding', 'feature_area', ' Section Padding ');

$wp_customize->add_setting(
    'feature_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'feature_areaTpadding',
    array(
        'settings'      => 'feature_areaTpadding',
        'section'       => 'feature_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'feature_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'feature_areaBpadding',
    array(
        'settings'      => 'feature_areaBpadding',
        'section'       => 'feature_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'feature_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'feature_title_heading',
        array(
            'settings'      => 'feature_title_heading',
            'section'       => 'feature_area',
            'label'         => __( 'Section Heading', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'feature_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'OUR', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'feature_title',
    array(
        'settings'      => 'feature_title',
        'section'       => 'feature_area',
        'type'          => 'text',
        'label'         => __( 'Heading 1', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'feature_Heading1', 'feature_area', 'Heading 1 Text Color', '#000');

addColorPalatOption($wp_customize, 'feature_Heading1brd', 'feature_area', 'Heading 1 Border Color', '#FFD800');

addColorPalatOption($wp_customize, 'feature_Heading1bg', 'feature_area', 'Heading 1 BG Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'feature_Heading1bgcor', 'feature_area', 'Heading 1 BG Corner Color', '#F9880D');

$wp_customize->add_setting(
    'fea_title2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Feature', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'fea_title2',
    array(
        'settings'      => 'fea_title2',
        'section'       => 'feature_area',
        'type'          => 'text',
        'label'         => __( 'Heading 2', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'feature_Heading2', 'feature_area', 'Heading 2 Text Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'feature_Heading2bg', 'feature_area', 'Heading 2 BG Color', '#6B6B6B');

addColorPalatOption($wp_customize, 'feature_Heading2bgbrd1', 'feature_area', 'Heading 2 Border Color', '#9F9F9F');
addColorPalatOption($wp_customize, 'feature_Heading2bxbrd', 'feature_area', 'Heading 2 Box Border Color', '#292B2A');

$wp_customize->add_setting('feature_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'feature_npp_heading',
        array(
            'settings'      => 'feature_npp_heading',
            'section'       => 'feature_area',
            'label'         => __( 'Number Of Feature To Show', 'Luzuk Premium' ),
        )
    )
);    
$wp_customize->add_setting('feature_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'feature_npp_count',
    array(
        'settings'      => 'feature_npp_count',
        'section'       => 'feature_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Feature To Show', 'Luzuk Premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8)
    )
);

//FEATURED PAGES
for( $i = 1; $i <= 8; $i++ ){
    $wp_customize->add_setting(
        'feature_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'feature_header'.$i,
            array(
                'settings'      => 'feature_header'.$i,
                'section'       => 'feature_area',
                'label'         => __( 'Feature Box ', 'Luzuk Premium' ).$i
            )
        )
    );

        $wp_customize->add_setting(
        'feature_page_icon'.$i,
        array(
            'default'           => 'fa fa-wrench',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'feature_page_icon'.$i,
            array(
                'settings'      => 'feature_page_icon'.$i,
                'section'       => 'feature_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'Luzuk Premium' ),
            )
        )
    );


lzAddElement($wp_customize, 'feature_page_title'.$i, 'feature_area', $type = 'text', $label="Feature Title", $callback ='luzuk_sanitize_text', $default='Maintenance');

lzAddElement($wp_customize, 'feature_page_txt'.$i, 'feature_area', $type = 'textarea', $label="Feature Text", $callback ='luzuk_sanitize_text', $default='Vivamus consequat eu erat nec tincidunt. Donec posuere lobortis lorem, et dapibus orci consequat.');
    
}


lzCustomLable($wp_customize, 'feature_sectioncolor', 'feature_area', 'Feature Section Color');

addColorPalatOption($wp_customize, 'feature_icnClr', 'feature_area', 'Icon Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'feature_icnbrdClr', 'feature_area', 'Icon Border Color', '#292B2A');

addColorPalatOption($wp_customize, 'feature_icnBGClr', 'feature_area', 'Icon BG Color', '#fff');

addColorPalatOption($wp_customize, 'feature_conbxBGClr', 'feature_area', 'Content BG Color', '#E8E8E8');

addColorPalatOption($wp_customize, 'feature_conBGhvClr', 'feature_area', 'Content Box BG Hover Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'feature_conbxBrdClr', 'feature_area', 'content Box Border Color', '#FDAF1B');
addColorPalatOption($wp_customize, 'feature_titleClr', 'feature_area', 'Title Color', '#292B2A');
addColorPalatOption($wp_customize, 'feature_txtClr', 'feature_area', 'Text Color', '#707070');
