<?php
$wp_customize->add_section(
    'newsletter_area',
    array(
        'title' => __('Newsletter Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
$wp_customize->add_setting(
    'newsletter_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'newsletter_area_disable',
        array(
            'settings'      => 'newsletter_area_disable',
            'section'       => 'newsletter_area',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'newsletter', 'newsletter_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'newsletterarea_padding', 'newsletter_area', 'Section Padding');

$wp_customize->add_setting(
    'newsletter_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_areaTpadding',
    array(
        'settings'      => 'newsletter_areaTpadding',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'newsletter_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_areaBpadding',
    array(
        'settings'      => 'newsletter_areaBpadding',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'newsletter_page_maintitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'newsletter_page_maintitle_heading',
        array(
            'settings'      => 'newsletter_page_maintitle_heading',
            'section'       => 'newsletter_area',
            'label'         => __( 'Section Heading', 'luzuk-premium' ),
        )
    )
);    
 

$wp_customize->add_setting(
    'newsletter_page_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Subscribe to our newsletter', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_page_maintitle',
    array(
        'settings'      => 'newsletter_page_maintitle',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'newsletter_titleclr', 'newsletter_area', 'Section Heading Color', '#fff');

addColorPalatOption($wp_customize, 'news_titlebgclr', 'newsletter_area', 'Section Heading BG Color 1', '#292B2A');

addColorPalatOption($wp_customize, 'news_titlebg2clr', 'newsletter_area', 'Section Heading BG Color 2', '#fff');

addColorPalatOption($wp_customize, 'news_titlebg3clr', 'newsletter_area', 'Section Heading BG Color 3', '#FE931F');

addColorPalatOption($wp_customize, 'news_titlebg4clr', 'newsletter_area', 'Section Heading BG Color 4', '#FDAF1B');

lzCustomLable($wp_customize, 'newsletter_Form_label', 'newsletter_area', 'Newsletter Form Shortcode');

lzAddElement($wp_customize, 'luzuk_newsletter_shortcode', 'newsletter_area', 'textarea', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');

addColorPalatOption($wp_customize, 'newsletter_forminputtextColor', 'newsletter_area', 'Form Input text / Placeholder Color', '#999999');

addColorPalatOption($wp_customize, 'newsletter_forminputbgColor', 'newsletter_area', 'Form Input Background Color', '#fff');

addColorPalatOption($wp_customize, 'newsletter_formlabelColor', 'newsletter_area', 'Form Label Color', '#fff');

addColorPalatOption($wp_customize, 'newsletter_formbuttontextColor', 'newsletter_area', 'Form Button Text Color', '#000');

addColorPalatOption($wp_customize, 'newsletter_formbuttontexthoverColor', 'newsletter_area', 'Form Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'news_fmbnbgClr1', 'newsletter_area', 'Form Button Background Color 1', '#FE931F');

addColorPalatOption($wp_customize, 'news_fmbnbgClr2', 'newsletter_area', 'Form Button Background Color 2', '#FDAF1B');


lzCustomLable($wp_customize, 'newsletter_lblImgTxt', 'newsletter_area' , 'Social Media');

// FACEBOOK 
$wp_customize->add_setting('newsletter_fb', array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('newsletter_fb',
    array(
        'settings'      => 'newsletter_fb',
        'section'       => 'newsletter_area',
        'type'          => 'url',
        'label'         => __( 'Facebook Url', 'luzuk-premium' )
    )
);


// Instagram
$wp_customize->add_setting('newsletter_insta',array('default'=> 'https://www.instagram.com/','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('newsletter_insta',
    array(
        'settings'      => 'newsletter_insta',
        'section'       => 'newsletter_area',
        'type'          => 'url',
        'label'         => __( 'Instagram Url', 'luzuk-premium' )
    )
);

// TWITTER
$wp_customize->add_setting('newsletter_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('newsletter_tw',
    array(
        'settings'      => 'newsletter_tw',
        'section'       => 'newsletter_area',
        'type'          => 'url',
        'label'         => __( 'Twitter Url', 'luzuk-premium' )
    )
);

// pinterest
$wp_customize->add_setting('newsletter_pint',array('default'=> 'https://in.pinterest.com/','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('newsletter_pint',
    array(
        'settings'      => 'newsletter_pint',
        'section'       => 'newsletter_area',
        'type'          => 'url',
        'label'         => __( 'Pinterest Url', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'newsletter_sclicnbgClr', 'newsletter_area', 'Social Icon BG Color', '#000');

addColorPalatOption($wp_customize, 'newsletter_sclicnClr', 'newsletter_area', 'Social Icon Color', '#fff');

addColorPalatOption($wp_customize, 'newsletter_sclicnhvClr', 'newsletter_area', 'Social Icon Hover Color', '#FE931F');