<?php 
$wp_customize->add_section(
    'project_area',
    array(
        'title'         => __( 'Projects Section', 'luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
$wp_customize->add_setting(
    'project_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'project_area_disable',
        array(
            'settings'      => 'project_area_disable',
            'section'       => 'project_area',
            'label'         => __( 'Disable Section', 'luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk' ),
                'off' => __( 'No', 'luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'project', 'project_area', $color='#292B2A', get_template_directory_uri().'/images/default.png', 'img');


lzCustomLable($wp_customize, 'luzuk_sec_projectssectionpadding', 'project_area', 'Section Padding');

$wp_customize->add_setting(
    'project_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'project_areaTpadding',
    array(
        'settings'      => 'project_areaTpadding',
        'section'       => 'project_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'project_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'project_areaBpadding',
    array(
        'settings'      => 'project_areaBpadding',
        'section'       => 'project_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'projtitle1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'OUR', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'projtitle1',
    array(
        'settings'      => 'projtitle1',
        'section'       => 'project_area',
        'type'          => 'text',
        'label'         => __( 'Heading 1', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'project_Heading1', 'project_area', 'Heading 1 Text Color', '#000');

addColorPalatOption($wp_customize, 'project_Heading1brd', 'project_area', 'Heading 1 Border Color', '#FFD800');

addColorPalatOption($wp_customize, 'project_Heading1bg', 'project_area', 'Heading 1 BG Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'project_Heading1bgcor', 'project_area', 'Heading 1 BG Corner Color', '#F9880D');

$wp_customize->add_setting(
    'proj_title2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Project', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'proj_title2',
    array(
        'settings'      => 'proj_title2',
        'section'       => 'project_area',
        'type'          => 'text',
        'label'         => __( 'Heading 2', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'project_Heading2', 'project_area', 'Heading 2 Text Color', '#FDAF1B');
addColorPalatOption($wp_customize, 'project_Heading2bg', 'project_area', 'Heading 2 BG Color', '#6B6B6B');
addColorPalatOption($wp_customize, 'project_Heading2bgbrd1', 'project_area', 'Heading 2 Border Color', '#9F9F9F');
addColorPalatOption($wp_customize, 'project_Heading2bxbrd', 'project_area', 'Heading 2 Box Border Color', '#292B2A');

$wp_customize->add_setting(
    'proj_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Some of our project done by us.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'proj_subtitle',
    array(
        'settings'      => 'proj_subtitle',
        'section'       => 'project_area',
        'type'          => 'text',
        'label'         => __( 'Sub Title', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'project_SubTitleclr', 'project_area', 'Sub Title Color', '#fff');

$wp_customize->add_setting(
    'proj_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Maecenas interdum suscipit nibh in malesuada. Sed quis purus eu urna venenatis egestas. Suspendisse nulla velit, tincidunt ornare lacinia a, gravida at felis. Nam auctor leo at erat rhoncus facilisis. Ut tincidunt vehicula ultricies. Etiam varius dolor nisi, et dictum quam porta in.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'proj_txt',
    array(
        'settings'      => 'proj_txt',
        'section'       => 'project_area',
        'type'          => 'textarea',
        'label'         => __( 'Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'project_Textclr', 'project_area', 'Text Color', '#AAAAAA');

$wp_customize->add_setting('project_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'project_area_lbl2',
        array(
            'settings'      => 'project_area_lbl2',
            'section'       => 'project_area',
            'label'         => __( 'Note 2 :', 'luzuk' ),  
            'description'   => __( 'Use Shortcode [PROJECT] to show all projects in a page', 'luzuk' ),
        )
    )
);


$wp_customize->add_setting('project_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'project_npp_heading',
        array(
            'settings'      => 'project_npp_heading',
            'section'       => 'project_area',
            'label'         => __( 'Number Of projects To Show', 'luzuk' ),
        )
    )
);    
$wp_customize->add_setting('project_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'project_npp_count',
    array(
        'settings'      => 'project_npp_count',
        'section'       => 'project_area',
        'type'          => 'select',
        'label'         => __( 'Number Of projects To Show', 'luzuk' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

$projectsSingleChoice[] = 'Select';

for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'projects_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'projects_heading'.$i,
            array(
                'settings'      => 'projects_heading'.$i,
                'section'       => 'project_area',
                'label'         => __( 'project ', 'luzuk' ).$i,
            )
        )
    );
    if(is_array($projectsSingleChoice)){
        $wp_customize->add_setting(
            'projects_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'projects_page'.$i,
            array(
                'settings'      => 'projects_page'.$i,
                'section'       => 'project_area',
                'type'=> 'select',
                'label'         => __( 'Select A project Box ', 'luzuk' ),
                'choices' => $projectsSingleChoice,
            )
        );

// $wp_customize->add_setting(
//         'projects_page_icon1'.$i,
//         array(
//             'default'           => 'fa fa-user-o',
//             'sanitize_callback' => 'luzuk_sanitize_text'
//         )
//     );        
//     $wp_customize->add_control(
//         new luzuk_Fontawesome_Icon_Chooser(
//             $wp_customize,
//             'projects_page_icon1'.$i,
//             array(
//                 'settings'      => 'projects_page_icon1'.$i,
//                 'section'       => 'project_area',
//                 'type'          => 'icon',
//                 'label'         => __( 'FontAwesome Icon', 'luzuk' ),
//             )
//         )
//     );



    }else{
        $wp_customize->add_setting('project_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'project_area_lbl'.$i,
                array(
                    'settings'      => 'project_area_lbl'.$i,
                    'section'       => 'project_area',
                    'label'         => __( 'Note:', 'luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the project Page.</strong> <br/>Please add the projects from "projects menu" and then select projects to show information.', 'luzuk' ),
                )
            )
        );
    }
}


addColorPalatOption($wp_customize, 'projectimgbrdclr', 'project_area', 'Image Border Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'projecttitlbgclr', 'project_area', 'Title Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'projecttitlbgbrdclr', 'project_area', 'Title Box Brd Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'projecttitlclr', 'project_area', 'Title Color', '#000');


lzCustomLable($wp_customize, 'luzuk_secprojectsbtnclr', 'project_area', 'Slider Arrow Color');


addColorPalatOption($wp_customize, 'proj_slidebtnbgclr', 'project_area', 'Section Slider Arrow BG Color ','#FDAF1B');

addColorPalatOption($wp_customize, 'proj_slidebtnicnclr', 'project_area', 'Section Slider Arrow Icon Color ','#fff');

addColorPalatOption($wp_customize, 'proj_slidebtnicnhvclr', 'project_area', 'Section Slider Arrow Icon Hover Color ','#6B6B6B');